/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.awt;

import io.humble.video.MediaPicture;
import io.humble.video.PixelFormat;
import io.humble.video.awt.BgrConverter;
import io.humble.video.awt.MediaPictureConverter;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediaPictureConverterFactory {
    public static final String HUMBLE_BGR_24 = "HUMBLE-BGR-24";
    private static Map<String, Type> mConverterTypes = new HashMap<String, Type>();

    protected MediaPictureConverterFactory() {
    }

    public static Type registerConverter(Type converterType) {
        return mConverterTypes.put(converterType.getDescriptor(), converterType);
    }

    public static Type unregisterConverter(Type converterType) {
        return mConverterTypes.remove(converterType.getDescriptor());
    }

    public static Collection<Type> getRegisteredConverters() {
        return Collections.unmodifiableCollection(mConverterTypes.values());
    }

    public static Type findRegisteredConverter(String descriptor) {
        return mConverterTypes.get(descriptor);
    }

    public static String findDescriptor(BufferedImage image) {
        for (Type converterType : MediaPictureConverterFactory.getRegisteredConverters()) {
            if (converterType.getImageType() != image.getType()) continue;
            return converterType.getDescriptor();
        }
        return null;
    }

    public static MediaPictureConverter createConverter(String converterDescriptor, MediaPicture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("The picture is NULL.");
        }
        return MediaPictureConverterFactory.createConverter(converterDescriptor, picture.getFormat(), picture.getWidth(), picture.getHeight());
    }

    public static MediaPictureConverter createConverter(BufferedImage image, MediaPicture picture) {
        if (image == null) {
            throw new IllegalArgumentException("cannot pass null image");
        }
        if (picture == null) {
            throw new IllegalArgumentException("cannot pass null picture");
        }
        return MediaPictureConverterFactory.createConverter(image, picture.getFormat());
    }

    public static MediaPictureConverter createConverter(BufferedImage image, PixelFormat.Type pictureType) {
        if (image == null) {
            throw new IllegalArgumentException("The image is NULL.");
        }
        String converterDescriptor = MediaPictureConverterFactory.findDescriptor(image);
        if (converterDescriptor == null) {
            throw new UnsupportedOperationException("No converter found for BufferedImage type #" + image.getType());
        }
        return MediaPictureConverterFactory.createConverter(converterDescriptor, pictureType, image.getWidth(), image.getHeight());
    }

    public static MediaPictureConverter createConverter(String converterDescriptor, PixelFormat.Type pictureType, int width, int height) {
        return MediaPictureConverterFactory.createConverter(converterDescriptor, pictureType, width, height, width, height);
    }

    public static MediaPictureConverter createConverter(String converterDescriptor, PixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        MediaPictureConverter converter = null;
        Type converterType = MediaPictureConverterFactory.findRegisteredConverter(converterDescriptor);
        if (null == converterType) {
            throw new UnsupportedOperationException("No converter \"" + converterDescriptor + "\" found.");
        }
        try {
            Constructor<? extends MediaPictureConverter> converterConstructor = converterType.getConverterClass().getConstructor(PixelFormat.Type.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            converter = converterConstructor.newInstance(new Object[]{pictureType, pictureWidth, pictureHeight, imageWidth, imageHeight});
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " requries a constructor of the form " + "(PixelFormat.Type, int, int, int, int)");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            throw new UnsupportedOperationException("Converter " + converterType.getConverterClass() + " constructor failed with: " + e.getCause());
        }
        return converter;
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    static {
        MediaPictureConverterFactory.registerConverter(new Type(HUMBLE_BGR_24, BgrConverter.class, PixelFormat.Type.PIX_FMT_BGR24, 5));
    }

    public static class Type {
        private final String mDescriptor;
        private final Class<? extends MediaPictureConverter> mConverterClass;
        private final PixelFormat.Type mPictureType;
        private final int mImageType;

        public Type(String descriptor, Class<? extends MediaPictureConverter> converterClass, PixelFormat.Type pictureType, int imageType) {
            this.mDescriptor = descriptor;
            this.mConverterClass = converterClass;
            this.mPictureType = pictureType;
            this.mImageType = imageType;
        }

        public String getDescriptor() {
            return this.mDescriptor;
        }

        public Class<? extends MediaPictureConverter> getConverterClass() {
            return this.mConverterClass;
        }

        public PixelFormat.Type getPictureType() {
            return this.mPictureType;
        }

        public int getImageType() {
            return this.mImageType;
        }

        public String toString() {
            return this.getDescriptor() + ": picture type " + (Object)((Object)this.getPictureType()) + ", image type " + this.getImageType();
        }
    }
}

