/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.javaxsound;

import io.humble.ferry.Buffer;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.MediaAudio;
import io.humble.video.MediaAudioResampler;
import io.humble.video.javaxsound.MediaAudioConverter;
import java.nio.ByteBuffer;

class StereoS16AudioConverter
implements MediaAudioConverter {
    private final int mJavaSampleRate;
    private final int mJavaChannels;
    private final AudioChannel.Layout mJavaLayout;
    private final AudioFormat.Type mJavaFormat;
    private final int mMediaSampleRate;
    private final int mMediaChannels;
    private final AudioChannel.Layout mMediaLayout;
    private final AudioFormat.Type mMediaFormat;
    private final MediaAudioResampler mMediaAudioToJavaSoundResampler;
    private MediaAudio mResampledAudio;

    public StereoS16AudioConverter(int sampleRate, AudioChannel.Layout layout, AudioFormat.Type format) {
        if (sampleRate < 0) {
            throw new IllegalArgumentException("sample rate must be > 0");
        }
        if (layout == AudioChannel.Layout.CH_LAYOUT_UNKNOWN) {
            throw new IllegalArgumentException("channel layout must be known");
        }
        this.mJavaSampleRate = 22050;
        this.mJavaFormat = AudioFormat.Type.SAMPLE_FMT_S16;
        this.mJavaLayout = AudioChannel.Layout.CH_LAYOUT_STEREO;
        this.mJavaChannels = AudioChannel.getNumChannelsInLayout(this.mJavaLayout);
        this.mMediaSampleRate = sampleRate;
        this.mMediaLayout = layout;
        this.mMediaChannels = AudioChannel.getNumChannelsInLayout(layout);
        this.mMediaFormat = format;
        if (this.willResample()) {
            this.mMediaAudioToJavaSoundResampler = MediaAudioResampler.make(this.mJavaLayout, this.mJavaSampleRate, this.mJavaFormat, this.mMediaLayout, this.mMediaSampleRate, this.mMediaFormat);
            this.mMediaAudioToJavaSoundResampler.open();
        } else {
            this.mMediaAudioToJavaSoundResampler = null;
        }
    }

    @Override
    public javax.sound.sampled.AudioFormat getJavaFormat() {
        return new javax.sound.sampled.AudioFormat(this.mJavaSampleRate, AudioFormat.getBytesPerSample(this.mJavaFormat) * 8, this.mJavaChannels, true, false);
    }

    @Override
    public int getMediaSampleRate() {
        return this.mMediaSampleRate;
    }

    @Override
    public int getMediaChannels() {
        return this.mMediaChannels;
    }

    @Override
    public AudioChannel.Layout getMediaLayout() {
        return this.mMediaLayout;
    }

    @Override
    public AudioFormat.Type getMediaFormat() {
        return this.mMediaFormat;
    }

    private boolean willResample() {
        return this.mMediaSampleRate != this.mJavaSampleRate || this.mMediaChannels != this.mJavaChannels || this.mMediaFormat != this.mJavaFormat;
    }

    private void validateMediaAudio(MediaAudio audio) {
        if (audio == null) {
            throw new IllegalArgumentException("must pass in audio");
        }
        if (audio.getSampleRate() != this.mMediaSampleRate) {
            throw new IllegalArgumentException("input sample rate does not match value converter expected");
        }
        if (audio.getChannelLayout() != this.mMediaLayout) {
            throw new IllegalArgumentException("input channel layout does not match value converter expected");
        }
        if (audio.getFormat() != this.mMediaFormat) {
            throw new IllegalArgumentException("input sample format does not match value converter expected");
        }
        if (!audio.isComplete()) {
            throw new IllegalArgumentException("input audio is not complete");
        }
    }

    @Override
    public ByteBuffer toJavaAudio(ByteBuffer output, MediaAudio input) {
        MediaAudio audio;
        int outputNumSamples;
        this.validateMediaAudio(input);
        if (this.willResample()) {
            outputNumSamples = this.mMediaAudioToJavaSoundResampler.getNumResampledSamples(input.getNumSamples());
            if (this.mResampledAudio == null || this.mResampledAudio.getMaxNumSamples() < outputNumSamples) {
                if (this.mResampledAudio != null) {
                    this.mResampledAudio.delete();
                }
                this.mResampledAudio = MediaAudio.make(outputNumSamples, this.mJavaSampleRate, this.mJavaChannels, this.mJavaLayout, this.mJavaFormat);
            }
            audio = this.mResampledAudio;
        } else {
            outputNumSamples = input.getNumSamples();
            audio = input;
        }
        int size = AudioFormat.getBufferSizeNeeded(outputNumSamples, audio.getChannels(), audio.getFormat());
        if (output == null) {
            output = ByteBuffer.allocate(size);
        } else if (output.capacity() < size) {
            throw new RuntimeException("output bytes not large enough to hold data");
        }
        if (this.willResample()) {
            this.mMediaAudioToJavaSoundResampler.resample(audio, input);
        }
        Buffer buffer = audio.getData(0);
        int bufferSize = audio.getDataPlaneSize(0);
        byte[] bytes = output.array();
        buffer.get(0, bytes, 0, bufferSize);
        output.limit(size);
        output.position(0);
        buffer.delete();
        return output;
    }
}

