/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.ferry;

/**
 * Allows Java code to get data from a native buffers, and optionally modify native memory directly.<br>
 * <p> <br>
 * When accessing from Java, you can copy in and<br>
 * out ranges of buffers.  You can do this by-copy<br>
 * (which is safer but a little slower) or by-reference<br>
 * where you <b>directly access underlying C++/native<br>
 * memory from Java</b>.  Take special care if you decide<br>
 * that native access is required.<br>
 * </p><br>
 * <p><br>
 * When accessing from C++, you get direct access to<br>
 * the underlying buffer.<br>
 * </p><br>
 * <p><br>
 * To make an Buffer object that is not a Humble internal object,<br>
 * pass in null for the RefCounted parameter.<br>
 * <br>
 * </p>
 */
public class Buffer extends RefCounted {
  // Buffer.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>

  private volatile long swigCPtr;

  /**
   * <strong>
   * DO NOT USE THIS CONSTRUCTOR - USE {@link #make(RefCounted,int)} INSTEAD.
   * </strong>
   * <p>
   * Internal Only. Do not allocate this object using new.  Not part of public API.
   * </p>
   * <p>
   * Unfortunately this constructor is public because the internal
   * implementation needs it to be, but do not pass in values to this method
   * as you may end up crashing the virtual machine.
   * </p>
   *
   * @param ignore1 ignore.
   * @param ignore2 ignore.
   *
   */ 
  public Buffer(long ignore1, boolean ignore2) {
    super(FerryJNI.Buffer_SWIGUpcast(ignore1), ignore2);
    swigCPtr = ignore1;
  }
  protected Buffer(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(FerryJNI.Buffer_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(Buffer obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Releases ths instance of Buffer and frees any underlying
   * native memory.
   * <p>
   * {@inheritDoc}
   * </p> 
   */
  @Override
  public void delete()
  {
    do {} while(false); // remove a warning
    super.delete();
  }
  
  /**
   * Create a new Buffer object that is actually referring to the
   * exact same underlying Native object.
   *
   * @return the new Java object.
   */
  @Override
  public Buffer copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new Buffer(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof Buffer)
      equal = (((Buffer)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  

  private void validateArgs(Object array, int arrayLength,
      int arrayPos,
      int bufferSize,
      int bufferPos,
      int length)
  {
    if (arrayPos < 0)
      throw new IndexOutOfBoundsException();
    if (bufferPos < 0)
      throw new IndexOutOfBoundsException();
    if (length < 0)
      throw new IndexOutOfBoundsException();
    if (arrayPos+length > arrayLength)
      throw new IndexOutOfBoundsException();
    if (bufferPos + length > bufferSize)
      throw new IndexOutOfBoundsException();
  }
  
  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers bytes into this buffer from the given source array.
   * If there are more bytes to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no bytes are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which bytes are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first byte to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of bytes to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(byte[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (buffer == null)
        return;
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers bytes from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer bytes in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no bytes are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which bytes are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first byte to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of bytes to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, byte[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer buffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (buffer == null)
        return;
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers shorts into this buffer from the given source array.
   * If there are more shorts to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no shorts are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which shorts are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first short to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of shorts to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(short[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.ShortBuffer buffer = bbuffer.asShortBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers shorts from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer shorts in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no shorts are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which shorts are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first short to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of shorts to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, short[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.ShortBuffer buffer = bbuffer.asShortBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  
  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers ints into this buffer from the given source array.
   * If there are more ints to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no ints are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which ints are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first int to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of ints to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(int[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.IntBuffer buffer = bbuffer.asIntBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers ints from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer ints in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no ints are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which ints are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first int to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of ints to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, int[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.IntBuffer buffer = bbuffer.asIntBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }


  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers longs into this buffer from the given source array.
   * If there are more longs to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no longs are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which longs are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first long to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of longs to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(long[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.LongBuffer buffer = bbuffer.asLongBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers longs from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer longs in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no longs are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which longs are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first long to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of longs to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, long[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.LongBuffer buffer = bbuffer.asLongBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }
  
  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers doubles into this buffer from the given source array.
   * If there are more doubles to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no doubles are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which doubles are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first double to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of doubles to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(double[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.DoubleBuffer buffer = bbuffer.asDoubleBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers doubles from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer doubles in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no doubles are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which doubles are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first double to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of doubles to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, double[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.DoubleBuffer buffer = bbuffer.asDoubleBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers floats into this buffer from the given source array.
   * If there are more floats to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no floats are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which floats are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first float to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of floats to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(float[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.FloatBuffer buffer = bbuffer.asFloatBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers floats from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer floats in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no floats are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which floats are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first float to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of floats to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, float[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.FloatBuffer buffer = bbuffer.asFloatBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk put method.
   * <p>
   * This method transfers chars into this buffer from the given source array.
   * If there are more chars to be copied from the array than there is
   * space remaining at the specified destination offset,
   * then no chars are transferred and a java.nio.BufferOverflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and copying the bytes over, but is more efficient in
   * the {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param src The array from which chars are to be read.  Must be non null.
   * @param srcPos The offset within <code>src</code> of the first char to be read;
   *   must be non-negative and less than <code>src.length</code>
   * @param destPos The offset in the Buffer where you want to copy
   *   data to.  Must be non-negative and less than <code>getBufferSize()</code>
   * @param length The number of chars to be read from <code>src</code>;
   *  must be non-negative and no larger than <code>src.length - srcPos</code>
   *  
   * @throws NullPointerException if <code>src</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *   mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient space
   *   in this {@link Buffer}.
   *   
   */
  public void put(char[] src, int srcPos, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.CharBuffer buffer = bbuffer.asCharBuffer();
      buffer.clear();
      validateArgs(src, src.length, srcPos, buffer.limit(), destPos, length);
      buffer.position(destPos);
      buffer.put(src, srcPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }

  /**
   * Absolute bulk get method.
   * <p>
   * This method transfers chars from this {@link Buffer} into the given
   * <code>dest</code>
   * array. If there are fewer chars in the {@link Buffer} starting
   * at position <code>srcPos</code> than are required
   * to satisfy the request, then no chars are
   * transferred and a BufferUnderflowException is thrown.
   * </p>
   * <p>
   * This method is equivalent to calling {@link #getByteBuffer(int, int)}
   * yourself and reading the bytes out, but is more efficient in the
   * {@link JNIMemoryManager.MemoryModel#NATIVE_BUFFERS} memory model.
   * </p>
   * 
   * @param srcPos The offset in the Buffer where you want to start
   *        copying data from.
   *        Must be non-negative and less than <code>getBufferSize()</code>
   * @param dest The array to which chars are to be written. Must be non null.
   * @param destPos The offset within <code>dest</code> of the first char to be
   *        written; must be non-negative and less than <code>dest.length</code>
   * @param length The number of chars to be copied into <code>dest</code>; must be
   *        non-negative and no larger than <code>dest.length - destPos</code>
   * 
   * @throws NullPointerException if <code>dest</code> is null.
   * @throws IndexOutOfBoundsException if the preconditions on the arguments
   *         mentioned above are not honored.
   * @throws java.nio.BufferOverflowException if there is insufficient data in this
   *         {@link Buffer} to satisfy the request.
   * 
   */
  public void get(int srcPos, char[] dest, int destPos, int length)
  {
    java.util.concurrent.atomic.AtomicReference<JNIReference> ref =
      new java.util.concurrent.atomic.AtomicReference<JNIReference>();
    java.nio.ByteBuffer bbuffer = this.getByteBuffer(0, this.getBufferSize(),
        ref);
    
    try
    {
      if (bbuffer == null)
        return;
      java.nio.CharBuffer buffer = bbuffer.asCharBuffer();
      validateArgs(dest, dest.length, destPos, buffer.limit(), srcPos, length);
      buffer.position(srcPos);
      buffer.get(dest, destPos, length);
      return;
    }
    finally
    {
      if (ref.get() != null)
        ref.get().delete();
    }
  }


  /**
   * Returns up to length bytes, starting at offset in the underlying
   * buffer we're managing.
   *
   * <p> 
   * 
   * The buffer position, mark are initialized to zero and limit
   * is set to the maximum capacity of this buffer.  For some
   * Buffer contents, the actual usable data in this buffer will
   * be less that the limit.
   * 
   * </p>
   * <p>
   * If you want to control exactly when the underlying memory
   * beyind the returned {@link java.nio.ByteBuffer} is released,
   * use {@link #getByteBuffer(int, int, java.util.concurrent.atomic.AtomicReference)}.
   * </p>
   * @see #getByteBuffer(int, int, java.util.concurrent.atomic.AtomicReference)
   */
  public java.nio.ByteBuffer getByteBuffer(int offset, int length)
  {
    return getByteBuffer(offset, length, null);
  }

  

    /**
     * Returns up to length bytes, starting at offset in the underlying
     * buffer we're managing, and also passed back a {@link JNIReference}
     * that can optionally be used by the caller to free the underlying
     * native memory.
     *
     * <p> 
     * 
     * The buffer position, mark are initialized to zero and limit
     * is set to the maximum capacity of this buffer.  For some
     * Buffer contents, the actual usable data in this buffer will
     * be less that the limit.
     * 
     * </p>
     * <p>
     *
     * If you use this method you are accessing the direct native
     * memory associated with this buffer.  That means changes you make
     * to this buffer are immediately reflected in the underlying
     * memory.
     *    
     * </p>
     * <p>
     *
     * Once you call this method,
     * the underlying native memory allocated will not be released until
     * all references to the returned ByteBuffer are no longer reachable and
     * at least one call to {@link JNIMemoryManager#gc()} has been
     * performed.  You can force the memory to be collect earlier
     * by using the {@link JNIReference} value returned when you
     * call this method.
     * </p><p>
     *  The {@link JNIMemoryManager#gc()} is called whenever
     * Humble Video tries to allocate new memory for any Humble interface,
     * so normally you don't need to care about this.  If for some
     * reason no other Humble object is ever allocated, every
     * Humble object has
     * a finalizer as well that will do the right thing.
     *
     * </p>
     * <p>
     *
     * You can also start up
     * a separate thread to do continuously do Ferry garabage
     * collections by calling
     * {@link JNIMemoryManager#startCollectionThread()}.  This thread
     * will only wake up when it has work to do, so the overhead
     * is very low.  We don't turn it on by default since in
     * 99.999% of cases you don't need to worry about it.
     *  
     * </p>
     * 
     * @param offset The offset (in bytes) into the buffer managed by
     *   this Buffer
     * @param length The requested length (in bytes) you want to access.
     *   The buffer returned may actually be longer than length.
     * @param referenceReturn If non null, on exit 
     *   calling {@link java.util.concurrent.atomic.AtomicReference#get()}
     *   on this value will return a {@link JNIReference} you can use
     *   for explicitly de-allocating the underlying native store
     *   of the {@link java.nio.ByteBuffer}.  Call
     *   {@link JNIReference#delete()} to do that.  <strong>Warning:</strong>
     *   if you do call {@link JNIReference#delete()} on the
     *   value returned in this parameter, then the returned byte buffer
     *   will be immediately invalid.
     * @return A java.nio.ByteBuffer that directly accesses
     *   the native memory this Buffer manages, or null if
     *   error.
     */
  public java.nio.ByteBuffer getByteBuffer(int offset, int length,
      java.util.concurrent.atomic.AtomicReference<JNIReference> referenceReturn)
  {
    java.nio.ByteBuffer retval = this.java_getByteBuffer(offset, length);
    if (retval != null)
    {
      // increment the ref count of this class to reflect the
      // byte buffer
      java.util.concurrent.atomic.AtomicLong refCount =
        this.getJavaRefCount();
      refCount.incrementAndGet();
      
      // and use the byte buffer as the reference to track
      JNIReference ref = JNIReference.createNonFerryReference(
          this,
          retval, swigCPtr, refCount);
      if (referenceReturn != null)
        referenceReturn.set(ref);
      
      // and tell Java this byte buffer is in native order
      retval.order(java.nio.ByteOrder.nativeOrder());
      retval.position(0);
      retval.mark();
      retval.limit(this.getBufferSize());
    }
    return retval;
  }

  /**
   * Prints the same as {@link Object#toString()} but appends
   * the maximum number of bytes that will fit in this
   * {@link Buffer}, the type of the {@link Buffer}, and the maximum
   * size in units of {@link Buffer.Type} that will fit in the
   * {@link Buffer}.
   * {@inheritDoc}
   */
  @Override
  public String toString()
  {
    final StringBuilder builder = new StringBuilder();
    builder.append(super.toString());
    builder.append("[");
    builder.append("bytes=").append(getBufferSize()).append(";");
    builder.append("type=").append(getType()).append(";");
    builder.append("size=").append(getSize()).append(";");
    builder.append("]");
    return builder.toString();
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // Buffer.swg

/**
 * Get the current maximum number of bytes that can<br>
 * be safely placed in this buffer.<br>
 * <br>
 * @return Maximum number of bytes this buffer can manage.
 */
  public int getBufferSize() {
    return FerryJNI.Buffer_getBufferSize(swigCPtr, this);
  }

/**
 * Allocate a new buffer of at least bufferSize.<br>
 * <br>
 * @param requestor An optional value telling the Buffer class what object requested it.  This is used for debugging memory leaks; it's a marker for the FERRY object (e.g. IPacket) that actually requested the buffer.  If you're not an FERRY object, pass in null here.<br>
 * @param bufferSize The minimum buffer size you're requesting in bytes; a buffer with a larger size may be returned.<br>
 * <br>
 * @return A new buffer, or null on error.
 */
  public static Buffer make(RefCounted requestor, int bufferSize) {
    long cPtr = FerryJNI.Buffer_make__SWIG_0(RefCounted.getCPtr(requestor), requestor, bufferSize);
    return (cPtr == 0) ? null : new Buffer(cPtr, false);
  }

/**
 * Get the type this buffer was created as.<br>
 * <p><br>
 * A type is really just a hint.  Like<br>
 * java.nio.ByteBuffer objects,<br>
 * Buffer objects can be cast to and from any type.<br>
 * </p><br>
 * @return the type  
 */
  public Buffer.Type getType() {
    return Buffer.Type.swigToEnum(FerryJNI.Buffer_getType(swigCPtr, this));
  }

/**
 * Reset the buffer type to a new type.<br>
 * <p><br>
 * This method does not do any data conversion, it<br>
 * just changes the reported type (so changing from<br>
 * Type#BUFFER_UINT8 to Type#BUFFER_SINT16<br>
 * is really just a "cast" operation).<br>
 * </p><br>
 * @param type the type to set to. 
 */
  public void setType(Buffer.Type type) {
    FerryJNI.Buffer_setType(swigCPtr, this, type.swigValue());
  }

/**
 * Returns the size, in bytes, of elements of given Type.<br>
 * <br>
 * @return the size in bytes.
 */
  public static int getTypeSize(Buffer.Type type) {
    return FerryJNI.Buffer_getTypeSize(type.swigValue());
  }

/**
 * Returns the size, in units of #getType() of<br>
 * this buffer.<br>
 * <br>
 * @return number of items of type #getType() that<br>
 *   will fit in this buffer.
 */
  public int getSize() {
    return FerryJNI.Buffer_getSize(swigCPtr, this);
  }

/**
 * Allocate a new buffer of at least bufferSize.<br>
 * <br>
 * @param requestor An optional value telling the Buffer class what object requested it.  This is used for debugging memory leaks; it's a marker for the FERRY object (e.g. IPacket) that actually requested the buffer.  If you're not an FERRY object, pass in null here.<br>
 * @param type The type of buffer.<br>
 * @param numElements The minimum number of elements of the specified<br>
 *                    type you will put in this buffer.<br>
 * @param zero If true, we will guarantee the buffer contains<br>
 *             only zeros.  If false, we will not (it is <br>
 *             faster to not, but then the buffer will have<br>
 *             garbage-data in it).<br>
 * <br>
 * @return A new buffer, or null on error.
 */
  public static Buffer make(RefCounted requestor, Buffer.Type type, int numElements, boolean zero) {
    long cPtr = FerryJNI.Buffer_make__SWIG_1(RefCounted.getCPtr(requestor), requestor, type.swigValue(), numElements, zero);
    return (cPtr == 0) ? null : new Buffer(cPtr, false);
  }

  private java.nio.ByteBuffer java_getByteBuffer(int offset, int length) {
    return FerryJNI.Buffer_java_getByteBuffer(swigCPtr, this, offset, length);
  }

/**
 * Returns up to length bytes, starting at offset in the<br>
 * underlying buffer we're managing.<br>
 * <p> <br>
 * This method COPIES the data into the byte array being<br>
 * returned..<br>
 * </p><p><br>
 * If you don't NEED the direct access that getByteBuffer<br>
 * offers (and most programs can in fact take the performance<br>
 * hit of the copy), we recommend you use this method.<br>
 * It's much harder to accidentally leave native memory lying<br>
 * around waiting for cleanup then.<br>
 * </p><br>
 * <br>
 * @param offset The offset (in bytes) into the buffer managed by this Buffer<br>
 * @param length The requested length (in bytes) you want to access.  The buffer returned may<br>
 *   actually be longer than length.<br>
 * <br>
 * @return A copy of the data that is in this Buffer, or null<br>
 *   if error.
 */
  public byte[] getByteArray(int offset, int length) {
    return FerryJNI.Buffer_getByteArray(swigCPtr, this, offset, length);
  }

/**
 * Allocate a new Buffer, and copy the data in buffer into<br>
 * the new Buffer object.<br>
 * <br>
 * @param requestor An optional value telling the Buffer class<br>
 *   what object requested it. This is used for debugging memory leaks;<br>
 *   it's a marker for the FERRY object (e.g. IPacket) that actually<br>
 *   requested the buffer. If you're not an FERRY object, pass in null here.<br>
 * @param buffer A java byte buffer for the data containing the<br>
 *   data you want to copy.<br>
 * @param offset The starting offset in buffer where you want<br>
 *   to start copying.<br>
 * @param length The total number of bytes you want to copy from buffer.<br>
 * <br>
 * @return a new Buffer object with a copy of the data in buffer,<br>
 *   or null on failure.
 */
  public static Buffer make(RefCounted requestor, byte[] buffer, int offset, int length) {
    long cPtr = FerryJNI.Buffer_make__SWIG_2(RefCounted.getCPtr(requestor), requestor, buffer, offset, length);
    return (cPtr == 0) ? null : new Buffer(cPtr, false);
  }

/**
 * Create a new Buffer object that uses the direct byte buffer<br>
 * passed in by reference (i.e. it directly uses the bytes in<br>
 * the direct byte buffer).<br>
 * <br>
 * @param requestor An optional value telling the Buffer class<br>
 *   what object requested it. This is used for debugging memory leaks;<br>
 *   it's a marker for the FERRY object (e.g. IPacket) that actually<br>
 *   requested the buffer. If you're not an FERRY object, pass in null here.<br>
 * @param directByteBuffer A direct java.nio.ByteBuffer object<br>
 *   you want to use for your memory.  This must be a direct object --<br>
 *   non direct objects will result in an JVM-dependent exception<br>
 *   being thrown. <br>
 * @param offset The starting offset in directByteBuffer where you want<br>
 *   to start copying.<br>
 * @param length The total number of bytes you want to copy from<br>
 *   directByteBuffer.<br>
 * <br>
 * @return a new Buffer object that is using directByteBuffer<br>
 *   behind the scenes, or null on failure.
 */
  public static Buffer make(RefCounted requestor, java.nio.ByteBuffer directByteBuffer, int offset, int length) {
    long cPtr = FerryJNI.Buffer_make__SWIG_3(RefCounted.getCPtr(requestor), requestor, directByteBuffer, offset, length);
    return (cPtr == 0) ? null : new Buffer(cPtr, false);
  }

  /**
   * Types of data that are in this buffer.
   */
  public enum Type {
    BUFFER_UINT8,
    BUFFER_SINT8,
    BUFFER_UINT16,
    BUFFER_SINT16,
    BUFFER_UINT32,
    BUFFER_SINT32,
    BUFFER_UINT64,
    BUFFER_SINT64,
    BUFFER_FLT32,
    BUFFER_DBL64,
    BUFFER_NB,
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Type swigToEnum(int swigValue) {
      Type[] swigValues = Type.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Type swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Type() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Type(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Type(Type swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
