/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * A class that defines metadata about audio formats.
 */
public class AudioFormat extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected AudioFormat(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.AudioFormat_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected AudioFormat(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.AudioFormat_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(AudioFormat obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new AudioFormat object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public AudioFormat copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new AudioFormat(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof AudioFormat)
      equal = (((AudioFormat)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
/**
 * Return the name of format, or NULL if format is not<br>
 * recognized.
 */
  public static String getName(AudioFormat.Type format) {
    return VideoJNI.AudioFormat_getName(format.swigValue());
  }

/**
 * Return a sample format corresponding to name, or SAMPLE_FMT_NONE<br>
 * on error.
 */
  public static AudioFormat.Type getFormat(String name) {
    return AudioFormat.Type.swigToEnum(VideoJNI.AudioFormat_getFormat(name));
  }

/**
 * Return the planar&lt;-&gt;packed alternative form of the given sample format, or<br>
 * SAMPLE_FMT_NONE on error. If the passed sample_fmt is already in the<br>
 * requested planar/packed format, the format returned is the same as the<br>
 * input.
 */
  public static AudioFormat.Type getAlternateSampleFormat(AudioFormat.Type sample_fmt, boolean planar) {
    return AudioFormat.Type.swigToEnum(VideoJNI.AudioFormat_getAlternateSampleFormat(sample_fmt.swigValue(), planar));
  }

/**
 * Get the packed alternative form of the given sample format.<br>
 * <br>
 * If the passed sample_fmt is already in packed format, the format returned is<br>
 * the same as the input.<br>
 * <br>
 * @return the packed alternative form of the given sample format or<br>
 * AV_SAMPLE_FMT_NONE on error.
 */
  public static AudioFormat.Type getPackedSampleFormat(AudioFormat.Type sample_fmt) {
    return AudioFormat.Type.swigToEnum(VideoJNI.AudioFormat_getPackedSampleFormat(sample_fmt.swigValue()));
  }

/**
 * Get the planar alternative form of the given sample format.<br>
 * <br>
 * If the passed sample_fmt is already in planar format, the format returned is<br>
 * the same as the input.<br>
 * <br>
 * @return the planar alternative form of the given sample format or<br>
 * SAMPLE_FMT_NONE on error.
 */
  public static AudioFormat.Type getPlanarSampleFormat(AudioFormat.Type sample_fmt) {
    return AudioFormat.Type.swigToEnum(VideoJNI.AudioFormat_getPlanarSampleFormat(sample_fmt.swigValue()));
  }

/**
 * Return number of bytes per sample.<br>
 * <br>
 * @param sample_fmt the sample format<br>
 * @return number of bytes per sample or zero if unknown for the given<br>
 * sample format
 */
  public static int getBytesPerSample(AudioFormat.Type sample_fmt) {
    return VideoJNI.AudioFormat_getBytesPerSample(sample_fmt.swigValue());
  }

/**
 * Check if the sample format is planar.<br>
 * <br>
 * @param sample_fmt the sample format to inspect<br>
 * @return 1 if the sample format is planar, 0 if it is interleaved
 */
  public static boolean isPlanar(AudioFormat.Type sample_fmt) {
    return VideoJNI.AudioFormat_isPlanar(sample_fmt.swigValue());
  }

/**
 * Get the size of a buffer in bytes that would be required to hold the<br>
 * number of samples of audio in the given format and with the given number of channels.
 */
  public static int getBufferSizeNeeded(int numSamples, int numChannels, AudioFormat.Type format) {
    return VideoJNI.AudioFormat_getBufferSizeNeeded(numSamples, numChannels, format.swigValue());
  }

/**
 * Get the size of a plane of audio bytes that would be required to hold the<br>
 * number of samples of audio in the given format and with the given number of channels.<br>
 * <p><br>
 * If format is packed, then this method returns the same number as #getBufferSizeNeeded(int, int, Type).<br>
 * </p>
 */
  public static int getDataPlaneSizeNeeded(int numSamples, int numChannels, AudioFormat.Type format) {
    return VideoJNI.AudioFormat_getDataPlaneSizeNeeded(numSamples, numChannels, format.swigValue());
  }

  /**
   * The format we use to represent audio.
   */
  public enum Type {
  /**
   * No format 
   */
    SAMPLE_FMT_NONE(VideoJNI.AudioFormat_SAMPLE_FMT_NONE_get()),
  /**
   * unsigned 8 bits 
   */
    SAMPLE_FMT_U8(VideoJNI.AudioFormat_SAMPLE_FMT_U8_get()),
  /**
   * signed 16 bits 
   */
    SAMPLE_FMT_S16(VideoJNI.AudioFormat_SAMPLE_FMT_S16_get()),
  /**
   * signed 32 bits 
   */
    SAMPLE_FMT_S32(VideoJNI.AudioFormat_SAMPLE_FMT_S32_get()),
  /**
   * float 
   */
    SAMPLE_FMT_FLT(VideoJNI.AudioFormat_SAMPLE_FMT_FLT_get()),
  /**
   * double 
   */
    SAMPLE_FMT_DBL(VideoJNI.AudioFormat_SAMPLE_FMT_DBL_get()),
  /**
   * unsigned 8 bits, planar 
   */
    SAMPLE_FMT_U8P(VideoJNI.AudioFormat_SAMPLE_FMT_U8P_get()),
  /**
   * signed 16 bits, planar 
   */
    SAMPLE_FMT_S16P(VideoJNI.AudioFormat_SAMPLE_FMT_S16P_get()),
  /**
   * signed 32 bits, planar 
   */
    SAMPLE_FMT_S32P(VideoJNI.AudioFormat_SAMPLE_FMT_S32P_get()),
  /**
   * float, planar 
   */
    SAMPLE_FMT_FLTP(VideoJNI.AudioFormat_SAMPLE_FMT_FLTP_get()),
  /**
   * double, planar 
   */
    SAMPLE_FMT_DBLP(VideoJNI.AudioFormat_SAMPLE_FMT_DBLP_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Type swigToEnum(int swigValue) {
      Type[] swigValues = Type.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Type swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Type() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Type(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Type(Type swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
