/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * Takes a bit stream and filters bytes passed<br>
 * in to add, remove, or modify the bit-stream.
 */
public class BitStreamFilter extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected BitStreamFilter(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.BitStreamFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected BitStreamFilter(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.BitStreamFilter_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(BitStreamFilter obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new BitStreamFilter object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public BitStreamFilter copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new BitStreamFilter(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof BitStreamFilter)
      equal = (((BitStreamFilter)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
  /**
   * info about this filter object
   * @return information about this object
   */
   
  @Override
  public String toString()
  {
    StringBuilder result = new StringBuilder();
    
    result.append(this.getClass().getName()+"@"+hashCode()+"[");
    result.append("name:"+getName()+";");
    result.append("]");
    return result.toString();
  }
  

/**
 * Create a filter given the name.<br>
 * <br>
 * @param filtername The name of the filter.<br>
 * <br>
 * @see BitStreamFilterType
 */
  public static BitStreamFilter make(String filtername) {
    long cPtr = VideoJNI.BitStreamFilter_make__SWIG_0(filtername);
    return (cPtr == 0) ? null : new BitStreamFilter(cPtr, false);
  }

/**
 * Create a filter given the type.<br>
 * <br>
 * @param type The type of the filter.<br>
 * <br>
 * @see BitStreamFilterType
 */
  public static BitStreamFilter make(BitStreamFilterType type) {
    long cPtr = VideoJNI.BitStreamFilter_make__SWIG_1(BitStreamFilterType.getCPtr(type), type);
    return (cPtr == 0) ? null : new BitStreamFilter(cPtr, false);
  }

/**
 * Get the type of this filter.
 */
  public BitStreamFilterType getType() {
    long cPtr = VideoJNI.BitStreamFilter_getType(swigCPtr, this);
    return (cPtr == 0) ? null : new BitStreamFilterType(cPtr, false);
  }

/**
 * Get the name of this filter.
 */
  public String getName() {
    return VideoJNI.BitStreamFilter_getName(swigCPtr, this);
  }

/**
 * Filter the input buffer into the output buffer.<br>
 * <br>
 * @param output The output buffer to copy filtered bytes to.<br>
 * @param outputOffset The offset in output to copy data into.<br>
 * @param input The input buffer to filter.<br>
 * @param inputOffset The number of bytes into input to start filtering at.<br>
 * @param inputSize The number of bytes (from inputOffset) to filter.<br>
 * @param coder The Coder context belong to the Stream that this data will eventually get outputted to.<br>
 * @param args String arguments for the filter call. See the FFmpeg documentation or source code.<br>
 * @param isKey Does this data represent a key packet.<br>
 * <br>
 * @return The number of bytes copied into output once filtering is done.<br>
 * <br>
 * @throws InvalidArgument if any parameters are invalid.<br>
 * @throws FfmpegException if the filtering fails for any reason.
 */
  public int filter(Buffer output, int outputOffset, Buffer input, int inputOffset, int inputSize, Coder coder, String args, boolean isKey) {
    return VideoJNI.BitStreamFilter_filter__SWIG_0(swigCPtr, this, Buffer.getCPtr(output), output, outputOffset, Buffer.getCPtr(input), input, inputOffset, inputSize, Coder.getCPtr(coder), coder, args, isKey);
  }

/**
 * Filters a packet in place (i.e. the prior contents will be replaced<br>
 * with the filtered data).<br>
 * <br>
 * This method assumes packet.getCoder() is the coder that is being used<br>
 * for outputting the packet to a stream. If this is not the case, use<br>
 * the other filter mechanism and construct packets yourself.<br>
 * <br>
 * @param packet The packet to filter in place.<br>
 * @param args Text arguments for the filter.<br>
 * <br>
 * @throws InvalidArgument if output is null.<br>
 * @throws InvalidArgument if input is null or not complete.
 */
  public void filter(MediaPacket packet, String args) {
    VideoJNI.BitStreamFilter_filter__SWIG_1(swigCPtr, this, MediaPacket.getCPtr(packet), packet, args);
  }

}
