/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * A Filter that can convert one MediaRaw object into zero or more other<br>
 * MediaRaw objects.
 */
public class Filter extends Configurable {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected Filter(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.Filter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected Filter(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.Filter_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(Filter obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new Filter object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public Filter copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new Filter(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof Filter)
      equal = (((Filter)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  

/**
 *  @return name of filter.
 */
  public String getName() {
    return VideoJNI.Filter_getName(swigCPtr, this);
  }

/**
 * @return number of inputs this FilterType expects.
 */
  public int getNumInputs() {
    return VideoJNI.Filter_getNumInputs(swigCPtr, this);
  }

/**
 * @param index which input to get name of<br>
 * @return the input name<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public String getInputName(int index) {
    return VideoJNI.Filter_getInputName(swigCPtr, this, index);
  }

/**
 * @param index which input to get type of<br>
 * @return the input media type<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public MediaDescriptor.Type getInputType(int index) {
    return MediaDescriptor.Type.swigToEnum(VideoJNI.Filter_getInputType(swigCPtr, this, index));
  }

/**
 * @param index which input to get link of<br>
 * @return the FilterLink that is inputting into this filter at the given position.<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public FilterLink getInputLink(int index) {
    long cPtr = VideoJNI.Filter_getInputLink(swigCPtr, this, index);
    return (cPtr == 0) ? null : new FilterLink(cPtr, false);
  }

/**
 * @return number of outputs this FilterType expects.
 */
  public int getNumOutputs() {
    return VideoJNI.Filter_getNumOutputs(swigCPtr, this);
  }

/**
 * @param index which output to get name of<br>
 * @return the output name<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumOutputs().
 */
  public String getOutputName(int index) {
    return VideoJNI.Filter_getOutputName(swigCPtr, this, index);
  }

/**
 * @param index which output to get type of<br>
 * @return the output media type<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumOutputs().
 */
  public MediaDescriptor.Type getOutputType(int index) {
    return MediaDescriptor.Type.swigToEnum(VideoJNI.Filter_getOutputType(swigCPtr, this, index));
  }

/**
 * @param index which output to get link of<br>
 * @return the FilterLink that is outputting from this filter at the given position.<br>
 * @throws InvalidArgument if index &lt; 0 || index &gt; #getNumInputs().
 */
  public FilterLink getOutputLink(int index) {
    long cPtr = VideoJNI.Filter_getOutputLink(swigCPtr, this, index);
    return (cPtr == 0) ? null : new FilterLink(cPtr, false);
  }

/**
 * @return the graph this filter is part of.
 */
  public FilterGraph getGraph() {
    long cPtr = VideoJNI.Filter_getGraph(swigCPtr, this);
    return (cPtr == 0) ? null : new FilterGraph(cPtr, false);
  }

  /**
   * Flags that can be passed when processing commands.
   */
  public enum CommandFlag {
  /**
   * Stop once a filter understood the command (for target=all for example), fast filters are favored automatically
   */
    COMMAND_FLAG_ONE(VideoJNI.Filter_COMMAND_FLAG_ONE_get()),
  /**
   * Only execute command when its fast (like a video out that supports contrast adjustment in hw)
   */
    COMMAND_FLAG_FAST(VideoJNI.Filter_COMMAND_FLAG_FAST_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static CommandFlag swigToEnum(int swigValue) {
      CommandFlag[] swigValues = CommandFlag.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (CommandFlag swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + CommandFlag.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private CommandFlag() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private CommandFlag(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private CommandFlag(CommandFlag swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
