/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * An index entry for a Stream.<br>
 * <p><br>
 * Some ContainerFormats can maintain index of where key-frames<br>
 * (and other interesting frames) can be found in a byte-stream.<br>
 * This is really helpful for implementing efficient seeking (for<br>
 * example, you can find all index entries near a desired timestamp,<br>
 * and you'll find the nearest key-frame).<br>
 * </p><br>
 * <p><br>
 * We don't maintain a complete list of all ContainerFormats that support<br>
 * index, but if they do, you can query the Stream#getNumIndexEntries()<br>
 * method to find how many entires are in the index.  Some ContainerFormats can<br>
 * parse the relevant Container message if an index is embedded in the<br>
 * container (for example, the MOV and MP4 demuxer can do this).  Other<br>
 * ContainerFormats can create an index automatically as they read the file,<br>
 * even if an index is not embedded in the container (for example the FLV<br>
 * demuxer does this).<br>
 * </p><br>
 * <br>
 * @see Stream#findTimeStampEntryInIndex(int,int)<br>
 * @see Stream#findTimeStampPositionInIndex(int,int)<br>
 * @see Stream#getIndexEntry(int)<br>
 * @see Stream#getNumIndexEntries()<br>
 * @see Stream#getIndexEntries()
 */
public class IndexEntry extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected IndexEntry(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.IndexEntry_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected IndexEntry(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.IndexEntry_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(IndexEntry obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new IndexEntry object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public IndexEntry copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new IndexEntry(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof IndexEntry)
      equal = (((IndexEntry)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  
   /**
   * info about this entry.
   * @return information about this entry.
   */
   
  @Override
  public String toString()
  {
    StringBuilder result = new StringBuilder();
    
    result.append(this.getClass().getName()+"@"+hashCode()+"[");
    result.append("position:"+getPosition()+";");
    result.append("timestamp:"+getTimeStamp()+";");
    result.append("flags:"+getFlags()+";");
    result.append("size:"+getSize()+";");
    result.append("min-distance:"+getMinDistance()+";");
    result.append("]");
    return result.toString();
  }

 

/**
 * Create a new IndexEntry with the specified<br>
 * values.<br>
 * <br>
 * @param position The value to be returned from #getPosition().<br>
 * @param timeStamp The value to be returned from #getTimeStamp().<br>
 * @param flags The value to be returned from #getFlags().<br>
 * @param size The value to be returned from #getSize().<br>
 * @param minDistance The value to be returned from #getMinDistance().
 */
  public static IndexEntry make(long position, long timeStamp, int flags, int size, int minDistance) {
    long cPtr = VideoJNI.IndexEntry_make(position, timeStamp, flags, size, minDistance);
    return (cPtr == 0) ? null : new IndexEntry(cPtr, false);
  }

/**
 * The position in bytes of the frame corresponding to this index entry<br>
 * in the Container.<br>
 * @return The byte-offset from start of the Container where the<br>
 *   frame for this IndexEntry can be found.
 */
  public long getPosition() {
    return VideoJNI.IndexEntry_getPosition(swigCPtr, this);
  }

/**
 * The actual time stamp, in units of Stream#getTimeBase(), of the frame this entry points to.<br>
 * @return The time stamp for this entry.
 */
  public long getTimeStamp() {
    return VideoJNI.IndexEntry_getTimeStamp(swigCPtr, this);
  }

/**
 * Flags set for this entry.  See the INDEX_FLAG* constants<br>
 * above.<br>
 * @return the flags.
 */
  public int getFlags() {
    return VideoJNI.IndexEntry_getFlags(swigCPtr, this);
  }

/**
 * The size of bytes of the frame this index entry points to.<br>
 * @return The size in bytes.
 */
  public int getSize() {
    return VideoJNI.IndexEntry_getSize(swigCPtr, this);
  }

/**
 * Minimum number of index entries between this index entry<br>
 * and the last keyframe in the index, used to avoid unneeded searching.<br>
 * @return the minimum distance, in bytes.
 */
  public int getMinDistance() {
    return VideoJNI.IndexEntry_getMinDistance(swigCPtr, this);
  }

/**
 * Is this index entry pointing to a key frame.<br>
 * Really shorthand for <code>#getFlags() &amp; #INDEX_FLAG_KEYFRAME</code>.<br>
 * @return True if this index entry is for a key frame.
 */
  public boolean isKeyFrame() {
    return VideoJNI.IndexEntry_isKeyFrame(swigCPtr, this);
  }

/**
 * A bit mask value that may be set in #getFlags.
 */
  public final static int INDEX_FLAG_KEYFRAME = VideoJNI.IndexEntry_INDEX_FLAG_KEYFRAME_get();
}
