/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package io.humble.video;
import io.humble.ferry.*;
/**
 * This class wraps represents a Rational number.<br>
 * <p><br>
 * Video formats often use rational numbers, and converting between<br>
 * them willy nilly can lead to rounding errors, and eventually, out<br>
 * of sync problems.  Therefore we use IRational objects to pass<br>
 * around Rational Numbers and avoid conversion until the very last moment.<br>
 * </p><p><br>
 * Note: There are some static convenience methods<br>
 * in this class that start with s*.  They start with s<br>
 * (as opposed to overloading methods (e.g. sAdd(...) vs. add(...)).<br>
 * </p>
 */
public class Rational extends RefCounted {
  // JNIHelper.swg: Start generated code
  // >>>>>>>>>>>>>>>>>>>>>>>>>>>
  /**
   * This method is only here to use some references and remove
   * a Eclipse compiler warning.
   */
  @SuppressWarnings("unused")
  private void noop()
  {
    Buffer.make(null, 1);
  }
   
  private volatile long swigCPtr;

  /**
   * Internal Only.
   */
  protected Rational(long cPtr, boolean cMemoryOwn) {
    super(VideoJNI.Rational_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }
  
  /**
   * Internal Only.
   */
  protected Rational(long cPtr, boolean cMemoryOwn,
      java.util.concurrent.atomic.AtomicLong ref)
  {
    super(VideoJNI.Rational_SWIGUpcast(cPtr),
     cMemoryOwn, ref);
    swigCPtr = cPtr;
  }
    
  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that obj is proxying for.
   *   
   * @param obj The java proxy object for a native object.
   * @return The raw pointer obj is proxying for.
   */
  protected static long getCPtr(Rational obj) {
    if (obj == null) return 0;
    return obj.getMyCPtr();
  }

  /**
   * Internal Only.  Not part of public API.
   *
   * Get the raw value of the native object that we're proxying for.
   *   
   * @return The raw pointer we're proxying for.
   */  
  protected long getMyCPtr() {
    if (swigCPtr == 0) throw new IllegalStateException("underlying native object already deleted");
    return swigCPtr;
  }
  
  /**
   * Create a new Rational object that is actually referring to the
   * exact same underlying native object.
   *
   * @return the new Java object.
   */
  @Override
  public Rational copyReference() {
    if (swigCPtr == 0)
      return null;
    else
      return new Rational(swigCPtr, swigCMemOwn, getJavaRefCount());
  }

  /**
   * Compares two values, returning true if the underlying objects in native code are the same object.
   *
   * That means you can have two different Java objects, but when you do a comparison, you'll find out
   * they are the EXACT same object.
   *
   * @return True if the underlying native object is the same.  False otherwise.
   */
  public boolean equals(Object obj) {
    boolean equal = false;
    if (obj instanceof Rational)
      equal = (((Rational)obj).swigCPtr == this.swigCPtr);
    return equal;
  }
  
  /**
   * Get a hashable value for this object.
   *
   * @return the hashable value.
   */
  public int hashCode() {
     return (int)swigCPtr;
  }
  
  // <<<<<<<<<<<<<<<<<<<<<<<<<<<
  // JNIHelper.swg: End generated code
  

  /**
   * Prints the contents of this object as a fraction.
   * @return &quot;{@link #getNumerator()}/{@link #getDenominator()}&quot;
   */
   
  @Override
  public String toString()
  {
    return "" + getNumerator() + "/" + getDenominator();
  }
  /**
   * Is this number positive?
   * @return true if > 0; false if not.
   */
  public boolean isPositive()
  {
    if (getDenominator() == 0)
      return false;
    return getDouble() > 0;
  }
  /**
   * Is this number not null and positive.
   * @param num the number; may be null
   * @return true if not-null and > 0; else false;
   */
  public static boolean positive(Rational num)
  {
    if (num == null)
      return false;
    return num.isPositive();
  }
  /**
   * Is this number negative?
   * @return true if < 0; false if not.
   */
  public boolean isNegative()
  {
    if (getDenominator() == 0)
      return false;
    return getDouble() < 0;
  }
  /**
   * Is this number not null and negative.
   * @param num the number; may be null
   * @return true if not-null and < 0; else false;
   */
  public static boolean negative(Rational num)
  {
    if (num == null)
      return false;
    return num.isNegative();
  }

/**
 * Get the numerator for this rational.<br>
 * @return the numerator.
 */
  public int getNumerator() {
    return VideoJNI.Rational_getNumerator(swigCPtr, this);
  }

/**
 * Get the denominator for this rational.<br>
 * @return the denominator.
 */
  public int getDenominator() {
    return VideoJNI.Rational_getDenominator(swigCPtr, this);
  }

/**
 * Creates a new IRational object by copying (by value) this object.<br>
 * <br>
 * @return the new object
 */
  public Rational copy() {
    long cPtr = VideoJNI.Rational_copy(swigCPtr, this);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Compare a rational to this rational<br>
 * @param other second rational<br>
 * @return 0 if this==other, 1 if this&gt;other and -1 if this&lt;other.
 */
  public int compareTo(Rational other) {
    return VideoJNI.Rational_compareTo(swigCPtr, this, Rational.getCPtr(other), other);
  }

/**
 * Compare two rationals<br>
 * @param a the first rational<br>
 * @param b the second rational<br>
 * @return 0 if a==b, 1 if a&gt;b and -1 if b&lt;a.
 */
  public static int sCompareTo(Rational a, Rational b) {
    return VideoJNI.Rational_sCompareTo(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
  }

/**
 * Rational to double conversion.<br>
 * <br>
 * @return (double) a
 */
  public double getDouble() {
    return VideoJNI.Rational_getDouble(swigCPtr, this);
  }

/**
 * Reduce a fraction to it's lowest common denominators.<br>
 * This is useful for framerate calculations.<br>
 * @param num       the src numerator.<br>
 * @param den       the src denominator.<br>
 * @param max the maximum allowed for nom &amp; den in the reduced fraction.<br>
 * @return 1 if exact, 0 otherwise
 */
  public int reduce(long num, long den, long max) {
    return VideoJNI.Rational_reduce(swigCPtr, this, num, den, max);
  }

/**
 * Reduce a fraction to it's lowest common denominators.<br>
 * This is useful for framerate calculations.<br>
 * @param dst The destination rational  <br>
 * @param num       the src numerator.<br>
 * @param den       the src denominator.<br>
 * @param max the maximum allowed for nom &amp; den in the reduced fraction.<br>
 * @return 1 if exact, 0 otherwise
 */
  public static int sReduce(Rational dst, long num, long den, long max) {
    return VideoJNI.Rational_sReduce(Rational.getCPtr(dst), dst, num, den, max);
  }

/**
 * Multiplies this number by arg<br>
 * @param arg number to mulitply by.<br>
 * @return this*arg.
 */
  public Rational multiply(Rational arg) {
    long cPtr = VideoJNI.Rational_multiply(swigCPtr, this, Rational.getCPtr(arg), arg);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Multiples a by b.<br>
 * @param a the first number<br>
 * @param b the second number.<br>
 * @return a*b
 */
  public static Rational sMultiply(Rational a, Rational b) {
    long cPtr = VideoJNI.Rational_sMultiply(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Divides this rational by arg.<br>
 * @param arg The divisor to use.<br>
 * @return this/arg.
 */
  public Rational divide(Rational arg) {
    long cPtr = VideoJNI.Rational_divide(swigCPtr, this, Rational.getCPtr(arg), arg);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Divides a by b.<br>
 * @param a The first number.<br>
 * b The second number.<br>
 * @return a/b.
 */
  public static Rational sDivide(Rational a, Rational b) {
    long cPtr = VideoJNI.Rational_sDivide(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Subtracts arg from this rational<br>
 * @param arg The amount to subtract from this.<br>
 * @return this-arg.
 */
  public Rational subtract(Rational arg) {
    long cPtr = VideoJNI.Rational_subtract(swigCPtr, this, Rational.getCPtr(arg), arg);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Subtracts a from b.<br>
 * @param a The first number.<br>
 * b The second number.<br>
 * @return a-b.
 */
  public static Rational sSubtract(Rational a, Rational b) {
    long cPtr = VideoJNI.Rational_sSubtract(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Adds arg to this rational<br>
 * @param arg The amount to add to this.<br>
 * @return this+arg.
 */
  public Rational add(Rational arg) {
    long cPtr = VideoJNI.Rational_add(swigCPtr, this, Rational.getCPtr(arg), arg);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Adds a to b.<br>
 * @param a The first number.<br>
 * b The second number.<br>
 * @return a+b.
 */
  public static Rational sAdd(Rational a, Rational b) {
    long cPtr = VideoJNI.Rational_sAdd(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Takes a value scaled in increments of origBase and gives the<br>
 * equivalent value scaled in terms of this Rational.<br>
 * <br>
 * @param origValue The original int64_t value you care about.<br>
 * @param origBase The original base Rational that origValue is scaled with.<br>
 * <br>
 * @return The new integer value, scaled in units of this IRational.
 */
  public long rescale(long origValue, Rational origBase) {
    return VideoJNI.Rational_rescale__SWIG_0(swigCPtr, this, origValue, Rational.getCPtr(origBase), origBase);
  }

/**
 * Takes a value scaled in increments of origBase and gives the<br>
 * equivalent value scaled in terms of this Rational.<br>
 * <br>
 * @param origValue The original int64_t value you care about.<br>
 * @param origBase The original base Rational that origValue is scaled with.<br>
 * @param newBase The rational you want to rescale origValue into.<br>
 * <br>
 * @return The new integer value, scaled in units of this IRational.
 */
  public static long sRescale(long origValue, Rational origBase, Rational newBase) {
    return VideoJNI.Rational_sRescale__SWIG_0(origValue, Rational.getCPtr(origBase), origBase, Rational.getCPtr(newBase), newBase);
  }

/**
 * Get a new rational that will be set to 0/1.<br>
 * The rational will not have #init() called<br>
 * and hence will be modifiable by #setValue(double)<br>
 * until #init() is called.<br>
 * @return a rational number object
 */
  public static Rational make() {
    long cPtr = VideoJNI.Rational_make__SWIG_0();
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Converts a double precision floating point number to a rational.<br>
 * @param d double to convert<br>
 * @return A new Rational; caller must release() when done.
 */
  public static Rational make(double d) {
    long cPtr = VideoJNI.Rational_make__SWIG_1(d);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Creates deep copy of a Rational from another Rational.<br>
 * <br>
 * @param src       The source Rational to copy.<br>
 * @return A new Rational; Returns null<br>
 *         if src is null.
 */
  public static Rational make(Rational src) {
    long cPtr = VideoJNI.Rational_make__SWIG_2(Rational.getCPtr(src), src);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Create a rational from a numerator and denominator.<br>
 * <br>
 * We will always reduce this to the lowest num/den pair<br>
 * we can, but never having den exceed what was passed in.<br>
 * <br>
 * @param num The numerator of the resulting Rational<br>
 * @param den The denominator of the resulting Rational<br>
 * <br>
 * @return A new Rational; 
 */
  public static Rational make(int num, int den) {
    long cPtr = VideoJNI.Rational_make__SWIG_3(num, den);
    return (cPtr == 0) ? null : new Rational(cPtr, false);
  }

/**
 * Takes a value scaled in increments of origBase and gives the<br>
 * equivalent value scaled in terms of this Rational.<br>
 * <br>
 * @param origValue The original int64_t value you care about.<br>
 * @param origBase The original base Rational that origValue is scaled with.<br>
 * @param rounding How you want rounding to occur<br>
 * @return The new integer value, scaled in units of this IRational.
 */
  public long rescale(long origValue, Rational origBase, Rational.Rounding rounding) {
    return VideoJNI.Rational_rescale__SWIG_1(swigCPtr, this, origValue, Rational.getCPtr(origBase), origBase, rounding.swigValue());
  }

/**
 * Takes a value scaled in increments of origBase and gives the<br>
 * equivalent value scaled in terms of this Rational.<br>
 * <br>
 * @param origValue The original int64_t value you care about.<br>
 * @param origBase The original base Rational that origValue is scaled with.<br>
 * @param newBase The rational you want to rescale origValue into.<br>
 * @param rounding How you want rounding to occur<br>
 * <br>
 * @return The new integer value, scaled in units of this IRational.
 */
  public static long sRescale(long origValue, Rational origBase, Rational newBase, Rational.Rounding rounding) {
    return VideoJNI.Rational_sRescale__SWIG_1(origValue, Rational.getCPtr(origBase), origBase, Rational.getCPtr(newBase), newBase, rounding.swigValue());
  }

/**
 * Rescales a long value to another long value.<br>
 * <p><br>
 * This method doesn't use IRational values, but<br>
 * instead uses numerators and denominators<br>
 * passed in by the caller.  It will not result<br>
 * in any memory allocations.<br>
 * </p><br>
 * <br>
 * @param srcValue The value to rescale.<br>
 * @param dstNumerator The numerator of the units<br>
 *   you want to scale to.  Must be non-zero.<br>
 * @param dstDenominator The denominator of the units<br>
 *   you want to scale to.  Must be non-zero.<br>
 * @param srcNumerator The numerator of the units<br>
 *   <code>srcValue</code> is expressed in.<br>
 *   Must be non-zero.<br>
 * @param srcDenominator The denominator of the units<br>
 *   <code>srcValue</code> is expressed in.<br>
 *   Must be non-zero.<br>
 * @param rounding How you want rounding to occur<br>
 * <br>
 * @return The new integer value, scaled in units of<br>
 *   dstNumerator/dstNumerator, or 0 if there<br>
 *   is a parameter error.
 */
  public static long rescale(long srcValue, int dstNumerator, int dstDenominator, int srcNumerator, int srcDenominator, Rational.Rounding rounding) {
    return VideoJNI.Rational_rescale__SWIG_2(srcValue, dstNumerator, dstDenominator, srcNumerator, srcDenominator, rounding.swigValue());
  }

/**
 * Sets the numerator on this object.<br>
 * <p><br>
 * If #isFinalized is true, then this method is ignored.<br>
 * </p>
 */
  public void setNumerator(int value) {
    VideoJNI.Rational_setNumerator(swigCPtr, this, value);
  }

/**
 * Sets the denominator on this object.<br>
 * <p><br>
 * If #isFinalized is true, then this method is ignored.<br>
 * </p>
 */
  public void setDenominator(int value) {
    VideoJNI.Rational_setDenominator(swigCPtr, this, value);
  }

/**
 * Sets the numerator and denominator on this object by<br>
 * reducing the double to the closest integer numerator<br>
 * and denominator.<br>
 * <p><br>
 * If #isFinalized is true, then this method is ignored.<br>
 * </p>
 */
  public void setValue(double value) {
    VideoJNI.Rational_setValue(swigCPtr, this, value);
  }

/**
 * An alias for #getDouble() but matching JavaBean<br>
 * conventions.
 */
  public double getValue() {
    return VideoJNI.Rational_getValue(swigCPtr, this);
  }

/**
 * Returns true if #init() has been called and<br>
 * this object is now considered finalized and immutable.
 */
  public boolean isFinalized() {
    return VideoJNI.Rational_isFinalized(swigCPtr, this);
  }

/**
 * Marks this object as finalized and immutable.  Any<br>
 * setters called after the first #init() call<br>
 * will be ignored.<br>
 * <p><br>
 * Most <code>make</code> methods will call this method<br>
 * automatically, with the exception of the blank factory<br>
 * method #make().<br>
 * </p> 
 */
  public void init() {
    VideoJNI.Rational_init(swigCPtr, this);
  }

  /**
   * A type to specify how rounding should be done.
   */
  public enum Rounding {
  /**
   * Round toward zero. 
   */
    ROUND_ZERO(VideoJNI.Rational_ROUND_ZERO_get()),
  /**
   * Round away from zero. 
   */
    ROUND_INF(VideoJNI.Rational_ROUND_INF_get()),
  /**
   * Round toward -infinity. 
   */
    ROUND_DOWN(VideoJNI.Rational_ROUND_DOWN_get()),
  /**
   * Round toward +infinity. 
   */
    ROUND_UP(VideoJNI.Rational_ROUND_UP_get()),
  /**
   * Round to nearest and halfway cases away from zero. 
   */
    ROUND_NEAR_INF(VideoJNI.Rational_ROUND_NEAR_INF_get()),
  /**
   * Flag to pass INT64_MIN/MAX through instead of rescaling, this avoids special cases for AV_NOPTS_VALUE 
   */
    ROUND_PASS_MINMAX(VideoJNI.Rational_ROUND_PASS_MINMAX_get()),
  ;

    public final int swigValue() {
      return swigValue;
    }

    public static Rounding swigToEnum(int swigValue) {
      Rounding[] swigValues = Rounding.class.getEnumConstants();
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (Rounding swigEnum : swigValues)
        if (swigEnum.swigValue == swigValue)
          return swigEnum;
      throw new IllegalArgumentException("No enum " + Rounding.class + " with value " + swigValue);
    }

    @SuppressWarnings("unused")
    private Rounding() {
      this.swigValue = SwigNext.next++;
    }

    @SuppressWarnings("unused")
    private Rounding(int swigValue) {
      this.swigValue = swigValue;
      SwigNext.next = swigValue+1;
    }

    @SuppressWarnings("unused")
    private Rounding(Rounding swigEnum) {
      this.swigValue = swigEnum.swigValue;
      SwigNext.next = this.swigValue+1;
    }

    private final int swigValue;

    private static class SwigNext {
      private static int next = 0;
    }
  }

}
