/*
 * Decompiled with CFR 0.152.
 */
package io.humble.ferry;

public class JNIEnv {
    private static final JNIEnv mEnv = new JNIEnv();
    private final CPUArch mCPUArch = JNIEnv.getCPUArch(System.getProperty("os.arch"));
    private final OSFamily mOSFamily = JNIEnv.getOSFamily(System.getProperty("os.name"));

    private JNIEnv() {
    }

    public static JNIEnv getEnv() {
        return mEnv;
    }

    public static CPUArch getCPUArch(String javaCPU) {
        String javaCPUArch;
        String string = javaCPUArch = javaCPU != null ? javaCPU.toLowerCase() : "";
        CPUArch javaArch = javaCPUArch.startsWith("x86_64") || javaCPUArch.startsWith("amd64") || javaCPUArch.startsWith("ia64") ? CPUArch.X86_64 : (javaCPUArch.startsWith("ppc64") || javaCPUArch.startsWith("powerpc64") ? CPUArch.PPC64 : (javaCPUArch.startsWith("ppc") || javaCPUArch.startsWith("powerpc") ? CPUArch.PPC : (javaCPUArch.contains("86") ? CPUArch.X86 : CPUArch.UNKNOWN)));
        return javaArch;
    }

    public static CPUArch getCPUArchFromGNUString(String gnuString) {
        String nativeCpu = gnuString.toLowerCase();
        CPUArch nativeArch = nativeCpu.startsWith("x86_64") || nativeCpu.startsWith("amd64") || nativeCpu.startsWith("ia64") ? CPUArch.X86_64 : (nativeCpu.startsWith("ppc64") || nativeCpu.startsWith("powerpc64") ? CPUArch.PPC64 : (nativeCpu.startsWith("ppc") || nativeCpu.startsWith("powerpc") ? CPUArch.PPC : (nativeCpu.contains("86") ? CPUArch.X86 : CPUArch.UNKNOWN)));
        return nativeArch;
    }

    public static OSFamily getOSFamily(String osName) {
        OSFamily retval = osName != null && osName.length() > 0 ? (osName.startsWith("Windows") ? OSFamily.WINDOWS : (osName.startsWith("Mac") ? OSFamily.MAC : (osName.startsWith("Linux") ? OSFamily.LINUX : OSFamily.UNKNOWN))) : OSFamily.UNKNOWN;
        return retval;
    }

    public static OSFamily getOSFamilyFromGNUString(String gnuString) {
        String nativeOs;
        String string = nativeOs = gnuString != null ? gnuString.toLowerCase() : "";
        OSFamily retval = nativeOs.startsWith("mingw") || nativeOs.startsWith("cygwin") ? OSFamily.WINDOWS : (nativeOs.startsWith("darwin") ? OSFamily.MAC : (nativeOs.startsWith("linux") ? OSFamily.LINUX : OSFamily.UNKNOWN));
        return retval;
    }

    public CPUArch getCPUArch() {
        return this.mCPUArch;
    }

    public OSFamily getOSFamily() {
        return this.mOSFamily;
    }

    static enum OSFamily {
        LINUX,
        MAC,
        WINDOWS,
        UNKNOWN;

    }

    static enum CPUArch {
        X86,
        X86_64,
        PPC,
        PPC64,
        UNKNOWN;

    }
}

