/*
 * Decompiled with CFR 0.152.
 */
package io.humble.ferry;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNILibraryLoader {
    private static final Logger log = LoggerFactory.getLogger(JNILibraryLoader.class);
    private static JNILibraryLoader mGlobalLoader = new JNILibraryLoader();
    private String[] mJavaPropPaths;
    private String[] mJavaEnvPaths;
    private OSName mOS = null;
    private Map<String, Set<Long>> mLoadedLibraries = new HashMap<String, Set<Long>>();

    @Deprecated
    public static void loadLibrary(String aLibraryName, Long aMajorVersion) {
        JNILibraryLoader.getInstance().loadLibrary0(aLibraryName, aMajorVersion);
    }

    public static void loadLibrary(String aLibraryName) {
        JNILibraryLoader.loadLibrary(aLibraryName, null);
    }

    static JNILibraryLoader getInstance() {
        return mGlobalLoader;
    }

    private JNILibraryLoader() {
        log.trace("<init>");
    }

    synchronized void loadLibrary0(String aLibraryName, Long aMajorVersion) {
        if (this.alreadyLoadedLibrary(aLibraryName, aMajorVersion)) {
            return;
        }
        List<String> libCandidates = this.getLibraryCandidates(aLibraryName, aMajorVersion);
        if (libCandidates != null && libCandidates.size() > 0 && !this.loadCandidateLibrary(aLibraryName, aMajorVersion, libCandidates)) {
            try {
                System.loadLibrary(aLibraryName);
            }
            catch (UnsatisfiedLinkError e) {
                log.error("Could not load library: {}; version: {}.", (Object)aLibraryName, aMajorVersion == null ? "" : aMajorVersion);
                throw e;
            }
            this.setLoadedLibrary(aLibraryName, aMajorVersion);
        }
        log.trace("Successfully Loaded library: {}; Version: {}", (Object)aLibraryName, (Object)aMajorVersion);
    }

    void setLoadedLibrary(String aLibraryName, Long aMajorVersion) {
        Set<Long> foundVersions = this.mLoadedLibraries.get(aLibraryName);
        if (foundVersions == null) {
            foundVersions = new HashSet<Long>();
            this.mLoadedLibraries.put(aLibraryName, foundVersions);
        }
        foundVersions.add(aMajorVersion);
    }

    boolean loadCandidateLibrary(String aLibraryName, Long aMajorVersion, List<String> aLibCandidates) {
        boolean retval = false;
        for (String candidate : aLibCandidates) {
            log.trace("Attempt: library load of library: {}; version: {}: relative path: {}", new Object[]{aLibraryName, aMajorVersion == null ? "<unspecified>" : Long.valueOf(aMajorVersion), candidate});
            File candidateFile = new File(candidate);
            if (!candidateFile.exists()) continue;
            String absPath = candidateFile.getAbsolutePath();
            try {
                log.trace("Attempt: library load of library: {}; version: {}: absolute path: {}", new Object[]{aLibraryName, aMajorVersion == null ? "<unspecified>" : Long.valueOf(aMajorVersion), absPath});
                System.load(absPath);
                log.trace("Success: library load of library: {}; version: {}: absolute path: {}", new Object[]{aLibraryName, aMajorVersion == null ? "<unspecified>" : Long.valueOf(aMajorVersion), absPath});
                this.setLoadedLibrary(aLibraryName, aMajorVersion);
                retval = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                log.warn("Failure: library load of library: {}; version: {}: absolute path: {}; error: {}", new Object[]{aLibraryName, aMajorVersion == null ? "<unspecified>" : Long.valueOf(aMajorVersion), absPath, e});
            }
            catch (SecurityException e) {
                log.warn("Failure: library load of library: {}; version: {}: absolute path: {}; error: {}", new Object[]{aLibraryName, aMajorVersion == null ? "<unspecified>" : Long.valueOf(aMajorVersion), absPath, e});
            }
        }
        return retval;
    }

    List<String> getLibraryCandidates(String aLibraryName, Long aMajorVersion) {
        String[] postSuffixVersions;
        String[] preSuffixVersions;
        String[] suffixes;
        String[] prefixes;
        LinkedList<String> retval = new LinkedList<String>();
        switch (this.getOS()) {
            case Unknown: 
            case Linux: {
                String[] stringArray;
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".so"};
                preSuffixVersions = new String[]{""};
                if (aMajorVersion == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "." + aMajorVersion;
                }
                postSuffixVersions = stringArray;
                break;
            }
            case Windows: {
                String[] stringArray;
                prefixes = new String[]{"lib", "", "cyg"};
                suffixes = new String[]{".dll"};
                if (aMajorVersion == null) {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = "";
                } else {
                    String[] stringArray5 = new String[1];
                    stringArray = stringArray5;
                    stringArray5[0] = "-" + aMajorVersion;
                }
                preSuffixVersions = stringArray;
                postSuffixVersions = new String[]{""};
                break;
            }
            case MacOSX: {
                String[] stringArray;
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".dylib"};
                if (aMajorVersion == null) {
                    String[] stringArray6 = new String[1];
                    stringArray = stringArray6;
                    stringArray6[0] = "";
                } else {
                    String[] stringArray7 = new String[1];
                    stringArray = stringArray7;
                    stringArray7[0] = "." + aMajorVersion;
                }
                preSuffixVersions = stringArray;
                postSuffixVersions = new String[]{""};
                break;
            }
            default: {
                prefixes = null;
                suffixes = null;
                preSuffixVersions = null;
                postSuffixVersions = null;
            }
        }
        this.initializeSearchPaths();
        if (aMajorVersion != null) {
            for (String directory : this.mJavaPropPaths) {
                this.generateFileNames(retval, directory, aLibraryName, prefixes, suffixes, preSuffixVersions, postSuffixVersions, true);
            }
            for (String directory : this.mJavaEnvPaths) {
                this.generateFileNames(retval, directory, aLibraryName, prefixes, suffixes, preSuffixVersions, postSuffixVersions, true);
            }
        }
        for (String directory : this.mJavaPropPaths) {
            this.generateFileNames(retval, directory, aLibraryName, prefixes, suffixes, preSuffixVersions, postSuffixVersions, false);
        }
        for (String directory : this.mJavaEnvPaths) {
            this.generateFileNames(retval, directory, aLibraryName, prefixes, suffixes, preSuffixVersions, postSuffixVersions, false);
        }
        return retval;
    }

    void generateFileNames(List<String> aResults, String aDirectory, String aLibraryName, String[] aPrefixes, String[] aSuffixes, String[] aPreSuffixVersions, String[] aPostSuffixVersions, boolean aIncludeVersion) {
        String dirSeparator = File.separator;
        if (!aDirectory.endsWith(dirSeparator)) {
            aDirectory = aDirectory + dirSeparator;
        }
        for (String suffix : aSuffixes) {
            for (String prefix : aPrefixes) {
                if (aIncludeVersion) {
                    for (String preSuffixVersion : aPreSuffixVersions) {
                        for (String postSuffixVersion : aPostSuffixVersions) {
                            String result = aDirectory + prefix + aLibraryName + preSuffixVersion + suffix + postSuffixVersion;
                            aResults.add(result);
                        }
                    }
                    continue;
                }
                String result = aDirectory + prefix + aLibraryName + suffix;
                aResults.add(result);
            }
        }
    }

    private void initializeSearchPaths() {
        String pathVar = null;
        if (this.mJavaPropPaths == null) {
            pathVar = System.getProperty("java.library.path", "");
            log.trace("property java.library.path: {}", (Object)pathVar);
            this.mJavaPropPaths = this.getEntitiesFromPath(pathVar);
        }
        if (this.mJavaEnvPaths == null) {
            String envVar = this.getSystemRuntimeLibraryPathVar();
            pathVar = System.getenv(envVar);
            log.trace("OS environment runtime shared library path ({}): {}", (Object)envVar, (Object)pathVar);
            this.mJavaEnvPaths = this.getEntitiesFromPath(pathVar);
        }
    }

    OSName getOS() {
        if (this.mOS != null) {
            return this.mOS;
        }
        OSName retval = OSName.Linux;
        String osName = System.getProperty("os.name", "Linux");
        if (osName.length() > 0) {
            retval = osName.startsWith("Windows") ? OSName.Windows : (osName.startsWith("Mac") ? OSName.MacOSX : (osName.startsWith("Linux") ? OSName.Linux : OSName.Linux));
        }
        this.mOS = retval;
        log.trace("Detected OS: {}", (Object)this.mOS);
        return retval;
    }

    void setOS(OSName os) {
        this.mOS = os;
    }

    String getSystemRuntimeLibraryPathVar() {
        String retval = "LD_LIBRARY_PATH";
        switch (this.getOS()) {
            case Windows: {
                retval = "PATH";
                break;
            }
            case MacOSX: {
                retval = "DYLD_LIBRARY_PATH";
                break;
            }
        }
        return retval;
    }

    String[] getEntitiesFromPath(String aPathVar) {
        String[] retval = null;
        String sep = File.pathSeparator;
        if (aPathVar == null || aPathVar.length() == 0) {
            retval = new String[]{"."};
            log.trace("Have empty path var; assuming current directory to find native libraries");
        } else {
            log.trace("Parsing path var: {}", (Object)aPathVar);
            int len = aPathVar.length();
            int i = 0;
            int n = 0;
            int j = 0;
            n = 1;
            i = aPathVar.indexOf(sep);
            while (i >= 0) {
                ++n;
                i = aPathVar.indexOf(sep, i + 1);
            }
            log.trace("Found {} paths in path var: {}", (Object)n, (Object)aPathVar);
            retval = new String[n];
            i = 0;
            n = 0;
            j = aPathVar.indexOf(sep);
            while (j >= 0) {
                if (j - i > 0) {
                    retval[n] = aPathVar.substring(i, j);
                    log.trace("Added path {} for path var: {}", (Object)retval[n], (Object)aPathVar);
                    ++n;
                } else if (j - i == 0) {
                    retval[n] = ".";
                    log.trace("Added path {} for path var: {}", (Object)retval[n], (Object)aPathVar);
                    ++n;
                }
                i = j + 1;
                j = aPathVar.indexOf(sep, i);
            }
            retval[n] = aPathVar.substring(i, len);
            log.trace("Adding last path {} for path var: {}", (Object)retval[n], (Object)aPathVar);
            if (retval[n] == null || retval[n].length() == 0) {
                retval[n] = ".";
                log.trace("Faking last path {} for malformed path var: {}", (Object)retval[n], (Object)aPathVar);
            }
        }
        return retval;
    }

    boolean alreadyLoadedLibrary(String aLibraryName, Long aMajorVersion) {
        boolean retval = false;
        Set<Long> foundVersions = this.mLoadedLibraries.get(aLibraryName);
        if (foundVersions != null) {
            if (aMajorVersion == null || foundVersions.contains(aMajorVersion)) {
                retval = true;
            } else {
                log.warn("Attempting load of {}, version {}, but already loaded verions: {}.  We will attempt to load the specified version but behavior is undefined", new Object[]{aLibraryName, aMajorVersion, foundVersions.toArray()});
            }
        }
        return retval;
    }

    static enum OSName {
        Unknown,
        Windows,
        MacOSX,
        Linux;

    }
}

