/*
 * Decompiled with CFR 0.152.
 */
package io.humble.ferry;

import io.humble.ferry.FerryJNI;
import io.humble.ferry.JNIMemoryAllocator;
import io.humble.ferry.JNIMemoryManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;

public final class JNIReference
extends WeakReference<Object> {
    private final AtomicLong mSwigCPtr = new AtomicLong(0L);
    private volatile JNIMemoryAllocator mMemAllocator;
    private final boolean mIsFerryObject;
    private final AtomicLong mJavaRefCount;
    private static final JNIMemoryAllocator sMemAllocator = new JNIMemoryAllocator();
    private final boolean sUseStaticMemAllocator = true;
    private static volatile boolean mMemoryDebugging = false;
    private final DebugInfo mDebugInfo;

    static void setMemoryDebugging(boolean value) {
        mMemoryDebugging = value;
    }

    static boolean isMemoryDebugging() {
        return mMemoryDebugging;
    }

    private JNIReference(Object proxy, Object aReferent, long nativeVal, boolean isFerry, AtomicLong javaRefCount) {
        super(aReferent, JNIMemoryManager.getMgr().getQueue());
        this.mIsFerryObject = isFerry;
        this.mJavaRefCount = javaRefCount;
        this.mSwigCPtr.set(nativeVal);
        this.mDebugInfo = mMemoryDebugging ? new DebugInfo(proxy) : null;
        JNIMemoryManager.MemoryModel model = JNIMemoryManager.getMemoryModel();
        if (model == JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS || model == JNIMemoryManager.MemoryModel.NATIVE_BUFFERS) {
            return;
        }
        if (this.mJavaRefCount.get() == 1L && FerryJNI.RefCounted_getCurrentNativeRefCount(nativeVal, null) == 1) {
            this.mMemAllocator = sMemAllocator;
            JNIMemoryAllocator.setAllocator(nativeVal, this.mMemAllocator);
        } else {
            this.mMemAllocator = JNIMemoryAllocator.getAllocator(nativeVal);
        }
    }

    public static JNIMemoryManager getMgr() {
        return JNIMemoryManager.getMgr();
    }

    static JNIReference createReference(Object proxy, Object aReferent, long swigCPtr, boolean isFerry, AtomicLong javaRefCount) {
        JNIMemoryManager.getMgr().gcInternal();
        JNIReference ref = new JNIReference(proxy, aReferent, swigCPtr, isFerry, javaRefCount);
        JNIMemoryManager.getMgr().addReference(ref);
        return ref;
    }

    static JNIReference createReference(Object proxy, Object aReferent, long swigCPtr, AtomicLong javaRefCount) {
        return JNIReference.createReference(proxy, aReferent, swigCPtr, true, javaRefCount);
    }

    static JNIReference createNonFerryReference(Object proxy, Object aReferent, long swigCPtr, AtomicLong javaRefCount) {
        return JNIReference.createReference(proxy, aReferent, swigCPtr, false, javaRefCount);
    }

    public void delete() {
        long swigPtr = this.mSwigCPtr.getAndSet(0L);
        if (swigPtr != 0L) {
            if (this.mJavaRefCount.decrementAndGet() == 0L) {
                FerryJNI.RefCounted_release(swigPtr, null);
            }
            this.mMemAllocator = null;
        }
    }

    boolean isFerryObject() {
        return this.mIsFerryObject;
    }

    boolean isDeleted() {
        return this.mSwigCPtr.get() == 0L;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[");
        builder.append("native=").append(this.mSwigCPtr.get()).append(";");
        if (this.mDebugInfo != null) {
            builder.append("proxyClass=").append(this.mDebugInfo.getObjectClass().getCanonicalName()).append(";");
            builder.append("hashCode=").append(this.mDebugInfo.getObjectHashCode()).append(";");
        }
        builder.append("object=[").append(this.get()).append("];");
        builder.append("];");
        return builder.toString();
    }

    private static class DebugInfo {
        private final int mHashCode;
        private final Class<? extends Object> mClass;

        public DebugInfo(Object aObject) {
            this.mClass = aObject.getClass();
            this.mHashCode = aObject.hashCode();
        }

        public Class<? extends Object> getObjectClass() {
            return this.mClass;
        }

        public int getObjectHashCode() {
            return this.mHashCode;
        }
    }
}

