/*
 * Decompiled with CFR 0.152.
 */
package io.humble.ferry;

import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNIThreadProxy
extends Thread {
    private static final AtomicReference<Interruptable> mGlobalHandler = new AtomicReference();
    private static final Logger log = LoggerFactory.getLogger(JNIThreadProxy.class);
    private static final ThreadLocal<JNIThreadProxy> mThreads = new ThreadLocal();
    private final Thread mThread;

    private JNIThreadProxy(Thread thread) {
        this.mThread = thread;
    }

    public static Interruptable getGlobalInterruptHandler() {
        return mGlobalHandler.get();
    }

    public static Interruptable setGlobalInterruptable(Interruptable handler) {
        return mGlobalHandler.getAndSet(handler);
    }

    public static Thread currentThread() {
        JNIThreadProxy retval = mThreads.get();
        if (retval == null) {
            retval = new JNIThreadProxy(Thread.currentThread());
            mThreads.set(retval);
        }
        return retval;
    }

    @Override
    public boolean isInterrupted() {
        Thread thread = JNIThreadProxy.mThreads.get().mThread;
        Interruptable handler = JNIThreadProxy.getGlobalInterruptHandler();
        boolean retval = false;
        if (handler != null && !(retval = handler.preInterruptCheck())) {
            return retval;
        }
        retval = thread.isInterrupted();
        if (handler != null) {
            retval = handler.postInterruptCheck(retval);
        }
        return retval;
    }

    @Override
    public void interrupt() {
        Thread thread = JNIThreadProxy.mThreads.get().mThread;
        log.trace("interrupt (thread {})", (Object)thread);
        thread.interrupt();
    }

    public static interface Interruptable {
        public boolean preInterruptCheck();

        public boolean postInterruptCheck(boolean var1);
    }
}

