/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.BitStreamFilterType;
import io.humble.video.Coder;
import io.humble.video.MediaPacket;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class BitStreamFilter
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected BitStreamFilter(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.BitStreamFilter_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected BitStreamFilter(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.BitStreamFilter_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BitStreamFilter obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public BitStreamFilter copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new BitStreamFilter(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof BitStreamFilter) {
            equal = ((BitStreamFilter)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("]");
        return result.toString();
    }

    public static BitStreamFilter make(String filtername) {
        long cPtr = VideoJNI.BitStreamFilter_make__SWIG_0(filtername);
        return cPtr == 0L ? null : new BitStreamFilter(cPtr, false);
    }

    public static BitStreamFilter make(BitStreamFilterType type) {
        long cPtr = VideoJNI.BitStreamFilter_make__SWIG_1(BitStreamFilterType.getCPtr(type), type);
        return cPtr == 0L ? null : new BitStreamFilter(cPtr, false);
    }

    public BitStreamFilterType getType() {
        long cPtr = VideoJNI.BitStreamFilter_getType(this.swigCPtr, this);
        return cPtr == 0L ? null : new BitStreamFilterType(cPtr, false);
    }

    public String getName() {
        return VideoJNI.BitStreamFilter_getName(this.swigCPtr, this);
    }

    public int filter(Buffer output, int outputOffset, Buffer input, int inputOffset, int inputSize, Coder coder, String args, boolean isKey) {
        return VideoJNI.BitStreamFilter_filter__SWIG_0(this.swigCPtr, this, Buffer.getCPtr(output), output, outputOffset, Buffer.getCPtr(input), input, inputOffset, inputSize, Coder.getCPtr(coder), coder, args, isKey);
    }

    public void filter(MediaPacket packet, String args) {
        VideoJNI.BitStreamFilter_filter__SWIG_1(this.swigCPtr, this, MediaPacket.getCPtr(packet), packet, args);
    }
}

