/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.CodecProfile;
import io.humble.video.MediaDescriptor;
import io.humble.video.MuxerFormat;
import io.humble.video.PixelFormat;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class Codec
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Codec(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Codec_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Codec(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Codec_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Codec obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Codec copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Codec(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Codec) {
            equal = ((Codec)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("type=" + (Object)((Object)this.getType()) + ";");
        result.append("id=" + (Object)((Object)this.getID()) + ";");
        result.append("name=" + this.getName() + ";");
        result.append("]");
        return result.toString();
    }

    public static Collection<Codec> getInstalledCodecs() {
        HashSet<Codec> retval = new HashSet<Codec>();
        int count = Codec.getNumInstalledCodecs();
        for (int i = 0; i < count; ++i) {
            Codec codec = Codec.getInstalledCodec(i);
            if (codec == null) continue;
            retval.add(codec);
        }
        return retval;
    }

    public Collection<Rational> getSupportedVideoFrameRates() {
        LinkedList<Rational> retval = new LinkedList<Rational>();
        int count = this.getNumSupportedVideoFrameRates();
        for (int i = 0; i < count; ++i) {
            Rational rate = this.getSupportedVideoFrameRate(i);
            if (rate == null) continue;
            retval.add(rate);
        }
        return retval;
    }

    public Collection<PixelFormat.Type> getSupportedVideoPixelFormats() {
        LinkedList<PixelFormat.Type> retval = new LinkedList<PixelFormat.Type>();
        int count = this.getNumSupportedVideoPixelFormats();
        for (int i = 0; i < count; ++i) {
            PixelFormat.Type type = this.getSupportedVideoPixelFormat(i);
            if (type == null || type == PixelFormat.Type.PIX_FMT_NONE) continue;
            retval.add(type);
        }
        return retval;
    }

    public Collection<Integer> getSupportedAudioSampleRates() {
        LinkedList<Integer> retval = new LinkedList<Integer>();
        int count = this.getNumSupportedAudioSampleRates();
        for (int i = 0; i < count; ++i) {
            int rate = this.getSupportedAudioSampleRate(i);
            if (rate == 0) continue;
            retval.add(rate);
        }
        return retval;
    }

    public Collection<AudioFormat.Type> getSupportedAudioFormats() {
        LinkedList<AudioFormat.Type> retval = new LinkedList<AudioFormat.Type>();
        int count = this.getNumSupportedAudioFormats();
        for (int i = 0; i < count; ++i) {
            AudioFormat.Type fmt = this.getSupportedAudioFormat(i);
            if (fmt == null || fmt == AudioFormat.Type.SAMPLE_FMT_NONE) continue;
            retval.add(fmt);
        }
        return retval;
    }

    public Collection<AudioChannel.Layout> getSupportedAudioChannelLayouts() {
        LinkedList<AudioChannel.Layout> retval = new LinkedList<AudioChannel.Layout>();
        int count = this.getNumSupportedAudioChannelLayouts();
        for (int i = 0; i < count; ++i) {
            AudioChannel.Layout layout = this.getSupportedAudioChannelLayout(i);
            if (layout == AudioChannel.Layout.CH_LAYOUT_UNKNOWN) continue;
            retval.add(layout);
        }
        return retval;
    }

    public boolean hasCapability(CodecCapability c) {
        return VideoJNI.Codec_hasCapability(this.swigCPtr, this, c.swigValue());
    }

    public int getCapabilities() {
        return VideoJNI.Codec_getCapabilities(this.swigCPtr, this);
    }

    public String getName() {
        return VideoJNI.Codec_getName(this.swigCPtr, this);
    }

    public int getIDAsInt() {
        return VideoJNI.Codec_getIDAsInt(this.swigCPtr, this);
    }

    public ID getID() {
        return ID.swigToEnum(VideoJNI.Codec_getID(this.swigCPtr, this));
    }

    public MediaDescriptor.Type getType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.Codec_getType(this.swigCPtr, this));
    }

    public boolean canDecode() {
        return VideoJNI.Codec_canDecode(this.swigCPtr, this);
    }

    public boolean canEncode() {
        return VideoJNI.Codec_canEncode(this.swigCPtr, this);
    }

    public static Codec findEncodingCodec(ID id) {
        long cPtr = VideoJNI.Codec_findEncodingCodec(id.swigValue());
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec findEncodingCodecByIntID(int id) {
        long cPtr = VideoJNI.Codec_findEncodingCodecByIntID(id);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec findEncodingCodecByName(String id) {
        long cPtr = VideoJNI.Codec_findEncodingCodecByName(id);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec findDecodingCodec(ID id) {
        long cPtr = VideoJNI.Codec_findDecodingCodec(id.swigValue());
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec findDecodingCodecByIntID(int id) {
        long cPtr = VideoJNI.Codec_findDecodingCodecByIntID(id);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec findDecodingCodecByName(String id) {
        long cPtr = VideoJNI.Codec_findDecodingCodecByName(id);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public static Codec guessEncodingCodec(MuxerFormat fmt, String shortName, String url, String mimeType, MediaDescriptor.Type type) {
        long cPtr = VideoJNI.Codec_guessEncodingCodec(MuxerFormat.getCPtr(fmt), fmt, shortName, url, mimeType, type.swigValue());
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public String getLongName() {
        return VideoJNI.Codec_getLongName(this.swigCPtr, this);
    }

    public static int getNumInstalledCodecs() {
        return VideoJNI.Codec_getNumInstalledCodecs();
    }

    public static Codec getInstalledCodec(int index) {
        long cPtr = VideoJNI.Codec_getInstalledCodec(index);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public int getNumSupportedVideoFrameRates() {
        return VideoJNI.Codec_getNumSupportedVideoFrameRates(this.swigCPtr, this);
    }

    public Rational getSupportedVideoFrameRate(int index) {
        long cPtr = VideoJNI.Codec_getSupportedVideoFrameRate(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public int getNumSupportedVideoPixelFormats() {
        return VideoJNI.Codec_getNumSupportedVideoPixelFormats(this.swigCPtr, this);
    }

    public PixelFormat.Type getSupportedVideoPixelFormat(int index) {
        return PixelFormat.Type.swigToEnum(VideoJNI.Codec_getSupportedVideoPixelFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioSampleRates() {
        return VideoJNI.Codec_getNumSupportedAudioSampleRates(this.swigCPtr, this);
    }

    public int getSupportedAudioSampleRate(int index) {
        return VideoJNI.Codec_getSupportedAudioSampleRate(this.swigCPtr, this, index);
    }

    public int getNumSupportedAudioFormats() {
        return VideoJNI.Codec_getNumSupportedAudioFormats(this.swigCPtr, this);
    }

    public AudioFormat.Type getSupportedAudioFormat(int index) {
        return AudioFormat.Type.swigToEnum(VideoJNI.Codec_getSupportedAudioFormat(this.swigCPtr, this, index));
    }

    public int getNumSupportedAudioChannelLayouts() {
        return VideoJNI.Codec_getNumSupportedAudioChannelLayouts(this.swigCPtr, this);
    }

    public AudioChannel.Layout getSupportedAudioChannelLayout(int index) {
        return AudioChannel.Layout.swigToEnum(VideoJNI.Codec_getSupportedAudioChannelLayout(this.swigCPtr, this, index));
    }

    public int getNumSupportedProfiles() {
        return VideoJNI.Codec_getNumSupportedProfiles(this.swigCPtr, this);
    }

    public CodecProfile getSupportedProfile(int index) {
        long cPtr = VideoJNI.Codec_getSupportedProfile(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new CodecProfile(cPtr, false);
    }

    public static enum CodecCapability {
        CAP_DRAW_HORIZ_BAND(VideoJNI.Codec_CAP_DRAW_HORIZ_BAND_get()),
        CAP_DR1(VideoJNI.Codec_CAP_DR1_get()),
        CAP_TRUNCATED(VideoJNI.Codec_CAP_TRUNCATED_get()),
        CAP_HWACCEL(VideoJNI.Codec_CAP_HWACCEL_get()),
        CAP_DELAY(VideoJNI.Codec_CAP_DELAY_get()),
        CAP_SMALL_LAST_FRAME(VideoJNI.Codec_CAP_SMALL_LAST_FRAME_get()),
        CAP_HWACCEL_VDPAU(VideoJNI.Codec_CAP_HWACCEL_VDPAU_get()),
        CAP_SUBFRAMES(VideoJNI.Codec_CAP_SUBFRAMES_get()),
        CAP_EXPERIMENTAL(VideoJNI.Codec_CAP_EXPERIMENTAL_get()),
        CAP_CHANNEL_CONF(VideoJNI.Codec_CAP_CHANNEL_CONF_get()),
        CAP_NEG_LINESIZES(VideoJNI.Codec_CAP_NEG_LINESIZES_get()),
        CAP_FRAME_THREADS(VideoJNI.Codec_CAP_FRAME_THREADS_get()),
        CAP_SLICE_THREADS(VideoJNI.Codec_CAP_SLICE_THREADS_get()),
        CAP_PARAM_CHANGE(VideoJNI.Codec_CAP_PARAM_CHANGE_get()),
        CAP_AUTO_THREADS(VideoJNI.Codec_CAP_AUTO_THREADS_get()),
        CAP_VARIABLE_FRAME_SIZE(VideoJNI.Codec_CAP_VARIABLE_FRAME_SIZE_get()),
        CAP_INTRA_ONLY(VideoJNI.Codec_CAP_INTRA_ONLY_get()),
        CAP_LOSSLESS(VideoJNI.Codec_CAP_LOSSLESS_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CodecCapability swigToEnum(int swigValue) {
            CodecCapability[] swigValues = (CodecCapability[])CodecCapability.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CodecCapability swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CodecCapability.class + " with value " + swigValue);
        }

        private CodecCapability() {
            this.swigValue = SwigNext.next++;
        }

        private CodecCapability(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CodecCapability(CodecCapability swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ID {
        CODEC_ID_NONE(VideoJNI.Codec_CODEC_ID_NONE_get()),
        CODEC_ID_MPEG1VIDEO(VideoJNI.Codec_CODEC_ID_MPEG1VIDEO_get()),
        CODEC_ID_MPEG2VIDEO(VideoJNI.Codec_CODEC_ID_MPEG2VIDEO_get()),
        CODEC_ID_H261(VideoJNI.Codec_CODEC_ID_H261_get()),
        CODEC_ID_H263(VideoJNI.Codec_CODEC_ID_H263_get()),
        CODEC_ID_RV10(VideoJNI.Codec_CODEC_ID_RV10_get()),
        CODEC_ID_RV20(VideoJNI.Codec_CODEC_ID_RV20_get()),
        CODEC_ID_MJPEG(VideoJNI.Codec_CODEC_ID_MJPEG_get()),
        CODEC_ID_MJPEGB(VideoJNI.Codec_CODEC_ID_MJPEGB_get()),
        CODEC_ID_LJPEG(VideoJNI.Codec_CODEC_ID_LJPEG_get()),
        CODEC_ID_SP5X(VideoJNI.Codec_CODEC_ID_SP5X_get()),
        CODEC_ID_JPEGLS(VideoJNI.Codec_CODEC_ID_JPEGLS_get()),
        CODEC_ID_MPEG4(VideoJNI.Codec_CODEC_ID_MPEG4_get()),
        CODEC_ID_RAWVIDEO(VideoJNI.Codec_CODEC_ID_RAWVIDEO_get()),
        CODEC_ID_MSMPEG4V1(VideoJNI.Codec_CODEC_ID_MSMPEG4V1_get()),
        CODEC_ID_MSMPEG4V2(VideoJNI.Codec_CODEC_ID_MSMPEG4V2_get()),
        CODEC_ID_MSMPEG4V3(VideoJNI.Codec_CODEC_ID_MSMPEG4V3_get()),
        CODEC_ID_WMV1(VideoJNI.Codec_CODEC_ID_WMV1_get()),
        CODEC_ID_WMV2(VideoJNI.Codec_CODEC_ID_WMV2_get()),
        CODEC_ID_H263P(VideoJNI.Codec_CODEC_ID_H263P_get()),
        CODEC_ID_H263I(VideoJNI.Codec_CODEC_ID_H263I_get()),
        CODEC_ID_FLV1(VideoJNI.Codec_CODEC_ID_FLV1_get()),
        CODEC_ID_SVQ1(VideoJNI.Codec_CODEC_ID_SVQ1_get()),
        CODEC_ID_SVQ3(VideoJNI.Codec_CODEC_ID_SVQ3_get()),
        CODEC_ID_DVVIDEO(VideoJNI.Codec_CODEC_ID_DVVIDEO_get()),
        CODEC_ID_HUFFYUV(VideoJNI.Codec_CODEC_ID_HUFFYUV_get()),
        CODEC_ID_CYUV(VideoJNI.Codec_CODEC_ID_CYUV_get()),
        CODEC_ID_H264(VideoJNI.Codec_CODEC_ID_H264_get()),
        CODEC_ID_INDEO3(VideoJNI.Codec_CODEC_ID_INDEO3_get()),
        CODEC_ID_VP3(VideoJNI.Codec_CODEC_ID_VP3_get()),
        CODEC_ID_THEORA(VideoJNI.Codec_CODEC_ID_THEORA_get()),
        CODEC_ID_ASV1(VideoJNI.Codec_CODEC_ID_ASV1_get()),
        CODEC_ID_ASV2(VideoJNI.Codec_CODEC_ID_ASV2_get()),
        CODEC_ID_FFV1(VideoJNI.Codec_CODEC_ID_FFV1_get()),
        CODEC_ID_4XM(VideoJNI.Codec_CODEC_ID_4XM_get()),
        CODEC_ID_VCR1(VideoJNI.Codec_CODEC_ID_VCR1_get()),
        CODEC_ID_CLJR(VideoJNI.Codec_CODEC_ID_CLJR_get()),
        CODEC_ID_MDEC(VideoJNI.Codec_CODEC_ID_MDEC_get()),
        CODEC_ID_ROQ(VideoJNI.Codec_CODEC_ID_ROQ_get()),
        CODEC_ID_INTERPLAY_VIDEO(VideoJNI.Codec_CODEC_ID_INTERPLAY_VIDEO_get()),
        CODEC_ID_XAN_WC3(VideoJNI.Codec_CODEC_ID_XAN_WC3_get()),
        CODEC_ID_XAN_WC4(VideoJNI.Codec_CODEC_ID_XAN_WC4_get()),
        CODEC_ID_RPZA(VideoJNI.Codec_CODEC_ID_RPZA_get()),
        CODEC_ID_CINEPAK(VideoJNI.Codec_CODEC_ID_CINEPAK_get()),
        CODEC_ID_WS_VQA(VideoJNI.Codec_CODEC_ID_WS_VQA_get()),
        CODEC_ID_MSRLE(VideoJNI.Codec_CODEC_ID_MSRLE_get()),
        CODEC_ID_MSVIDEO1(VideoJNI.Codec_CODEC_ID_MSVIDEO1_get()),
        CODEC_ID_IDCIN(VideoJNI.Codec_CODEC_ID_IDCIN_get()),
        CODEC_ID_8BPS(VideoJNI.Codec_CODEC_ID_8BPS_get()),
        CODEC_ID_SMC(VideoJNI.Codec_CODEC_ID_SMC_get()),
        CODEC_ID_FLIC(VideoJNI.Codec_CODEC_ID_FLIC_get()),
        CODEC_ID_TRUEMOTION1(VideoJNI.Codec_CODEC_ID_TRUEMOTION1_get()),
        CODEC_ID_VMDVIDEO(VideoJNI.Codec_CODEC_ID_VMDVIDEO_get()),
        CODEC_ID_MSZH(VideoJNI.Codec_CODEC_ID_MSZH_get()),
        CODEC_ID_ZLIB(VideoJNI.Codec_CODEC_ID_ZLIB_get()),
        CODEC_ID_QTRLE(VideoJNI.Codec_CODEC_ID_QTRLE_get()),
        CODEC_ID_TSCC(VideoJNI.Codec_CODEC_ID_TSCC_get()),
        CODEC_ID_ULTI(VideoJNI.Codec_CODEC_ID_ULTI_get()),
        CODEC_ID_QDRAW(VideoJNI.Codec_CODEC_ID_QDRAW_get()),
        CODEC_ID_VIXL(VideoJNI.Codec_CODEC_ID_VIXL_get()),
        CODEC_ID_QPEG(VideoJNI.Codec_CODEC_ID_QPEG_get()),
        CODEC_ID_PNG(VideoJNI.Codec_CODEC_ID_PNG_get()),
        CODEC_ID_PPM(VideoJNI.Codec_CODEC_ID_PPM_get()),
        CODEC_ID_PBM(VideoJNI.Codec_CODEC_ID_PBM_get()),
        CODEC_ID_PGM(VideoJNI.Codec_CODEC_ID_PGM_get()),
        CODEC_ID_PGMYUV(VideoJNI.Codec_CODEC_ID_PGMYUV_get()),
        CODEC_ID_PAM(VideoJNI.Codec_CODEC_ID_PAM_get()),
        CODEC_ID_FFVHUFF(VideoJNI.Codec_CODEC_ID_FFVHUFF_get()),
        CODEC_ID_RV30(VideoJNI.Codec_CODEC_ID_RV30_get()),
        CODEC_ID_RV40(VideoJNI.Codec_CODEC_ID_RV40_get()),
        CODEC_ID_VC1(VideoJNI.Codec_CODEC_ID_VC1_get()),
        CODEC_ID_WMV3(VideoJNI.Codec_CODEC_ID_WMV3_get()),
        CODEC_ID_LOCO(VideoJNI.Codec_CODEC_ID_LOCO_get()),
        CODEC_ID_WNV1(VideoJNI.Codec_CODEC_ID_WNV1_get()),
        CODEC_ID_AASC(VideoJNI.Codec_CODEC_ID_AASC_get()),
        CODEC_ID_INDEO2(VideoJNI.Codec_CODEC_ID_INDEO2_get()),
        CODEC_ID_FRAPS(VideoJNI.Codec_CODEC_ID_FRAPS_get()),
        CODEC_ID_TRUEMOTION2(VideoJNI.Codec_CODEC_ID_TRUEMOTION2_get()),
        CODEC_ID_BMP(VideoJNI.Codec_CODEC_ID_BMP_get()),
        CODEC_ID_CSCD(VideoJNI.Codec_CODEC_ID_CSCD_get()),
        CODEC_ID_MMVIDEO(VideoJNI.Codec_CODEC_ID_MMVIDEO_get()),
        CODEC_ID_ZMBV(VideoJNI.Codec_CODEC_ID_ZMBV_get()),
        CODEC_ID_AVS(VideoJNI.Codec_CODEC_ID_AVS_get()),
        CODEC_ID_SMACKVIDEO(VideoJNI.Codec_CODEC_ID_SMACKVIDEO_get()),
        CODEC_ID_NUV(VideoJNI.Codec_CODEC_ID_NUV_get()),
        CODEC_ID_KMVC(VideoJNI.Codec_CODEC_ID_KMVC_get()),
        CODEC_ID_FLASHSV(VideoJNI.Codec_CODEC_ID_FLASHSV_get()),
        CODEC_ID_CAVS(VideoJNI.Codec_CODEC_ID_CAVS_get()),
        CODEC_ID_JPEG2000(VideoJNI.Codec_CODEC_ID_JPEG2000_get()),
        CODEC_ID_VMNC(VideoJNI.Codec_CODEC_ID_VMNC_get()),
        CODEC_ID_VP5(VideoJNI.Codec_CODEC_ID_VP5_get()),
        CODEC_ID_VP6(VideoJNI.Codec_CODEC_ID_VP6_get()),
        CODEC_ID_VP6F(VideoJNI.Codec_CODEC_ID_VP6F_get()),
        CODEC_ID_TARGA(VideoJNI.Codec_CODEC_ID_TARGA_get()),
        CODEC_ID_DSICINVIDEO(VideoJNI.Codec_CODEC_ID_DSICINVIDEO_get()),
        CODEC_ID_TIERTEXSEQVIDEO(VideoJNI.Codec_CODEC_ID_TIERTEXSEQVIDEO_get()),
        CODEC_ID_TIFF(VideoJNI.Codec_CODEC_ID_TIFF_get()),
        CODEC_ID_GIF(VideoJNI.Codec_CODEC_ID_GIF_get()),
        CODEC_ID_DXA(VideoJNI.Codec_CODEC_ID_DXA_get()),
        CODEC_ID_DNXHD(VideoJNI.Codec_CODEC_ID_DNXHD_get()),
        CODEC_ID_THP(VideoJNI.Codec_CODEC_ID_THP_get()),
        CODEC_ID_SGI(VideoJNI.Codec_CODEC_ID_SGI_get()),
        CODEC_ID_C93(VideoJNI.Codec_CODEC_ID_C93_get()),
        CODEC_ID_BETHSOFTVID(VideoJNI.Codec_CODEC_ID_BETHSOFTVID_get()),
        CODEC_ID_PTX(VideoJNI.Codec_CODEC_ID_PTX_get()),
        CODEC_ID_TXD(VideoJNI.Codec_CODEC_ID_TXD_get()),
        CODEC_ID_VP6A(VideoJNI.Codec_CODEC_ID_VP6A_get()),
        CODEC_ID_AMV(VideoJNI.Codec_CODEC_ID_AMV_get()),
        CODEC_ID_VB(VideoJNI.Codec_CODEC_ID_VB_get()),
        CODEC_ID_PCX(VideoJNI.Codec_CODEC_ID_PCX_get()),
        CODEC_ID_SUNRAST(VideoJNI.Codec_CODEC_ID_SUNRAST_get()),
        CODEC_ID_INDEO4(VideoJNI.Codec_CODEC_ID_INDEO4_get()),
        CODEC_ID_INDEO5(VideoJNI.Codec_CODEC_ID_INDEO5_get()),
        CODEC_ID_MIMIC(VideoJNI.Codec_CODEC_ID_MIMIC_get()),
        CODEC_ID_RL2(VideoJNI.Codec_CODEC_ID_RL2_get()),
        CODEC_ID_ESCAPE124(VideoJNI.Codec_CODEC_ID_ESCAPE124_get()),
        CODEC_ID_DIRAC(VideoJNI.Codec_CODEC_ID_DIRAC_get()),
        CODEC_ID_BFI(VideoJNI.Codec_CODEC_ID_BFI_get()),
        CODEC_ID_CMV(VideoJNI.Codec_CODEC_ID_CMV_get()),
        CODEC_ID_MOTIONPIXELS(VideoJNI.Codec_CODEC_ID_MOTIONPIXELS_get()),
        CODEC_ID_TGV(VideoJNI.Codec_CODEC_ID_TGV_get()),
        CODEC_ID_TGQ(VideoJNI.Codec_CODEC_ID_TGQ_get()),
        CODEC_ID_TQI(VideoJNI.Codec_CODEC_ID_TQI_get()),
        CODEC_ID_AURA(VideoJNI.Codec_CODEC_ID_AURA_get()),
        CODEC_ID_AURA2(VideoJNI.Codec_CODEC_ID_AURA2_get()),
        CODEC_ID_V210X(VideoJNI.Codec_CODEC_ID_V210X_get()),
        CODEC_ID_TMV(VideoJNI.Codec_CODEC_ID_TMV_get()),
        CODEC_ID_V210(VideoJNI.Codec_CODEC_ID_V210_get()),
        CODEC_ID_DPX(VideoJNI.Codec_CODEC_ID_DPX_get()),
        CODEC_ID_MAD(VideoJNI.Codec_CODEC_ID_MAD_get()),
        CODEC_ID_FRWU(VideoJNI.Codec_CODEC_ID_FRWU_get()),
        CODEC_ID_FLASHSV2(VideoJNI.Codec_CODEC_ID_FLASHSV2_get()),
        CODEC_ID_CDGRAPHICS(VideoJNI.Codec_CODEC_ID_CDGRAPHICS_get()),
        CODEC_ID_R210(VideoJNI.Codec_CODEC_ID_R210_get()),
        CODEC_ID_ANM(VideoJNI.Codec_CODEC_ID_ANM_get()),
        CODEC_ID_BINKVIDEO(VideoJNI.Codec_CODEC_ID_BINKVIDEO_get()),
        CODEC_ID_IFF_ILBM(VideoJNI.Codec_CODEC_ID_IFF_ILBM_get()),
        CODEC_ID_IFF_BYTERUN1(VideoJNI.Codec_CODEC_ID_IFF_BYTERUN1_get()),
        CODEC_ID_KGV1(VideoJNI.Codec_CODEC_ID_KGV1_get()),
        CODEC_ID_YOP(VideoJNI.Codec_CODEC_ID_YOP_get()),
        CODEC_ID_VP8(VideoJNI.Codec_CODEC_ID_VP8_get()),
        CODEC_ID_PICTOR(VideoJNI.Codec_CODEC_ID_PICTOR_get()),
        CODEC_ID_ANSI(VideoJNI.Codec_CODEC_ID_ANSI_get()),
        CODEC_ID_A64_MULTI(VideoJNI.Codec_CODEC_ID_A64_MULTI_get()),
        CODEC_ID_A64_MULTI5(VideoJNI.Codec_CODEC_ID_A64_MULTI5_get()),
        CODEC_ID_R10K(VideoJNI.Codec_CODEC_ID_R10K_get()),
        CODEC_ID_MXPEG(VideoJNI.Codec_CODEC_ID_MXPEG_get()),
        CODEC_ID_LAGARITH(VideoJNI.Codec_CODEC_ID_LAGARITH_get()),
        CODEC_ID_PRORES(VideoJNI.Codec_CODEC_ID_PRORES_get()),
        CODEC_ID_JV(VideoJNI.Codec_CODEC_ID_JV_get()),
        CODEC_ID_DFA(VideoJNI.Codec_CODEC_ID_DFA_get()),
        CODEC_ID_WMV3IMAGE(VideoJNI.Codec_CODEC_ID_WMV3IMAGE_get()),
        CODEC_ID_VC1IMAGE(VideoJNI.Codec_CODEC_ID_VC1IMAGE_get()),
        CODEC_ID_UTVIDEO(VideoJNI.Codec_CODEC_ID_UTVIDEO_get()),
        CODEC_ID_BMV_VIDEO(VideoJNI.Codec_CODEC_ID_BMV_VIDEO_get()),
        CODEC_ID_VBLE(VideoJNI.Codec_CODEC_ID_VBLE_get()),
        CODEC_ID_DXTORY(VideoJNI.Codec_CODEC_ID_DXTORY_get()),
        CODEC_ID_V410(VideoJNI.Codec_CODEC_ID_V410_get()),
        CODEC_ID_XWD(VideoJNI.Codec_CODEC_ID_XWD_get()),
        CODEC_ID_CDXL(VideoJNI.Codec_CODEC_ID_CDXL_get()),
        CODEC_ID_XBM(VideoJNI.Codec_CODEC_ID_XBM_get()),
        CODEC_ID_ZEROCODEC(VideoJNI.Codec_CODEC_ID_ZEROCODEC_get()),
        CODEC_ID_MSS1(VideoJNI.Codec_CODEC_ID_MSS1_get()),
        CODEC_ID_MSA1(VideoJNI.Codec_CODEC_ID_MSA1_get()),
        CODEC_ID_TSCC2(VideoJNI.Codec_CODEC_ID_TSCC2_get()),
        CODEC_ID_MTS2(VideoJNI.Codec_CODEC_ID_MTS2_get()),
        CODEC_ID_CLLC(VideoJNI.Codec_CODEC_ID_CLLC_get()),
        CODEC_ID_MSS2(VideoJNI.Codec_CODEC_ID_MSS2_get()),
        CODEC_ID_VP9(VideoJNI.Codec_CODEC_ID_VP9_get()),
        CODEC_ID_AIC(VideoJNI.Codec_CODEC_ID_AIC_get()),
        CODEC_ID_ESCAPE130_DEPRECATED(VideoJNI.Codec_CODEC_ID_ESCAPE130_DEPRECATED_get()),
        CODEC_ID_G2M_DEPRECATED(VideoJNI.Codec_CODEC_ID_G2M_DEPRECATED_get()),
        CODEC_ID_WEBP_DEPRECATED(VideoJNI.Codec_CODEC_ID_WEBP_DEPRECATED_get()),
        CODEC_ID_HNM4_VIDEO(VideoJNI.Codec_CODEC_ID_HNM4_VIDEO_get()),
        CODEC_ID_HEVC_DEPRECATED(VideoJNI.Codec_CODEC_ID_HEVC_DEPRECATED_get()),
        CODEC_ID_FIC(VideoJNI.Codec_CODEC_ID_FIC_get()),
        CODEC_ID_ALIAS_PIX(VideoJNI.Codec_CODEC_ID_ALIAS_PIX_get()),
        CODEC_ID_BRENDER_PIX_DEPRECATED(VideoJNI.Codec_CODEC_ID_BRENDER_PIX_DEPRECATED_get()),
        CODEC_ID_PAF_VIDEO_DEPRECATED(VideoJNI.Codec_CODEC_ID_PAF_VIDEO_DEPRECATED_get()),
        CODEC_ID_EXR_DEPRECATED(VideoJNI.Codec_CODEC_ID_EXR_DEPRECATED_get()),
        CODEC_ID_VP7_DEPRECATED(VideoJNI.Codec_CODEC_ID_VP7_DEPRECATED_get()),
        CODEC_ID_SANM_DEPRECATED(VideoJNI.Codec_CODEC_ID_SANM_DEPRECATED_get()),
        CODEC_ID_SGIRLE_DEPRECATED(VideoJNI.Codec_CODEC_ID_SGIRLE_DEPRECATED_get()),
        CODEC_ID_MVC1_DEPRECATED(VideoJNI.Codec_CODEC_ID_MVC1_DEPRECATED_get()),
        CODEC_ID_MVC2_DEPRECATED(VideoJNI.Codec_CODEC_ID_MVC2_DEPRECATED_get()),
        CODEC_ID_HQX(VideoJNI.Codec_CODEC_ID_HQX_get()),
        CODEC_ID_TDSC(VideoJNI.Codec_CODEC_ID_TDSC_get()),
        CODEC_ID_HQ_HQA(VideoJNI.Codec_CODEC_ID_HQ_HQA_get()),
        CODEC_ID_HAP(VideoJNI.Codec_CODEC_ID_HAP_get()),
        CODEC_ID_DDS(VideoJNI.Codec_CODEC_ID_DDS_get()),
        CODEC_ID_BRENDER_PIX(VideoJNI.Codec_CODEC_ID_BRENDER_PIX_get()),
        CODEC_ID_Y41P(VideoJNI.Codec_CODEC_ID_Y41P_get()),
        CODEC_ID_ESCAPE130(VideoJNI.Codec_CODEC_ID_ESCAPE130_get()),
        CODEC_ID_EXR(VideoJNI.Codec_CODEC_ID_EXR_get()),
        CODEC_ID_AVRP(VideoJNI.Codec_CODEC_ID_AVRP_get()),
        CODEC_ID_012V(VideoJNI.Codec_CODEC_ID_012V_get()),
        CODEC_ID_G2M(VideoJNI.Codec_CODEC_ID_G2M_get()),
        CODEC_ID_AVUI(VideoJNI.Codec_CODEC_ID_AVUI_get()),
        CODEC_ID_AYUV(VideoJNI.Codec_CODEC_ID_AYUV_get()),
        CODEC_ID_TARGA_Y216(VideoJNI.Codec_CODEC_ID_TARGA_Y216_get()),
        CODEC_ID_V308(VideoJNI.Codec_CODEC_ID_V308_get()),
        CODEC_ID_V408(VideoJNI.Codec_CODEC_ID_V408_get()),
        CODEC_ID_YUV4(VideoJNI.Codec_CODEC_ID_YUV4_get()),
        CODEC_ID_SANM(VideoJNI.Codec_CODEC_ID_SANM_get()),
        CODEC_ID_PAF_VIDEO(VideoJNI.Codec_CODEC_ID_PAF_VIDEO_get()),
        CODEC_ID_AVRN(VideoJNI.Codec_CODEC_ID_AVRN_get()),
        CODEC_ID_CPIA(VideoJNI.Codec_CODEC_ID_CPIA_get()),
        CODEC_ID_XFACE(VideoJNI.Codec_CODEC_ID_XFACE_get()),
        CODEC_ID_SGIRLE(VideoJNI.Codec_CODEC_ID_SGIRLE_get()),
        CODEC_ID_MVC1(VideoJNI.Codec_CODEC_ID_MVC1_get()),
        CODEC_ID_MVC2(VideoJNI.Codec_CODEC_ID_MVC2_get()),
        CODEC_ID_SNOW(VideoJNI.Codec_CODEC_ID_SNOW_get()),
        CODEC_ID_WEBP(VideoJNI.Codec_CODEC_ID_WEBP_get()),
        CODEC_ID_SMVJPEG(VideoJNI.Codec_CODEC_ID_SMVJPEG_get()),
        CODEC_ID_HEVC(VideoJNI.Codec_CODEC_ID_HEVC_get()),
        CODEC_ID_VP7(VideoJNI.Codec_CODEC_ID_VP7_get()),
        CODEC_ID_APNG(VideoJNI.Codec_CODEC_ID_APNG_get()),
        CODEC_ID_FIRST_AUDIO(VideoJNI.Codec_CODEC_ID_FIRST_AUDIO_get()),
        CODEC_ID_PCM_S16LE(VideoJNI.Codec_CODEC_ID_PCM_S16LE_get()),
        CODEC_ID_PCM_S16BE(VideoJNI.Codec_CODEC_ID_PCM_S16BE_get()),
        CODEC_ID_PCM_U16LE(VideoJNI.Codec_CODEC_ID_PCM_U16LE_get()),
        CODEC_ID_PCM_U16BE(VideoJNI.Codec_CODEC_ID_PCM_U16BE_get()),
        CODEC_ID_PCM_S8(VideoJNI.Codec_CODEC_ID_PCM_S8_get()),
        CODEC_ID_PCM_U8(VideoJNI.Codec_CODEC_ID_PCM_U8_get()),
        CODEC_ID_PCM_MULAW(VideoJNI.Codec_CODEC_ID_PCM_MULAW_get()),
        CODEC_ID_PCM_ALAW(VideoJNI.Codec_CODEC_ID_PCM_ALAW_get()),
        CODEC_ID_PCM_S32LE(VideoJNI.Codec_CODEC_ID_PCM_S32LE_get()),
        CODEC_ID_PCM_S32BE(VideoJNI.Codec_CODEC_ID_PCM_S32BE_get()),
        CODEC_ID_PCM_U32LE(VideoJNI.Codec_CODEC_ID_PCM_U32LE_get()),
        CODEC_ID_PCM_U32BE(VideoJNI.Codec_CODEC_ID_PCM_U32BE_get()),
        CODEC_ID_PCM_S24LE(VideoJNI.Codec_CODEC_ID_PCM_S24LE_get()),
        CODEC_ID_PCM_S24BE(VideoJNI.Codec_CODEC_ID_PCM_S24BE_get()),
        CODEC_ID_PCM_U24LE(VideoJNI.Codec_CODEC_ID_PCM_U24LE_get()),
        CODEC_ID_PCM_U24BE(VideoJNI.Codec_CODEC_ID_PCM_U24BE_get()),
        CODEC_ID_PCM_S24DAUD(VideoJNI.Codec_CODEC_ID_PCM_S24DAUD_get()),
        CODEC_ID_PCM_ZORK(VideoJNI.Codec_CODEC_ID_PCM_ZORK_get()),
        CODEC_ID_PCM_S16LE_PLANAR(VideoJNI.Codec_CODEC_ID_PCM_S16LE_PLANAR_get()),
        CODEC_ID_PCM_DVD(VideoJNI.Codec_CODEC_ID_PCM_DVD_get()),
        CODEC_ID_PCM_F32BE(VideoJNI.Codec_CODEC_ID_PCM_F32BE_get()),
        CODEC_ID_PCM_F32LE(VideoJNI.Codec_CODEC_ID_PCM_F32LE_get()),
        CODEC_ID_PCM_F64BE(VideoJNI.Codec_CODEC_ID_PCM_F64BE_get()),
        CODEC_ID_PCM_F64LE(VideoJNI.Codec_CODEC_ID_PCM_F64LE_get()),
        CODEC_ID_PCM_BLURAY(VideoJNI.Codec_CODEC_ID_PCM_BLURAY_get()),
        CODEC_ID_PCM_LXF(VideoJNI.Codec_CODEC_ID_PCM_LXF_get()),
        CODEC_ID_S302M(VideoJNI.Codec_CODEC_ID_S302M_get()),
        CODEC_ID_PCM_S8_PLANAR(VideoJNI.Codec_CODEC_ID_PCM_S8_PLANAR_get()),
        CODEC_ID_PCM_S24LE_PLANAR_DEPRECATED(VideoJNI.Codec_CODEC_ID_PCM_S24LE_PLANAR_DEPRECATED_get()),
        CODEC_ID_PCM_S32LE_PLANAR_DEPRECATED(VideoJNI.Codec_CODEC_ID_PCM_S32LE_PLANAR_DEPRECATED_get()),
        CODEC_ID_PCM_S16BE_PLANAR_DEPRECATED(VideoJNI.Codec_CODEC_ID_PCM_S16BE_PLANAR_DEPRECATED_get()),
        CODEC_ID_PCM_S24LE_PLANAR(VideoJNI.Codec_CODEC_ID_PCM_S24LE_PLANAR_get()),
        CODEC_ID_PCM_S32LE_PLANAR(VideoJNI.Codec_CODEC_ID_PCM_S32LE_PLANAR_get()),
        CODEC_ID_PCM_S16BE_PLANAR(VideoJNI.Codec_CODEC_ID_PCM_S16BE_PLANAR_get()),
        CODEC_ID_ADPCM_IMA_QT(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_QT_get()),
        CODEC_ID_ADPCM_IMA_WAV(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_WAV_get()),
        CODEC_ID_ADPCM_IMA_DK3(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_DK3_get()),
        CODEC_ID_ADPCM_IMA_DK4(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_DK4_get()),
        CODEC_ID_ADPCM_IMA_WS(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_WS_get()),
        CODEC_ID_ADPCM_IMA_SMJPEG(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_SMJPEG_get()),
        CODEC_ID_ADPCM_MS(VideoJNI.Codec_CODEC_ID_ADPCM_MS_get()),
        CODEC_ID_ADPCM_4XM(VideoJNI.Codec_CODEC_ID_ADPCM_4XM_get()),
        CODEC_ID_ADPCM_XA(VideoJNI.Codec_CODEC_ID_ADPCM_XA_get()),
        CODEC_ID_ADPCM_ADX(VideoJNI.Codec_CODEC_ID_ADPCM_ADX_get()),
        CODEC_ID_ADPCM_EA(VideoJNI.Codec_CODEC_ID_ADPCM_EA_get()),
        CODEC_ID_ADPCM_G726(VideoJNI.Codec_CODEC_ID_ADPCM_G726_get()),
        CODEC_ID_ADPCM_CT(VideoJNI.Codec_CODEC_ID_ADPCM_CT_get()),
        CODEC_ID_ADPCM_SWF(VideoJNI.Codec_CODEC_ID_ADPCM_SWF_get()),
        CODEC_ID_ADPCM_YAMAHA(VideoJNI.Codec_CODEC_ID_ADPCM_YAMAHA_get()),
        CODEC_ID_ADPCM_SBPRO_4(VideoJNI.Codec_CODEC_ID_ADPCM_SBPRO_4_get()),
        CODEC_ID_ADPCM_SBPRO_3(VideoJNI.Codec_CODEC_ID_ADPCM_SBPRO_3_get()),
        CODEC_ID_ADPCM_SBPRO_2(VideoJNI.Codec_CODEC_ID_ADPCM_SBPRO_2_get()),
        CODEC_ID_ADPCM_THP(VideoJNI.Codec_CODEC_ID_ADPCM_THP_get()),
        CODEC_ID_ADPCM_IMA_AMV(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_AMV_get()),
        CODEC_ID_ADPCM_EA_R1(VideoJNI.Codec_CODEC_ID_ADPCM_EA_R1_get()),
        CODEC_ID_ADPCM_EA_R3(VideoJNI.Codec_CODEC_ID_ADPCM_EA_R3_get()),
        CODEC_ID_ADPCM_EA_R2(VideoJNI.Codec_CODEC_ID_ADPCM_EA_R2_get()),
        CODEC_ID_ADPCM_IMA_EA_SEAD(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_EA_SEAD_get()),
        CODEC_ID_ADPCM_IMA_EA_EACS(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_EA_EACS_get()),
        CODEC_ID_ADPCM_EA_XAS(VideoJNI.Codec_CODEC_ID_ADPCM_EA_XAS_get()),
        CODEC_ID_ADPCM_EA_MAXIS_XA(VideoJNI.Codec_CODEC_ID_ADPCM_EA_MAXIS_XA_get()),
        CODEC_ID_ADPCM_IMA_ISS(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_ISS_get()),
        CODEC_ID_ADPCM_G722(VideoJNI.Codec_CODEC_ID_ADPCM_G722_get()),
        CODEC_ID_ADPCM_IMA_APC(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_APC_get()),
        CODEC_ID_ADPCM_VIMA_DEPRECATED(VideoJNI.Codec_CODEC_ID_ADPCM_VIMA_DEPRECATED_get()),
        CODEC_ID_ADPCM_VIMA(VideoJNI.Codec_CODEC_ID_ADPCM_VIMA_get()),
        CODEC_ID_ADPCM_AFC(VideoJNI.Codec_CODEC_ID_ADPCM_AFC_get()),
        CODEC_ID_ADPCM_IMA_OKI(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_OKI_get()),
        CODEC_ID_ADPCM_DTK(VideoJNI.Codec_CODEC_ID_ADPCM_DTK_get()),
        CODEC_ID_ADPCM_IMA_RAD(VideoJNI.Codec_CODEC_ID_ADPCM_IMA_RAD_get()),
        CODEC_ID_ADPCM_G726LE(VideoJNI.Codec_CODEC_ID_ADPCM_G726LE_get()),
        CODEC_ID_ADPCM_THP_LE(VideoJNI.Codec_CODEC_ID_ADPCM_THP_LE_get()),
        CODEC_ID_AMR_NB(VideoJNI.Codec_CODEC_ID_AMR_NB_get()),
        CODEC_ID_AMR_WB(VideoJNI.Codec_CODEC_ID_AMR_WB_get()),
        CODEC_ID_RA_144(VideoJNI.Codec_CODEC_ID_RA_144_get()),
        CODEC_ID_RA_288(VideoJNI.Codec_CODEC_ID_RA_288_get()),
        CODEC_ID_ROQ_DPCM(VideoJNI.Codec_CODEC_ID_ROQ_DPCM_get()),
        CODEC_ID_INTERPLAY_DPCM(VideoJNI.Codec_CODEC_ID_INTERPLAY_DPCM_get()),
        CODEC_ID_XAN_DPCM(VideoJNI.Codec_CODEC_ID_XAN_DPCM_get()),
        CODEC_ID_SOL_DPCM(VideoJNI.Codec_CODEC_ID_SOL_DPCM_get()),
        CODEC_ID_MP2(VideoJNI.Codec_CODEC_ID_MP2_get()),
        CODEC_ID_MP3(VideoJNI.Codec_CODEC_ID_MP3_get()),
        CODEC_ID_AAC(VideoJNI.Codec_CODEC_ID_AAC_get()),
        CODEC_ID_AC3(VideoJNI.Codec_CODEC_ID_AC3_get()),
        CODEC_ID_DTS(VideoJNI.Codec_CODEC_ID_DTS_get()),
        CODEC_ID_VORBIS(VideoJNI.Codec_CODEC_ID_VORBIS_get()),
        CODEC_ID_DVAUDIO(VideoJNI.Codec_CODEC_ID_DVAUDIO_get()),
        CODEC_ID_WMAV1(VideoJNI.Codec_CODEC_ID_WMAV1_get()),
        CODEC_ID_WMAV2(VideoJNI.Codec_CODEC_ID_WMAV2_get()),
        CODEC_ID_MACE3(VideoJNI.Codec_CODEC_ID_MACE3_get()),
        CODEC_ID_MACE6(VideoJNI.Codec_CODEC_ID_MACE6_get()),
        CODEC_ID_VMDAUDIO(VideoJNI.Codec_CODEC_ID_VMDAUDIO_get()),
        CODEC_ID_FLAC(VideoJNI.Codec_CODEC_ID_FLAC_get()),
        CODEC_ID_MP3ADU(VideoJNI.Codec_CODEC_ID_MP3ADU_get()),
        CODEC_ID_MP3ON4(VideoJNI.Codec_CODEC_ID_MP3ON4_get()),
        CODEC_ID_SHORTEN(VideoJNI.Codec_CODEC_ID_SHORTEN_get()),
        CODEC_ID_ALAC(VideoJNI.Codec_CODEC_ID_ALAC_get()),
        CODEC_ID_WESTWOOD_SND1(VideoJNI.Codec_CODEC_ID_WESTWOOD_SND1_get()),
        CODEC_ID_GSM(VideoJNI.Codec_CODEC_ID_GSM_get()),
        CODEC_ID_QDM2(VideoJNI.Codec_CODEC_ID_QDM2_get()),
        CODEC_ID_COOK(VideoJNI.Codec_CODEC_ID_COOK_get()),
        CODEC_ID_TRUESPEECH(VideoJNI.Codec_CODEC_ID_TRUESPEECH_get()),
        CODEC_ID_TTA(VideoJNI.Codec_CODEC_ID_TTA_get()),
        CODEC_ID_SMACKAUDIO(VideoJNI.Codec_CODEC_ID_SMACKAUDIO_get()),
        CODEC_ID_QCELP(VideoJNI.Codec_CODEC_ID_QCELP_get()),
        CODEC_ID_WAVPACK(VideoJNI.Codec_CODEC_ID_WAVPACK_get()),
        CODEC_ID_DSICINAUDIO(VideoJNI.Codec_CODEC_ID_DSICINAUDIO_get()),
        CODEC_ID_IMC(VideoJNI.Codec_CODEC_ID_IMC_get()),
        CODEC_ID_MUSEPACK7(VideoJNI.Codec_CODEC_ID_MUSEPACK7_get()),
        CODEC_ID_MLP(VideoJNI.Codec_CODEC_ID_MLP_get()),
        CODEC_ID_GSM_MS(VideoJNI.Codec_CODEC_ID_GSM_MS_get()),
        CODEC_ID_ATRAC3(VideoJNI.Codec_CODEC_ID_ATRAC3_get()),
        CODEC_ID_APE(VideoJNI.Codec_CODEC_ID_APE_get()),
        CODEC_ID_NELLYMOSER(VideoJNI.Codec_CODEC_ID_NELLYMOSER_get()),
        CODEC_ID_MUSEPACK8(VideoJNI.Codec_CODEC_ID_MUSEPACK8_get()),
        CODEC_ID_SPEEX(VideoJNI.Codec_CODEC_ID_SPEEX_get()),
        CODEC_ID_WMAVOICE(VideoJNI.Codec_CODEC_ID_WMAVOICE_get()),
        CODEC_ID_WMAPRO(VideoJNI.Codec_CODEC_ID_WMAPRO_get()),
        CODEC_ID_WMALOSSLESS(VideoJNI.Codec_CODEC_ID_WMALOSSLESS_get()),
        CODEC_ID_ATRAC3P(VideoJNI.Codec_CODEC_ID_ATRAC3P_get()),
        CODEC_ID_EAC3(VideoJNI.Codec_CODEC_ID_EAC3_get()),
        CODEC_ID_SIPR(VideoJNI.Codec_CODEC_ID_SIPR_get()),
        CODEC_ID_MP1(VideoJNI.Codec_CODEC_ID_MP1_get()),
        CODEC_ID_TWINVQ(VideoJNI.Codec_CODEC_ID_TWINVQ_get()),
        CODEC_ID_TRUEHD(VideoJNI.Codec_CODEC_ID_TRUEHD_get()),
        CODEC_ID_MP4ALS(VideoJNI.Codec_CODEC_ID_MP4ALS_get()),
        CODEC_ID_ATRAC1(VideoJNI.Codec_CODEC_ID_ATRAC1_get()),
        CODEC_ID_BINKAUDIO_RDFT(VideoJNI.Codec_CODEC_ID_BINKAUDIO_RDFT_get()),
        CODEC_ID_BINKAUDIO_DCT(VideoJNI.Codec_CODEC_ID_BINKAUDIO_DCT_get()),
        CODEC_ID_AAC_LATM(VideoJNI.Codec_CODEC_ID_AAC_LATM_get()),
        CODEC_ID_QDMC(VideoJNI.Codec_CODEC_ID_QDMC_get()),
        CODEC_ID_CELT(VideoJNI.Codec_CODEC_ID_CELT_get()),
        CODEC_ID_G723_1(VideoJNI.Codec_CODEC_ID_G723_1_get()),
        CODEC_ID_G729(VideoJNI.Codec_CODEC_ID_G729_get()),
        CODEC_ID_8SVX_EXP(VideoJNI.Codec_CODEC_ID_8SVX_EXP_get()),
        CODEC_ID_8SVX_FIB(VideoJNI.Codec_CODEC_ID_8SVX_FIB_get()),
        CODEC_ID_BMV_AUDIO(VideoJNI.Codec_CODEC_ID_BMV_AUDIO_get()),
        CODEC_ID_RALF(VideoJNI.Codec_CODEC_ID_RALF_get()),
        CODEC_ID_IAC(VideoJNI.Codec_CODEC_ID_IAC_get()),
        CODEC_ID_ILBC(VideoJNI.Codec_CODEC_ID_ILBC_get()),
        CODEC_ID_OPUS_DEPRECATED(VideoJNI.Codec_CODEC_ID_OPUS_DEPRECATED_get()),
        CODEC_ID_COMFORT_NOISE(VideoJNI.Codec_CODEC_ID_COMFORT_NOISE_get()),
        CODEC_ID_TAK_DEPRECATED(VideoJNI.Codec_CODEC_ID_TAK_DEPRECATED_get()),
        CODEC_ID_METASOUND(VideoJNI.Codec_CODEC_ID_METASOUND_get()),
        CODEC_ID_PAF_AUDIO_DEPRECATED(VideoJNI.Codec_CODEC_ID_PAF_AUDIO_DEPRECATED_get()),
        CODEC_ID_ON2AVC(VideoJNI.Codec_CODEC_ID_ON2AVC_get()),
        CODEC_ID_DSS_SP(VideoJNI.Codec_CODEC_ID_DSS_SP_get()),
        CODEC_ID_FFWAVESYNTH(VideoJNI.Codec_CODEC_ID_FFWAVESYNTH_get()),
        CODEC_ID_SONIC(VideoJNI.Codec_CODEC_ID_SONIC_get()),
        CODEC_ID_SONIC_LS(VideoJNI.Codec_CODEC_ID_SONIC_LS_get()),
        CODEC_ID_PAF_AUDIO(VideoJNI.Codec_CODEC_ID_PAF_AUDIO_get()),
        CODEC_ID_OPUS(VideoJNI.Codec_CODEC_ID_OPUS_get()),
        CODEC_ID_TAK(VideoJNI.Codec_CODEC_ID_TAK_get()),
        CODEC_ID_EVRC(VideoJNI.Codec_CODEC_ID_EVRC_get()),
        CODEC_ID_SMV(VideoJNI.Codec_CODEC_ID_SMV_get()),
        CODEC_ID_DSD_LSBF(VideoJNI.Codec_CODEC_ID_DSD_LSBF_get()),
        CODEC_ID_DSD_MSBF(VideoJNI.Codec_CODEC_ID_DSD_MSBF_get()),
        CODEC_ID_DSD_LSBF_PLANAR(VideoJNI.Codec_CODEC_ID_DSD_LSBF_PLANAR_get()),
        CODEC_ID_DSD_MSBF_PLANAR(VideoJNI.Codec_CODEC_ID_DSD_MSBF_PLANAR_get()),
        CODEC_ID_4GV(VideoJNI.Codec_CODEC_ID_4GV_get()),
        CODEC_ID_FIRST_SUBTITLE(VideoJNI.Codec_CODEC_ID_FIRST_SUBTITLE_get()),
        CODEC_ID_DVD_SUBTITLE(VideoJNI.Codec_CODEC_ID_DVD_SUBTITLE_get()),
        CODEC_ID_DVB_SUBTITLE(VideoJNI.Codec_CODEC_ID_DVB_SUBTITLE_get()),
        CODEC_ID_TEXT(VideoJNI.Codec_CODEC_ID_TEXT_get()),
        CODEC_ID_XSUB(VideoJNI.Codec_CODEC_ID_XSUB_get()),
        CODEC_ID_SSA(VideoJNI.Codec_CODEC_ID_SSA_get()),
        CODEC_ID_MOV_TEXT(VideoJNI.Codec_CODEC_ID_MOV_TEXT_get()),
        CODEC_ID_HDMV_PGS_SUBTITLE(VideoJNI.Codec_CODEC_ID_HDMV_PGS_SUBTITLE_get()),
        CODEC_ID_DVB_TELETEXT(VideoJNI.Codec_CODEC_ID_DVB_TELETEXT_get()),
        CODEC_ID_SRT(VideoJNI.Codec_CODEC_ID_SRT_get()),
        CODEC_ID_MICRODVD(VideoJNI.Codec_CODEC_ID_MICRODVD_get()),
        CODEC_ID_EIA_608(VideoJNI.Codec_CODEC_ID_EIA_608_get()),
        CODEC_ID_JACOSUB(VideoJNI.Codec_CODEC_ID_JACOSUB_get()),
        CODEC_ID_SAMI(VideoJNI.Codec_CODEC_ID_SAMI_get()),
        CODEC_ID_REALTEXT(VideoJNI.Codec_CODEC_ID_REALTEXT_get()),
        CODEC_ID_STL(VideoJNI.Codec_CODEC_ID_STL_get()),
        CODEC_ID_SUBVIEWER1(VideoJNI.Codec_CODEC_ID_SUBVIEWER1_get()),
        CODEC_ID_SUBVIEWER(VideoJNI.Codec_CODEC_ID_SUBVIEWER_get()),
        CODEC_ID_SUBRIP(VideoJNI.Codec_CODEC_ID_SUBRIP_get()),
        CODEC_ID_WEBVTT(VideoJNI.Codec_CODEC_ID_WEBVTT_get()),
        CODEC_ID_MPL2(VideoJNI.Codec_CODEC_ID_MPL2_get()),
        CODEC_ID_VPLAYER(VideoJNI.Codec_CODEC_ID_VPLAYER_get()),
        CODEC_ID_PJS(VideoJNI.Codec_CODEC_ID_PJS_get()),
        CODEC_ID_ASS(VideoJNI.Codec_CODEC_ID_ASS_get()),
        CODEC_ID_HDMV_TEXT_SUBTITLE(VideoJNI.Codec_CODEC_ID_HDMV_TEXT_SUBTITLE_get()),
        CODEC_ID_FIRST_UNKNOWN(VideoJNI.Codec_CODEC_ID_FIRST_UNKNOWN_get()),
        CODEC_ID_TTF(VideoJNI.Codec_CODEC_ID_TTF_get()),
        CODEC_ID_BINTEXT(VideoJNI.Codec_CODEC_ID_BINTEXT_get()),
        CODEC_ID_XBIN(VideoJNI.Codec_CODEC_ID_XBIN_get()),
        CODEC_ID_IDF(VideoJNI.Codec_CODEC_ID_IDF_get()),
        CODEC_ID_OTF(VideoJNI.Codec_CODEC_ID_OTF_get()),
        CODEC_ID_SMPTE_KLV(VideoJNI.Codec_CODEC_ID_SMPTE_KLV_get()),
        CODEC_ID_DVD_NAV(VideoJNI.Codec_CODEC_ID_DVD_NAV_get()),
        CODEC_ID_TIMED_ID3(VideoJNI.Codec_CODEC_ID_TIMED_ID3_get()),
        CODEC_ID_BIN_DATA(VideoJNI.Codec_CODEC_ID_BIN_DATA_get()),
        CODEC_ID_PROBE(VideoJNI.Codec_CODEC_ID_PROBE_get()),
        CODEC_ID_MPEG2TS(VideoJNI.Codec_CODEC_ID_MPEG2TS_get()),
        CODEC_ID_MPEG4SYSTEMS(VideoJNI.Codec_CODEC_ID_MPEG4SYSTEMS_get()),
        CODEC_ID_FFMETADATA(VideoJNI.Codec_CODEC_ID_FFMETADATA_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ID swigToEnum(int swigValue) {
            ID[] swigValues = (ID[])ID.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ID swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ID.class + " with value " + swigValue);
        }

        private ID() {
            this.swigValue = SwigNext.next++;
        }

        private ID(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ID(ID swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum DiscardFlag {
        DISCARD_NONE(VideoJNI.Codec_DISCARD_NONE_get()),
        DISCARD_DEFAULT(VideoJNI.Codec_DISCARD_DEFAULT_get()),
        DISCARD_NONREF(VideoJNI.Codec_DISCARD_NONREF_get()),
        DISCARD_BIDIR(VideoJNI.Codec_DISCARD_BIDIR_get()),
        DISCARD_NONKEY(VideoJNI.Codec_DISCARD_NONKEY_get()),
        DISCARD_ALL(VideoJNI.Codec_DISCARD_ALL_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static DiscardFlag swigToEnum(int swigValue) {
            DiscardFlag[] swigValues = (DiscardFlag[])DiscardFlag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (DiscardFlag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + DiscardFlag.class + " with value " + swigValue);
        }

        private DiscardFlag() {
            this.swigValue = SwigNext.next++;
        }

        private DiscardFlag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private DiscardFlag(DiscardFlag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

