/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.Codec;
import io.humble.video.MediaDescriptor;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class CodecDescriptor
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected CodecDescriptor(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.CodecDescriptor_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected CodecDescriptor(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.CodecDescriptor_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CodecDescriptor obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public CodecDescriptor copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new CodecDescriptor(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof CodecDescriptor) {
            equal = ((CodecDescriptor)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("name:" + this.getName() + ";");
        result.append("longname:" + this.getName() + ";");
        result.append("properties:" + this.getProperties() + ";");
        result.append("]");
        return result.toString();
    }

    public boolean hasProperty(CodecProperty p) {
        return VideoJNI.CodecDescriptor_hasProperty(this.swigCPtr, this, p.swigValue());
    }

    public String getName() {
        return VideoJNI.CodecDescriptor_getName(this.swigCPtr, this);
    }

    public String getLongName() {
        return VideoJNI.CodecDescriptor_getLongName(this.swigCPtr, this);
    }

    public int getProperties() {
        return VideoJNI.CodecDescriptor_getProperties(this.swigCPtr, this);
    }

    public Codec.ID getId() {
        return Codec.ID.swigToEnum(VideoJNI.CodecDescriptor_getId(this.swigCPtr, this));
    }

    public MediaDescriptor.Type getType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.CodecDescriptor_getType(this.swigCPtr, this));
    }

    public static CodecDescriptor make(Codec.ID id) {
        long cPtr = VideoJNI.CodecDescriptor_make(id.swigValue());
        return cPtr == 0L ? null : new CodecDescriptor(cPtr, false);
    }

    public static enum CodecProperty {
        PROP_INTRA_ONLY(VideoJNI.CodecDescriptor_PROP_INTRA_ONLY_get()),
        PROP_LOSSY(VideoJNI.CodecDescriptor_PROP_LOSSY_get()),
        PROP_LOSSLESS(VideoJNI.CodecDescriptor_PROP_LOSSLESS_get()),
        PROP_BITMAP_SUB(VideoJNI.CodecDescriptor_PROP_BITMAP_SUB_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CodecProperty swigToEnum(int swigValue) {
            CodecProperty[] swigValues = (CodecProperty[])CodecProperty.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CodecProperty swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CodecProperty.class + " with value " + swigValue);
        }

        private CodecProperty() {
            this.swigValue = SwigNext.next++;
        }

        private CodecProperty(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CodecProperty(CodecProperty swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

