/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.Codec;
import io.humble.video.Configurable;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaDescriptor;
import io.humble.video.PixelFormat;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Coder
extends Configurable {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Coder(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Coder_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Coder(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Coder_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Coder obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Coder copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Coder(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Coder) {
            equal = ((Coder)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        MediaDescriptor.Type type = this.getCodecType();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("codec=" + this.getCodec() + ";");
        result.append("time base=" + this.getTimeBase() + ";");
        switch (type) {
            case MEDIA_VIDEO: {
                result.append("width=" + this.getWidth() + ";");
                result.append("height=" + this.getHeight() + ";");
                result.append("pixel format=" + (Object)((Object)this.getPixelFormat()) + ";");
                break;
            }
            case MEDIA_AUDIO: {
                result.append("sample rate=" + this.getSampleRate() + ";");
                result.append("channels=" + this.getChannels() + ";");
                result.append("sample format=" + (Object)((Object)this.getSampleFormat()) + ";");
                break;
            }
        }
        result.append("frame size=" + this.getFrameSize() + ";");
        result.append("frame count=" + this.getFrameCount() + ";");
        result.append("]");
        return result.toString();
    }

    public void open(KeyValueBag inputOptions, KeyValueBag unsetOptions) {
        VideoJNI.Coder_open(this.swigCPtr, this, KeyValueBag.getCPtr(inputOptions), inputOptions, KeyValueBag.getCPtr(unsetOptions), unsetOptions);
    }

    public Codec getCodec() {
        long cPtr = VideoJNI.Coder_getCodec(this.swigCPtr, this);
        return cPtr == 0L ? null : new Codec(cPtr, false);
    }

    public MediaDescriptor.Type getCodecType() {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.Coder_getCodecType(this.swigCPtr, this));
    }

    public Codec.ID getCodecID() {
        return Codec.ID.swigToEnum(VideoJNI.Coder_getCodecID(this.swigCPtr, this));
    }

    public int getHeight() {
        return VideoJNI.Coder_getHeight(this.swigCPtr, this);
    }

    public void setHeight(int height) {
        VideoJNI.Coder_setHeight(this.swigCPtr, this, height);
    }

    public int getWidth() {
        return VideoJNI.Coder_getWidth(this.swigCPtr, this);
    }

    public void setWidth(int width) {
        VideoJNI.Coder_setWidth(this.swigCPtr, this, width);
    }

    public PixelFormat.Type getPixelFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.Coder_getPixelFormat(this.swigCPtr, this));
    }

    public void setPixelFormat(PixelFormat.Type pixelFmt) {
        VideoJNI.Coder_setPixelFormat(this.swigCPtr, this, pixelFmt.swigValue());
    }

    public int getSampleRate() {
        return VideoJNI.Coder_getSampleRate(this.swigCPtr, this);
    }

    public void setSampleRate(int sampleRate) {
        VideoJNI.Coder_setSampleRate(this.swigCPtr, this, sampleRate);
    }

    public AudioFormat.Type getSampleFormat() {
        return AudioFormat.Type.swigToEnum(VideoJNI.Coder_getSampleFormat(this.swigCPtr, this));
    }

    public void setSampleFormat(AudioFormat.Type format) {
        VideoJNI.Coder_setSampleFormat(this.swigCPtr, this, format.swigValue());
    }

    public int getChannels() {
        return VideoJNI.Coder_getChannels(this.swigCPtr, this);
    }

    public void setChannels(int channels) {
        VideoJNI.Coder_setChannels(this.swigCPtr, this, channels);
    }

    public AudioChannel.Layout getChannelLayout() {
        return AudioChannel.Layout.swigToEnum(VideoJNI.Coder_getChannelLayout(this.swigCPtr, this));
    }

    public void setChannelLayout(AudioChannel.Layout layout) {
        VideoJNI.Coder_setChannelLayout(this.swigCPtr, this, layout.swigValue());
    }

    public Rational getTimeBase() {
        long cPtr = VideoJNI.Coder_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public void setTimeBase(Rational newTimeBase) {
        VideoJNI.Coder_setTimeBase(this.swigCPtr, this, Rational.getCPtr(newTimeBase), newTimeBase);
    }

    public State getState() {
        return State.swigToEnum(VideoJNI.Coder_getState(this.swigCPtr, this));
    }

    public int getFrameCount() {
        return VideoJNI.Coder_getFrameCount(this.swigCPtr, this);
    }

    public int getFrameSize() {
        return VideoJNI.Coder_getFrameSize(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.Coder_getFlags(this.swigCPtr, this);
    }

    public int getFlag(Flag flag) {
        return VideoJNI.Coder_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public int getFlags2() {
        return VideoJNI.Coder_getFlags2(this.swigCPtr, this);
    }

    public int getFlag2(Flag2 flag) {
        return VideoJNI.Coder_getFlag2(this.swigCPtr, this, flag.swigValue());
    }

    public void setFlags(int newVal) {
        VideoJNI.Coder_setFlags(this.swigCPtr, this, newVal);
    }

    public void setFlag(Flag flag, boolean value) {
        VideoJNI.Coder_setFlag(this.swigCPtr, this, flag.swigValue(), value);
    }

    public void setFlags2(int newVal) {
        VideoJNI.Coder_setFlags2(this.swigCPtr, this, newVal);
    }

    public void setFlag2(Flag2 flag, boolean value) {
        VideoJNI.Coder_setFlag2(this.swigCPtr, this, flag.swigValue(), value);
    }

    public static enum Flag2 {
        FLAG2_FAST(VideoJNI.Coder_FLAG2_FAST_get()),
        FLAG2_NO_OUTPUT(VideoJNI.Coder_FLAG2_NO_OUTPUT_get()),
        FLAG2_LOCAL_HEADER(VideoJNI.Coder_FLAG2_LOCAL_HEADER_get()),
        FLAG2_DROP_FRAME_TIMECODE(VideoJNI.Coder_FLAG2_DROP_FRAME_TIMECODE_get()),
        FLAG2_IGNORE_CROP(VideoJNI.Coder_FLAG2_IGNORE_CROP_get()),
        FLAG2_CHUNKS(VideoJNI.Coder_FLAG2_CHUNKS_get()),
        FLAG2_SHOW_ALL(VideoJNI.Coder_FLAG2_SHOW_ALL_get()),
        FLAG2_EXPORT_MVS(VideoJNI.Coder_FLAG2_EXPORT_MVS_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag2 swigToEnum(int swigValue) {
            Flag2[] swigValues = (Flag2[])Flag2.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag2 swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag2.class + " with value " + swigValue);
        }

        private Flag2() {
            this.swigValue = SwigNext.next++;
        }

        private Flag2(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag2(Flag2 swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Flag {
        FLAG_UNALIGNED(VideoJNI.Coder_FLAG_UNALIGNED_get()),
        FLAG_QSCALE(VideoJNI.Coder_FLAG_QSCALE_get()),
        FLAG_4MV(VideoJNI.Coder_FLAG_4MV_get()),
        FLAG_QPEL(VideoJNI.Coder_FLAG_QPEL_get()),
        FLAG_GMC(VideoJNI.Coder_FLAG_GMC_get()),
        FLAG_MV0(VideoJNI.Coder_FLAG_MV0_get()),
        FLAG_INPUT_PRESERVED(VideoJNI.Coder_FLAG_INPUT_PRESERVED_get()),
        FLAG_PASS1(VideoJNI.Coder_FLAG_PASS1_get()),
        FLAG_PASS2(VideoJNI.Coder_FLAG_PASS2_get()),
        FLAG_GRAY(VideoJNI.Coder_FLAG_GRAY_get()),
        FLAG_EMU_EDGE(VideoJNI.Coder_FLAG_EMU_EDGE_get()),
        FLAG_PSNR(VideoJNI.Coder_FLAG_PSNR_get()),
        FLAG_TRUNCATED(VideoJNI.Coder_FLAG_TRUNCATED_get()),
        FLAG_NORMALIZE_AQP(VideoJNI.Coder_FLAG_NORMALIZE_AQP_get()),
        FLAG_INTERLACED_DCT(VideoJNI.Coder_FLAG_INTERLACED_DCT_get()),
        FLAG_LOW_DELAY(VideoJNI.Coder_FLAG_LOW_DELAY_get()),
        FLAG_GLOBAL_HEADER(VideoJNI.Coder_FLAG_GLOBAL_HEADER_get()),
        FLAG_BITEXACT(VideoJNI.Coder_FLAG_BITEXACT_get()),
        FLAG_AC_PRED(VideoJNI.Coder_FLAG_AC_PRED_get()),
        FLAG_LOOP_FILTER(VideoJNI.Coder_FLAG_LOOP_FILTER_get()),
        FLAG_INTERLACED_ME(VideoJNI.Coder_FLAG_INTERLACED_ME_get()),
        FLAG_CLOSED_GOP(VideoJNI.Coder_FLAG_CLOSED_GOP_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum State {
        STATE_INITED,
        STATE_OPENED,
        STATE_FLUSHING,
        STATE_ERROR;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static State swigToEnum(int swigValue) {
            State[] swigValues = (State[])State.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (State swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + State.class + " with value " + swigValue);
        }

        private State() {
            this.swigValue = SwigNext.next++;
        }

        private State(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private State(State swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

