/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Configurable;
import io.humble.video.VideoJNI;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class Container
extends Configurable {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Container(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Container_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Container(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Container_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Container obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Container copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Container(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Container) {
            equal = ((Container)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("[").append("]");
        return b.toString();
    }

    public int getNumStreams() throws InterruptedException, IOException {
        return VideoJNI.Container_getNumStreams(this.swigCPtr, this);
    }

    public static enum Flag {
        FLAG_GENPTS(VideoJNI.Container_FLAG_GENPTS_get()),
        FLAG_IGNIDX(VideoJNI.Container_FLAG_IGNIDX_get()),
        FLAG_NONBLOCK(VideoJNI.Container_FLAG_NONBLOCK_get()),
        FLAG_IGNDTS(VideoJNI.Container_FLAG_IGNDTS_get()),
        FLAG_NOFILLIN(VideoJNI.Container_FLAG_NOFILLIN_get()),
        FLAG_NOPARSE(VideoJNI.Container_FLAG_NOPARSE_get()),
        FLAG_NOBUFFER(VideoJNI.Container_FLAG_NOBUFFER_get()),
        FLAG_CUSTOM_IO(VideoJNI.Container_FLAG_CUSTOM_IO_get()),
        FLAG_DISCARD_CORRUPT(VideoJNI.Container_FLAG_DISCARD_CORRUPT_get()),
        FLAG_MP4A_LATM(VideoJNI.Container_FLAG_MP4A_LATM_get()),
        FLAG_SORT_DTS(VideoJNI.Container_FLAG_SORT_DTS_get()),
        FLAG_PRIV_OPT(VideoJNI.Container_FLAG_PRIV_OPT_get()),
        FLAG_KEEP_SIDE_DATA(VideoJNI.Container_FLAG_KEEP_SIDE_DATA_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

