/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.Container;
import io.humble.video.IndexEntry;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaPacket;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ContainerStream
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected ContainerStream(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.ContainerStream_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected ContainerStream(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.ContainerStream_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ContainerStream obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public ContainerStream copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new ContainerStream(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof ContainerStream) {
            equal = ((ContainerStream)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public List<IndexEntry> getIndexEntries() {
        int numEntries = this.getNumIndexEntries();
        ArrayList<IndexEntry> retval = new ArrayList<IndexEntry>(Math.max(numEntries, 10));
        for (int i = 0; i < numEntries; ++i) {
            IndexEntry entry = this.getIndexEntry(i);
            if (entry == null) continue;
            retval.add(entry);
        }
        return retval;
    }

    public int getIndex() {
        return VideoJNI.ContainerStream_getIndex(this.swigCPtr, this);
    }

    public int getId() {
        return VideoJNI.ContainerStream_getId(this.swigCPtr, this);
    }

    public Rational getFrameRate() {
        long cPtr = VideoJNI.ContainerStream_getFrameRate(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public Rational getTimeBase() {
        long cPtr = VideoJNI.ContainerStream_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public long getStartTime() {
        return VideoJNI.ContainerStream_getStartTime(this.swigCPtr, this);
    }

    public long getDuration() {
        return VideoJNI.ContainerStream_getDuration(this.swigCPtr, this);
    }

    public long getCurrentDts() {
        return VideoJNI.ContainerStream_getCurrentDts(this.swigCPtr, this);
    }

    public int getNumIndexEntries() {
        return VideoJNI.ContainerStream_getNumIndexEntries(this.swigCPtr, this);
    }

    public long getNumFrames() {
        return VideoJNI.ContainerStream_getNumFrames(this.swigCPtr, this);
    }

    public Rational getSampleAspectRatio() {
        long cPtr = VideoJNI.ContainerStream_getSampleAspectRatio(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public Container getContainer() {
        long cPtr = VideoJNI.ContainerStream_getContainer(this.swigCPtr, this);
        return cPtr == 0L ? null : new Container(cPtr, false);
    }

    public ParseType getParseType() {
        return ParseType.swigToEnum(VideoJNI.ContainerStream_getParseType(this.swigCPtr, this));
    }

    public void setParseType(ParseType type) {
        VideoJNI.ContainerStream_setParseType(this.swigCPtr, this, type.swigValue());
    }

    public KeyValueBag getMetaData() {
        long cPtr = VideoJNI.ContainerStream_getMetaData(this.swigCPtr, this);
        return cPtr == 0L ? null : new KeyValueBag(cPtr, false);
    }

    public IndexEntry findTimeStampEntryInIndex(long wantedTimeStamp, int flags) {
        long cPtr = VideoJNI.ContainerStream_findTimeStampEntryInIndex(this.swigCPtr, this, wantedTimeStamp, flags);
        return cPtr == 0L ? null : new IndexEntry(cPtr, false);
    }

    public int findTimeStampPositionInIndex(long wantedTimeStamp, int flags) {
        return VideoJNI.ContainerStream_findTimeStampPositionInIndex(this.swigCPtr, this, wantedTimeStamp, flags);
    }

    public IndexEntry getIndexEntry(int position) {
        long cPtr = VideoJNI.ContainerStream_getIndexEntry(this.swigCPtr, this, position);
        return cPtr == 0L ? null : new IndexEntry(cPtr, false);
    }

    public Disposition getDisposition() {
        return Disposition.swigToEnum(VideoJNI.ContainerStream_getDisposition(this.swigCPtr, this));
    }

    public MediaPacket getAttachedPic() {
        long cPtr = VideoJNI.ContainerStream_getAttachedPic(this.swigCPtr, this);
        return cPtr == 0L ? null : new MediaPacket(cPtr, false);
    }

    public boolean matchSpecifier(String specifier) {
        return VideoJNI.ContainerStream_matchSpecifier(this.swigCPtr, this, specifier);
    }

    public static enum ParseType {
        PARSE_NONE(VideoJNI.ContainerStream_PARSE_NONE_get()),
        PARSE_FULL(VideoJNI.ContainerStream_PARSE_FULL_get()),
        PARSE_HEADERS(VideoJNI.ContainerStream_PARSE_HEADERS_get()),
        PARSE_TIMESTAMPS(VideoJNI.ContainerStream_PARSE_TIMESTAMPS_get()),
        PARSE_FULL_ONCE(VideoJNI.ContainerStream_PARSE_FULL_ONCE_get()),
        PARSE_FULL_RAW(VideoJNI.ContainerStream_PARSE_FULL_RAW_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ParseType swigToEnum(int swigValue) {
            ParseType[] swigValues = (ParseType[])ParseType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ParseType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ParseType.class + " with value " + swigValue);
        }

        private ParseType() {
            this.swigValue = SwigNext.next++;
        }

        private ParseType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ParseType(ParseType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Disposition {
        DISPOSITION_NONE(VideoJNI.ContainerStream_DISPOSITION_NONE_get()),
        DISPOSITION_DEFAULT(VideoJNI.ContainerStream_DISPOSITION_DEFAULT_get()),
        DISPOSITION_DUB(VideoJNI.ContainerStream_DISPOSITION_DUB_get()),
        DISPOSITION_ORIGINAL(VideoJNI.ContainerStream_DISPOSITION_ORIGINAL_get()),
        DISPOSITION_COMMENT(VideoJNI.ContainerStream_DISPOSITION_COMMENT_get()),
        DISPOSITION_LYRICS(VideoJNI.ContainerStream_DISPOSITION_LYRICS_get()),
        DISPOSITION_KARAOKE(VideoJNI.ContainerStream_DISPOSITION_KARAOKE_get()),
        DISPOSITION_FORCED(VideoJNI.ContainerStream_DISPOSITION_FORCED_get()),
        DISPOSITION_HEARING_IMPAIRED(VideoJNI.ContainerStream_DISPOSITION_HEARING_IMPAIRED_get()),
        DISPOSITION_VISUAL_IMPAIRED(VideoJNI.ContainerStream_DISPOSITION_VISUAL_IMPAIRED_get()),
        DISPOSITION_CLEAN_EFFECTS(VideoJNI.ContainerStream_DISPOSITION_CLEAN_EFFECTS_get()),
        DISPOSITION_ATTACHED_PIC(VideoJNI.ContainerStream_DISPOSITION_ATTACHED_PIC_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Disposition swigToEnum(int swigValue) {
            Disposition[] swigValues = (Disposition[])Disposition.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Disposition swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Disposition.class + " with value " + swigValue);
        }

        private Disposition() {
            this.swigValue = SwigNext.next++;
        }

        private Disposition(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Disposition(Disposition swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

