/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Codec;
import io.humble.video.Coder;
import io.humble.video.MediaAudio;
import io.humble.video.MediaPacket;
import io.humble.video.MediaPicture;
import io.humble.video.MediaSampled;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Decoder
extends Coder {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Decoder(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Decoder_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Decoder(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Decoder_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Decoder obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Decoder copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Decoder(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Decoder) {
            equal = ((Decoder)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static Decoder make(Codec codec) {
        long cPtr = VideoJNI.Decoder_make__SWIG_0(Codec.getCPtr(codec), codec);
        return cPtr == 0L ? null : new Decoder(cPtr, false);
    }

    public static Decoder make(Coder src) {
        long cPtr = VideoJNI.Decoder_make__SWIG_1(Coder.getCPtr(src), src);
        return cPtr == 0L ? null : new Decoder(cPtr, false);
    }

    public void flush() {
        VideoJNI.Decoder_flush(this.swigCPtr, this);
    }

    public int decodeAudio(MediaAudio output, MediaPacket packet, int byteOffset) {
        return VideoJNI.Decoder_decodeAudio(this.swigCPtr, this, MediaAudio.getCPtr(output), output, MediaPacket.getCPtr(packet), packet, byteOffset);
    }

    public int decodeVideo(MediaPicture output, MediaPacket packet, int byteOffset) {
        return VideoJNI.Decoder_decodeVideo(this.swigCPtr, this, MediaPicture.getCPtr(output), output, MediaPacket.getCPtr(packet), packet, byteOffset);
    }

    public int decode(MediaSampled output, MediaPacket packet, int byteOffset) {
        return VideoJNI.Decoder_decode(this.swigCPtr, this, MediaSampled.getCPtr(output), output, MediaPacket.getCPtr(packet), packet, byteOffset);
    }
}

