/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.ContainerStream;
import io.humble.video.Decoder;
import io.humble.video.Demuxer;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class DemuxerStream
extends ContainerStream {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected DemuxerStream(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.DemuxerStream_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected DemuxerStream(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.DemuxerStream_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DemuxerStream obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public DemuxerStream copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new DemuxerStream(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof DemuxerStream) {
            equal = ((DemuxerStream)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("index:" + this.getIndex() + ";");
        result.append("id:" + this.getId() + ";");
        result.append("framerate:" + this.getFrameRate() + ";");
        result.append("timebase:" + this.getTimeBase() + ";");
        result.append("]");
        return result.toString();
    }

    public Decoder getDecoder() {
        long cPtr = VideoJNI.DemuxerStream_getDecoder(this.swigCPtr, this);
        return cPtr == 0L ? null : new Decoder(cPtr, false);
    }

    public Demuxer getDemuxer() {
        long cPtr = VideoJNI.DemuxerStream_getDemuxer(this.swigCPtr, this);
        return cPtr == 0L ? null : new Demuxer(cPtr, false);
    }
}

