/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.MediaDescriptor;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class FilterType
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected FilterType(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.FilterType_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected FilterType(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.FilterType_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FilterType obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public FilterType copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new FilterType(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof FilterType) {
            equal = ((FilterType)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String getName() {
        return VideoJNI.FilterType_getName(this.swigCPtr, this);
    }

    public String getDescription() {
        return VideoJNI.FilterType_getDescription(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.FilterType_getFlags(this.swigCPtr, this);
    }

    public boolean getFlag(Flag flag) {
        return VideoJNI.FilterType_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public int getNumInputs() {
        return VideoJNI.FilterType_getNumInputs(this.swigCPtr, this);
    }

    public String getInputName(int index) {
        return VideoJNI.FilterType_getInputName(this.swigCPtr, this, index);
    }

    public MediaDescriptor.Type getInputType(int index) {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterType_getInputType(this.swigCPtr, this, index));
    }

    public int getNumOutputs() {
        return VideoJNI.FilterType_getNumOutputs(this.swigCPtr, this);
    }

    public String getOutputName(int index) {
        return VideoJNI.FilterType_getOutputName(this.swigCPtr, this, index);
    }

    public MediaDescriptor.Type getOutputType(int index) {
        return MediaDescriptor.Type.swigToEnum(VideoJNI.FilterType_getOutputType(this.swigCPtr, this, index));
    }

    public static FilterType findFilterType(String name) {
        long cPtr = VideoJNI.FilterType_findFilterType(name);
        return cPtr == 0L ? null : new FilterType(cPtr, false);
    }

    public static int getNumFilterTypes() {
        return VideoJNI.FilterType_getNumFilterTypes();
    }

    public static FilterType getFilterType(int index) {
        long cPtr = VideoJNI.FilterType_getFilterType(index);
        return cPtr == 0L ? null : new FilterType(cPtr, false);
    }

    public static enum Flag {
        FILTER_FLAG_UNKNOWN(VideoJNI.FilterType_FILTER_FLAG_UNKNOWN_get()),
        FILTER_FLAG_DYNAMIC_INPUTS(VideoJNI.FilterType_FILTER_FLAG_DYNAMIC_INPUTS_get()),
        FILTER_FLAG_DYNAMIC_OUTPUTS(VideoJNI.FilterType_FILTER_FLAG_DYNAMIC_OUTPUTS_get()),
        FILTER_FLAG_SLICE_THREADS(VideoJNI.FilterType_FILTER_FLAG_SLICE_THREADS_get()),
        FILTER_FLAG_SUPPORT_TIMELINE_GENERIC(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_GENERIC_get()),
        FILTER_FLAG_SUPPORT_TIMELINE_INTERNAL(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_INTERNAL_get()),
        FILTER_FLAG_SUPPORT_TIMELINE(VideoJNI.FilterType_FILTER_FLAG_SUPPORT_TIMELINE_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

