/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class IndexEntry
extends RefCounted {
    private volatile long swigCPtr;
    public static final int INDEX_FLAG_KEYFRAME = VideoJNI.IndexEntry_INDEX_FLAG_KEYFRAME_get();

    private void noop() {
        Buffer.make(null, 1);
    }

    protected IndexEntry(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.IndexEntry_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IndexEntry(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.IndexEntry_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IndexEntry obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IndexEntry copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IndexEntry(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IndexEntry) {
            equal = ((IndexEntry)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("position:" + this.getPosition() + ";");
        result.append("timestamp:" + this.getTimeStamp() + ";");
        result.append("flags:" + this.getFlags() + ";");
        result.append("size:" + this.getSize() + ";");
        result.append("min-distance:" + this.getMinDistance() + ";");
        result.append("]");
        return result.toString();
    }

    public static IndexEntry make(long position, long timeStamp, int flags, int size, int minDistance) {
        long cPtr = VideoJNI.IndexEntry_make(position, timeStamp, flags, size, minDistance);
        return cPtr == 0L ? null : new IndexEntry(cPtr, false);
    }

    public long getPosition() {
        return VideoJNI.IndexEntry_getPosition(this.swigCPtr, this);
    }

    public long getTimeStamp() {
        return VideoJNI.IndexEntry_getTimeStamp(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.IndexEntry_getFlags(this.swigCPtr, this);
    }

    public int getSize() {
        return VideoJNI.IndexEntry_getSize(this.swigCPtr, this);
    }

    public int getMinDistance() {
        return VideoJNI.IndexEntry_getMinDistance(this.swigCPtr, this);
    }

    public boolean isKeyFrame() {
        return VideoJNI.IndexEntry_isKeyFrame(this.swigCPtr, this);
    }
}

