/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.MediaAudio;
import io.humble.video.MediaResampler;
import io.humble.video.MediaSampled;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaAudioResampler
extends MediaResampler {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaAudioResampler(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaAudioResampler_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaAudioResampler(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaAudioResampler_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaAudioResampler obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaAudioResampler copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaAudioResampler(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaAudioResampler) {
            equal = ((MediaAudioResampler)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static MediaAudioResampler make(AudioChannel.Layout outLayout, int outSampleRate, AudioFormat.Type outFormat, AudioChannel.Layout inLayout, int inSampleRate, AudioFormat.Type inFormat) {
        long cPtr = VideoJNI.MediaAudioResampler_make(outLayout.swigValue(), outSampleRate, outFormat.swigValue(), inLayout.swigValue(), inSampleRate, inFormat.swigValue());
        return cPtr == 0L ? null : new MediaAudioResampler(cPtr, false);
    }

    public AudioChannel.Layout getOutputLayout() {
        return AudioChannel.Layout.swigToEnum(VideoJNI.MediaAudioResampler_getOutputLayout(this.swigCPtr, this));
    }

    public AudioChannel.Layout getInputLayout() {
        return AudioChannel.Layout.swigToEnum(VideoJNI.MediaAudioResampler_getInputLayout(this.swigCPtr, this));
    }

    public int getOutputSampleRate() {
        return VideoJNI.MediaAudioResampler_getOutputSampleRate(this.swigCPtr, this);
    }

    public int getInputSampleRate() {
        return VideoJNI.MediaAudioResampler_getInputSampleRate(this.swigCPtr, this);
    }

    public AudioFormat.Type getOutputFormat() {
        return AudioFormat.Type.swigToEnum(VideoJNI.MediaAudioResampler_getOutputFormat(this.swigCPtr, this));
    }

    public AudioFormat.Type getInputFormat() {
        return AudioFormat.Type.swigToEnum(VideoJNI.MediaAudioResampler_getInputFormat(this.swigCPtr, this));
    }

    public int getInputChannels() {
        return VideoJNI.MediaAudioResampler_getInputChannels(this.swigCPtr, this);
    }

    public int getOutputChannels() {
        return VideoJNI.MediaAudioResampler_getOutputChannels(this.swigCPtr, this);
    }

    public void open() {
        VideoJNI.MediaAudioResampler_open(this.swigCPtr, this);
    }

    @Override
    public int resample(MediaSampled out, MediaSampled in) {
        return VideoJNI.MediaAudioResampler_resample(this.swigCPtr, this, MediaSampled.getCPtr(out), out, MediaSampled.getCPtr(in), in);
    }

    public int resampleAudio(MediaAudio out, MediaAudio in) {
        return VideoJNI.MediaAudioResampler_resampleAudio(this.swigCPtr, this, MediaAudio.getCPtr(out), out, MediaAudio.getCPtr(in), in);
    }

    public long getNextPts(long pts) {
        return VideoJNI.MediaAudioResampler_getNextPts(this.swigCPtr, this, pts);
    }

    public void setCompensation(int sample_delta, int compensation_distance) {
        VideoJNI.MediaAudioResampler_setCompensation(this.swigCPtr, this, sample_delta, compensation_distance);
    }

    public int dropOutput(int count) {
        return VideoJNI.MediaAudioResampler_dropOutput(this.swigCPtr, this, count);
    }

    public int injectSilence(int count) {
        return VideoJNI.MediaAudioResampler_injectSilence(this.swigCPtr, this, count);
    }

    public long getDelay(long base) {
        return VideoJNI.MediaAudioResampler_getDelay(this.swigCPtr, this, base);
    }

    public int getNumResampledSamples(int numSamples) {
        return VideoJNI.MediaAudioResampler_getNumResampledSamples(this.swigCPtr, this, numSamples);
    }

    public Rational getTimeBase() {
        long cPtr = VideoJNI.MediaAudioResampler_getTimeBase(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public void setTimeBase(Rational rational) {
        VideoJNI.MediaAudioResampler_setTimeBase(this.swigCPtr, this, Rational.getCPtr(rational), rational);
    }

    @Override
    public MediaResampler.State getState() {
        return MediaResampler.State.swigToEnum(VideoJNI.MediaAudioResampler_getState(this.swigCPtr, this));
    }
}

