/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.MediaEncoded;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaPacket
extends MediaEncoded {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaPacket(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaPacket_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaPacket(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaPacket_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaPacket obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaPacket copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaPacket(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaPacket) {
            equal = ((MediaPacket)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("[").append("pts=" + this.getPts() + ";").append("dts=" + this.getDts() + ";").append("complete=" + this.isComplete() + ";").append("size=" + this.getSize() + ";").append("maxSize=" + this.getMaxSize() + ";").append("streamIndex=" + this.getStreamIndex() + ";").append("key=" + this.isKey() + ";").append("flags=" + this.getFlags() + ";").append("duration=" + this.getDuration() + ";").append("position=" + this.getPosition() + ";").append("convergenceDuration=" + this.getConvergenceDuration() + ";").append("]");
        return b.toString();
    }

    public static MediaPacket make() {
        long cPtr = VideoJNI.MediaPacket_make__SWIG_0();
        return cPtr == 0L ? null : new MediaPacket(cPtr, false);
    }

    public static MediaPacket make(Buffer buffer) {
        long cPtr = VideoJNI.MediaPacket_make__SWIG_1(Buffer.getCPtr(buffer), buffer);
        return cPtr == 0L ? null : new MediaPacket(cPtr, false);
    }

    public static MediaPacket make(MediaPacket packet, boolean copyData) {
        long cPtr = VideoJNI.MediaPacket_make__SWIG_2(MediaPacket.getCPtr(packet), packet, copyData);
        return cPtr == 0L ? null : new MediaPacket(cPtr, false);
    }

    public static MediaPacket make(int size) {
        long cPtr = VideoJNI.MediaPacket_make__SWIG_3(size);
        return cPtr == 0L ? null : new MediaPacket(cPtr, false);
    }

    public Buffer getData() {
        long cPtr = VideoJNI.MediaPacket_getData(this.swigCPtr, this);
        return cPtr == 0L ? null : new Buffer(cPtr, false);
    }

    public int getNumSideDataElems() {
        return VideoJNI.MediaPacket_getNumSideDataElems(this.swigCPtr, this);
    }

    public Buffer getSideData(int n) {
        long cPtr = VideoJNI.MediaPacket_getSideData(this.swigCPtr, this, n);
        return cPtr == 0L ? null : new Buffer(cPtr, false);
    }

    public SideDataType getSideDataType(int n) {
        return SideDataType.swigToEnum(VideoJNI.MediaPacket_getSideDataType(this.swigCPtr, this, n));
    }

    public long getPts() {
        return VideoJNI.MediaPacket_getPts(this.swigCPtr, this);
    }

    public void setPts(long aPts) {
        VideoJNI.MediaPacket_setPts(this.swigCPtr, this, aPts);
    }

    public long getDts() {
        return VideoJNI.MediaPacket_getDts(this.swigCPtr, this);
    }

    public void setDts(long aDts) {
        VideoJNI.MediaPacket_setDts(this.swigCPtr, this, aDts);
    }

    public int getSize() {
        return VideoJNI.MediaPacket_getSize(this.swigCPtr, this);
    }

    public int getMaxSize() {
        return VideoJNI.MediaPacket_getMaxSize(this.swigCPtr, this);
    }

    public int getStreamIndex() {
        return VideoJNI.MediaPacket_getStreamIndex(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.MediaPacket_getFlags(this.swigCPtr, this);
    }

    public boolean isKeyPacket() {
        return VideoJNI.MediaPacket_isKeyPacket(this.swigCPtr, this);
    }

    public long getDuration() {
        return VideoJNI.MediaPacket_getDuration(this.swigCPtr, this);
    }

    public long getPosition() {
        return VideoJNI.MediaPacket_getPosition(this.swigCPtr, this);
    }

    public void setKeyPacket(boolean keyPacket) {
        VideoJNI.MediaPacket_setKeyPacket(this.swigCPtr, this, keyPacket);
    }

    public void setFlags(int flags) {
        VideoJNI.MediaPacket_setFlags(this.swigCPtr, this, flags);
    }

    public void setStreamIndex(int streamIndex) {
        VideoJNI.MediaPacket_setStreamIndex(this.swigCPtr, this, streamIndex);
    }

    public void setDuration(long duration) {
        VideoJNI.MediaPacket_setDuration(this.swigCPtr, this, duration);
    }

    public void setPosition(long position) {
        VideoJNI.MediaPacket_setPosition(this.swigCPtr, this, position);
    }

    public long getConvergenceDuration() {
        return VideoJNI.MediaPacket_getConvergenceDuration(this.swigCPtr, this);
    }

    public void setConvergenceDuration(long duration) {
        VideoJNI.MediaPacket_setConvergenceDuration(this.swigCPtr, this, duration);
    }

    public void reset(int payloadSize) {
        VideoJNI.MediaPacket_reset(this.swigCPtr, this, payloadSize);
    }

    public static enum SideDataType {
        DATA_UNKNOWN(VideoJNI.MediaPacket_DATA_UNKNOWN_get()),
        DATA_PALETTE(VideoJNI.MediaPacket_DATA_PALETTE_get()),
        DATA_NEW_EXTRADATA(VideoJNI.MediaPacket_DATA_NEW_EXTRADATA_get()),
        DATA_PARAM_CHANGE(VideoJNI.MediaPacket_DATA_PARAM_CHANGE_get()),
        DATA_H263_MB_INFO(VideoJNI.MediaPacket_DATA_H263_MB_INFO_get()),
        DATA_SKIP_SAMPLES(VideoJNI.MediaPacket_DATA_SKIP_SAMPLES_get()),
        DATA_JP_DUALMONO(VideoJNI.MediaPacket_DATA_JP_DUALMONO_get()),
        DATA_STRINGS_METADATA(VideoJNI.MediaPacket_DATA_STRINGS_METADATA_get()),
        DATA_SUBTITLE_POSITION(VideoJNI.MediaPacket_DATA_SUBTITLE_POSITION_get()),
        DATA_MATROSKA_BLOCKADDITIONAL(VideoJNI.MediaPacket_DATA_MATROSKA_BLOCKADDITIONAL_get()),
        DATA_WEBVTT_IDENTIFIER(VideoJNI.MediaPacket_DATA_WEBVTT_IDENTIFIER_get()),
        DATA_WEBVTT_SETTINGS(VideoJNI.MediaPacket_DATA_WEBVTT_SETTINGS_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static SideDataType swigToEnum(int swigValue) {
            SideDataType[] swigValues = (SideDataType[])SideDataType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (SideDataType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + SideDataType.class + " with value " + swigValue);
        }

        private SideDataType() {
            this.swigValue = SwigNext.next++;
        }

        private SideDataType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private SideDataType(SideDataType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

