/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Global;
import io.humble.video.MediaSampled;
import io.humble.video.PixelFormat;
import io.humble.video.Rational;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaPicture
extends MediaSampled {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaPicture(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaPicture_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaPicture(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaPicture_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaPicture obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaPicture copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaPicture(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaPicture) {
            equal = ((MediaPicture)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("width:" + this.getWidth() + ";");
        result.append("height:" + this.getHeight() + ";");
        result.append("format:" + (Object)((Object)this.getFormat()) + ";");
        result.append("time stamp:" + this.getTimeStamp() + ";");
        result.append("complete:" + this.isComplete() + ";");
        result.append("key:" + this.isKey() + ";");
        Rational timeBase = Global.getDefaultTimeBase();
        result.append("time base:" + timeBase + ";");
        for (int i = 0; i < this.getNumDataPlanes(); ++i) {
            result.append("plane[" + i + "] size: " + this.getDataPlaneSize(i) + ";");
        }
        if (timeBase != null) {
            timeBase.delete();
        }
        result.append("]");
        return result.toString();
    }

    public static MediaPicture make(int width, int height, PixelFormat.Type format) {
        long cPtr = VideoJNI.MediaPicture_make__SWIG_0(width, height, format.swigValue());
        return cPtr == 0L ? null : new MediaPicture(cPtr, false);
    }

    public static MediaPicture make(Buffer buffer, int width, int height, PixelFormat.Type format) {
        long cPtr = VideoJNI.MediaPicture_make__SWIG_1(Buffer.getCPtr(buffer), buffer, width, height, format.swigValue());
        return cPtr == 0L ? null : new MediaPicture(cPtr, false);
    }

    public static MediaPicture make(MediaPicture src, boolean copy) {
        long cPtr = VideoJNI.MediaPicture_make__SWIG_2(MediaPicture.getCPtr(src), src, copy);
        return cPtr == 0L ? null : new MediaPicture(cPtr, false);
    }

    public Buffer getData(int plane) {
        long cPtr = VideoJNI.MediaPicture_getData(this.swigCPtr, this, plane);
        return cPtr == 0L ? null : new Buffer(cPtr, false);
    }

    public int getDataPlaneSize(int plane) {
        return VideoJNI.MediaPicture_getDataPlaneSize(this.swigCPtr, this, plane);
    }

    public int getNumDataPlanes() {
        return VideoJNI.MediaPicture_getNumDataPlanes(this.swigCPtr, this);
    }

    public int getLineSize(int plane) {
        return VideoJNI.MediaPicture_getLineSize(this.swigCPtr, this, plane);
    }

    @Override
    public void setComplete(boolean complete) {
        VideoJNI.MediaPicture_setComplete(this.swigCPtr, this, complete);
    }

    @Override
    public boolean isComplete() {
        return VideoJNI.MediaPicture_isComplete(this.swigCPtr, this);
    }

    public int getWidth() {
        return VideoJNI.MediaPicture_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return VideoJNI.MediaPicture_getHeight(this.swigCPtr, this);
    }

    public PixelFormat.Type getFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.MediaPicture_getFormat(this.swigCPtr, this));
    }

    public int getCodedPictureNumber() {
        return VideoJNI.MediaPicture_getCodedPictureNumber(this.swigCPtr, this);
    }

    public void setCodedPictureNumber(int n) {
        VideoJNI.MediaPicture_setCodedPictureNumber(this.swigCPtr, this, n);
    }

    public int getDisplayPictureNumber() {
        return VideoJNI.MediaPicture_getDisplayPictureNumber(this.swigCPtr, this);
    }

    public void setDisplayPictureNumber(int n) {
        VideoJNI.MediaPicture_setDisplayPictureNumber(this.swigCPtr, this, n);
    }

    public int getQuality() {
        return VideoJNI.MediaPicture_getQuality(this.swigCPtr, this);
    }

    public void setQuality(int q) {
        VideoJNI.MediaPicture_setQuality(this.swigCPtr, this, q);
    }

    public long getError(int dataPlane) {
        return VideoJNI.MediaPicture_getError(this.swigCPtr, this, dataPlane);
    }

    public int getRepeatPicture() {
        return VideoJNI.MediaPicture_getRepeatPicture(this.swigCPtr, this);
    }

    public void setRepeatPicture(int n) {
        VideoJNI.MediaPicture_setRepeatPicture(this.swigCPtr, this, n);
    }

    public boolean isInterlacedFrame() {
        return VideoJNI.MediaPicture_isInterlacedFrame(this.swigCPtr, this);
    }

    public void setInterlacedFrame(boolean val) {
        VideoJNI.MediaPicture_setInterlacedFrame(this.swigCPtr, this, val);
    }

    public boolean isTopFieldFirst() {
        return VideoJNI.MediaPicture_isTopFieldFirst(this.swigCPtr, this);
    }

    public void setTopFieldFirst(boolean val) {
        VideoJNI.MediaPicture_setTopFieldFirst(this.swigCPtr, this, val);
    }

    public boolean isPaletteChanged() {
        return VideoJNI.MediaPicture_isPaletteChanged(this.swigCPtr, this);
    }

    public void setPaletteChange(boolean val) {
        VideoJNI.MediaPicture_setPaletteChange(this.swigCPtr, this, val);
    }

    public Type getType() {
        return Type.swigToEnum(VideoJNI.MediaPicture_getType(this.swigCPtr, this));
    }

    public void setType(Type type) {
        VideoJNI.MediaPicture_setType(this.swigCPtr, this, type.swigValue());
    }

    public static enum Type {
        PICTURE_TYPE_NONE(VideoJNI.MediaPicture_PICTURE_TYPE_NONE_get()),
        PICTURE_TYPE_I(VideoJNI.MediaPicture_PICTURE_TYPE_I_get()),
        PICTURE_TYPE_P(VideoJNI.MediaPicture_PICTURE_TYPE_P_get()),
        PICTURE_TYPE_B(VideoJNI.MediaPicture_PICTURE_TYPE_B_get()),
        PICTURE_TYPE_S(VideoJNI.MediaPicture_PICTURE_TYPE_S_get()),
        PICTURE_TYPE_SI(VideoJNI.MediaPicture_PICTURE_TYPE_SI_get()),
        PICTURE_TYPE_SP(VideoJNI.MediaPicture_PICTURE_TYPE_SP_get()),
        PICTURE_TYPE_BI(VideoJNI.MediaPicture_PICTURE_TYPE_BI_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

