/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.MediaPicture;
import io.humble.video.MediaResampler;
import io.humble.video.MediaSampled;
import io.humble.video.PixelFormat;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaPictureResampler
extends MediaResampler {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaPictureResampler(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaPictureResampler_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaPictureResampler(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaPictureResampler_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaPictureResampler obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaPictureResampler copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaPictureResampler(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaPictureResampler) {
            equal = ((MediaPictureResampler)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("input width:" + this.getInputWidth() + ";");
        result.append("input height:" + this.getInputHeight() + ";");
        result.append("input format:" + (Object)((Object)this.getInputFormat()) + ";");
        result.append("output width:" + this.getOutputWidth() + ";");
        result.append("output height:" + this.getOutputHeight() + ";");
        result.append("output format:" + (Object)((Object)this.getOutputFormat()) + ";");
        result.append("]");
        return result.toString();
    }

    public int getInputWidth() {
        return VideoJNI.MediaPictureResampler_getInputWidth(this.swigCPtr, this);
    }

    public int getInputHeight() {
        return VideoJNI.MediaPictureResampler_getInputHeight(this.swigCPtr, this);
    }

    public PixelFormat.Type getInputFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.MediaPictureResampler_getInputFormat(this.swigCPtr, this));
    }

    public int getOutputWidth() {
        return VideoJNI.MediaPictureResampler_getOutputWidth(this.swigCPtr, this);
    }

    public int getOutputHeight() {
        return VideoJNI.MediaPictureResampler_getOutputHeight(this.swigCPtr, this);
    }

    public PixelFormat.Type getOutputFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.MediaPictureResampler_getOutputFormat(this.swigCPtr, this));
    }

    public void open() {
        VideoJNI.MediaPictureResampler_open(this.swigCPtr, this);
    }

    @Override
    public int resample(MediaSampled out, MediaSampled in) {
        return VideoJNI.MediaPictureResampler_resample(this.swigCPtr, this, MediaSampled.getCPtr(out), out, MediaSampled.getCPtr(in), in);
    }

    public int resamplePicture(MediaPicture out, MediaPicture in) {
        return VideoJNI.MediaPictureResampler_resamplePicture(this.swigCPtr, this, MediaPicture.getCPtr(out), out, MediaPicture.getCPtr(in), in);
    }

    public static MediaPictureResampler make(int outputWidth, int outputHeight, PixelFormat.Type outputFmt, int inputWidth, int inputHeight, PixelFormat.Type inputFmt, int flags) {
        long cPtr = VideoJNI.MediaPictureResampler_make(outputWidth, outputHeight, outputFmt.swigValue(), inputWidth, inputHeight, inputFmt.swigValue(), flags);
        return cPtr == 0L ? null : new MediaPictureResampler(cPtr, false);
    }

    public static enum Flag {
        FLAG_FAST_BILINEAR(VideoJNI.MediaPictureResampler_FLAG_FAST_BILINEAR_get()),
        FLAG_BILINEAR(VideoJNI.MediaPictureResampler_FLAG_BILINEAR_get()),
        FLAG_BICUBIC(VideoJNI.MediaPictureResampler_FLAG_BICUBIC_get()),
        FLAG_X(VideoJNI.MediaPictureResampler_FLAG_X_get()),
        FLAG_POINT(VideoJNI.MediaPictureResampler_FLAG_POINT_get()),
        FLAG_AREA(VideoJNI.MediaPictureResampler_FLAG_AREA_get()),
        FLAG_BICUBLIN(VideoJNI.MediaPictureResampler_FLAG_BICUBLIN_get()),
        FLAG_GAUSS(VideoJNI.MediaPictureResampler_FLAG_GAUSS_get()),
        FLAG_SINC(VideoJNI.MediaPictureResampler_FLAG_SINC_get()),
        FLAG_LANCZOS(VideoJNI.MediaPictureResampler_FLAG_LANCZOS_get()),
        FLAG_SPLINE(VideoJNI.MediaPictureResampler_FLAG_SPLINE_get()),
        FLAG_SRC_V_CHR_DROP_MASK(VideoJNI.MediaPictureResampler_FLAG_SRC_V_CHR_DROP_MASK_get()),
        FLAG_SRC_V_CHR_DROP_SHIFT(VideoJNI.MediaPictureResampler_FLAG_SRC_V_CHR_DROP_SHIFT_get()),
        FLAG_PARAM_DEFAULT(VideoJNI.MediaPictureResampler_FLAG_PARAM_DEFAULT_get()),
        FLAG_FULL_CHR_H_INT(VideoJNI.MediaPictureResampler_FLAG_FULL_CHR_H_INT_get()),
        FLAG_FULL_CHR_H_INP(VideoJNI.MediaPictureResampler_FLAG_FULL_CHR_H_INP_get()),
        FLAG_DIRECT_BGR(VideoJNI.MediaPictureResampler_FLAG_DIRECT_BGR_get()),
        FLAG_ACCURATE_RND(VideoJNI.MediaPictureResampler_FLAG_ACCURATE_RND_get()),
        FLAG_BITEXACT(VideoJNI.MediaPictureResampler_FLAG_BITEXACT_get()),
        FLAG_ERROR_DIFFUSION(VideoJNI.MediaPictureResampler_FLAG_ERROR_DIFFUSION_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

