/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.MediaSubtitle;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class MediaSubtitleRectangle
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected MediaSubtitleRectangle(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.MediaSubtitleRectangle_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected MediaSubtitleRectangle(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.MediaSubtitleRectangle_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MediaSubtitleRectangle obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public MediaSubtitleRectangle copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new MediaSubtitleRectangle(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof MediaSubtitleRectangle) {
            equal = ((MediaSubtitleRectangle)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public int getX() {
        return VideoJNI.MediaSubtitleRectangle_getX(this.swigCPtr, this);
    }

    public int getY() {
        return VideoJNI.MediaSubtitleRectangle_getY(this.swigCPtr, this);
    }

    public int getWidth() {
        return VideoJNI.MediaSubtitleRectangle_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return VideoJNI.MediaSubtitleRectangle_getHeight(this.swigCPtr, this);
    }

    public int getNumColors() {
        return VideoJNI.MediaSubtitleRectangle_getNumColors(this.swigCPtr, this);
    }

    public MediaSubtitle.Type getType() {
        return MediaSubtitle.Type.swigToEnum(VideoJNI.MediaSubtitleRectangle_getType(this.swigCPtr, this));
    }

    public String getText() {
        return VideoJNI.MediaSubtitleRectangle_getText(this.swigCPtr, this);
    }

    public String getASS() {
        return VideoJNI.MediaSubtitleRectangle_getASS(this.swigCPtr, this);
    }

    public int getFlags() {
        return VideoJNI.MediaSubtitleRectangle_getFlags(this.swigCPtr, this);
    }

    public int getPictureLinesize(int line) {
        return VideoJNI.MediaSubtitleRectangle_getPictureLinesize(this.swigCPtr, this, line);
    }

    public Buffer getPictureData(int line) {
        long cPtr = VideoJNI.MediaSubtitleRectangle_getPictureData(this.swigCPtr, this, line);
        return cPtr == 0L ? null : new Buffer(cPtr, false);
    }

    public static enum Flag {
        SUBTITLE_FLAG_FORCED(VideoJNI.MediaSubtitleRectangle_SUBTITLE_FLAG_FORCED_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

