/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.video.Coder;
import io.humble.video.Container;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaPacket;
import io.humble.video.MuxerFormat;
import io.humble.video.MuxerStream;
import io.humble.video.VideoJNI;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class Muxer
extends Container {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Muxer(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Muxer_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Muxer(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Muxer_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Muxer obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Muxer copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Muxer(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Muxer) {
            equal = ((Muxer)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("[").append("url=" + this.getURL() + ";").append("format:" + this.getFormat() + ";").append("]");
        return b.toString();
    }

    public static Muxer make(String filename, MuxerFormat format, String formatName) {
        long cPtr = VideoJNI.Muxer_make(filename, MuxerFormat.getCPtr(format), format, formatName);
        return cPtr == 0L ? null : new Muxer(cPtr, false);
    }

    public String getURL() {
        return VideoJNI.Muxer_getURL(this.swigCPtr, this);
    }

    public MuxerFormat getFormat() {
        long cPtr = VideoJNI.Muxer_getFormat(this.swigCPtr, this);
        return cPtr == 0L ? null : new MuxerFormat(cPtr, false);
    }

    public State getState() {
        return State.swigToEnum(VideoJNI.Muxer_getState(this.swigCPtr, this));
    }

    public void open(KeyValueBag inputOptions, KeyValueBag outputOptions) throws InterruptedException, IOException {
        VideoJNI.Muxer_open(this.swigCPtr, this, KeyValueBag.getCPtr(inputOptions), inputOptions, KeyValueBag.getCPtr(outputOptions), outputOptions);
    }

    public void close() {
        VideoJNI.Muxer_close(this.swigCPtr, this);
    }

    @Override
    public int getNumStreams() throws InterruptedException, IOException {
        return VideoJNI.Muxer_getNumStreams(this.swigCPtr, this);
    }

    public void setOutputBufferLength(int size) {
        VideoJNI.Muxer_setOutputBufferLength(this.swigCPtr, this, size);
    }

    public int getOutputBufferLength() {
        return VideoJNI.Muxer_getOutputBufferLength(this.swigCPtr, this);
    }

    public MuxerStream addNewStream(Coder coder) {
        long cPtr = VideoJNI.Muxer_addNewStream(this.swigCPtr, this, Coder.getCPtr(coder), coder);
        return cPtr == 0L ? null : new MuxerStream(cPtr, false);
    }

    public MuxerStream getStream(int position) throws InterruptedException, IOException {
        long cPtr = VideoJNI.Muxer_getStream(this.swigCPtr, this, position);
        return cPtr == 0L ? null : new MuxerStream(cPtr, false);
    }

    public boolean write(MediaPacket packet, boolean forceInterleave) {
        return VideoJNI.Muxer_write(this.swigCPtr, this, MediaPacket.getCPtr(packet), packet, forceInterleave);
    }

    public static enum State {
        STATE_INITED,
        STATE_OPENED,
        STATE_CLOSED,
        STATE_ERROR;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static State swigToEnum(int swigValue) {
            State[] swigValues = (State[])State.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (State swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + State.class + " with value " + swigValue);
        }

        private State() {
            this.swigValue = SwigNext.next++;
        }

        private State(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private State(State swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

