/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.PixelFormatDescriptor;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class PixelFormat
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected PixelFormat(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.PixelFormat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected PixelFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.PixelFormat_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(PixelFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public PixelFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new PixelFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof PixelFormat) {
            equal = ((PixelFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static Type getFormat(String name) {
        return Type.swigToEnum(VideoJNI.PixelFormat_getFormat(name));
    }

    public static String getFormatName(Type pix_fmt) {
        return VideoJNI.PixelFormat_getFormatName(pix_fmt.swigValue());
    }

    public static PixelFormatDescriptor getDescriptor(Type pix_fmt) {
        long cPtr = VideoJNI.PixelFormat_getDescriptor(pix_fmt.swigValue());
        return cPtr == 0L ? null : new PixelFormatDescriptor(cPtr, false);
    }

    public static int getNumInstalledFormats() {
        return VideoJNI.PixelFormat_getNumInstalledFormats();
    }

    public static PixelFormatDescriptor getInstalledFormatDescriptor(int i) {
        long cPtr = VideoJNI.PixelFormat_getInstalledFormatDescriptor(i);
        return cPtr == 0L ? null : new PixelFormatDescriptor(cPtr, false);
    }

    public static int getNumPlanes(Type pix_fmt) {
        return VideoJNI.PixelFormat_getNumPlanes(pix_fmt.swigValue());
    }

    public static Type swapEndianness(Type pix_fmt) {
        return Type.swigToEnum(VideoJNI.PixelFormat_swapEndianness(pix_fmt.swigValue()));
    }

    public static int getBufferSizeNeeded(int width, int height, Type pix_fmt) {
        return VideoJNI.PixelFormat_getBufferSizeNeeded(width, height, pix_fmt.swigValue());
    }

    public static enum Type {
        PIX_FMT_NONE(VideoJNI.PixelFormat_PIX_FMT_NONE_get()),
        PIX_FMT_YUV420P(VideoJNI.PixelFormat_PIX_FMT_YUV420P_get()),
        PIX_FMT_YUYV422(VideoJNI.PixelFormat_PIX_FMT_YUYV422_get()),
        PIX_FMT_RGB24(VideoJNI.PixelFormat_PIX_FMT_RGB24_get()),
        PIX_FMT_BGR24(VideoJNI.PixelFormat_PIX_FMT_BGR24_get()),
        PIX_FMT_YUV422P(VideoJNI.PixelFormat_PIX_FMT_YUV422P_get()),
        PIX_FMT_YUV444P(VideoJNI.PixelFormat_PIX_FMT_YUV444P_get()),
        PIX_FMT_YUV410P(VideoJNI.PixelFormat_PIX_FMT_YUV410P_get()),
        PIX_FMT_YUV411P(VideoJNI.PixelFormat_PIX_FMT_YUV411P_get()),
        PIX_FMT_GRAY8(VideoJNI.PixelFormat_PIX_FMT_GRAY8_get()),
        PIX_FMT_MONOWHITE(VideoJNI.PixelFormat_PIX_FMT_MONOWHITE_get()),
        PIX_FMT_MONOBLACK(VideoJNI.PixelFormat_PIX_FMT_MONOBLACK_get()),
        PIX_FMT_PAL8(VideoJNI.PixelFormat_PIX_FMT_PAL8_get()),
        PIX_FMT_YUVJ420P(VideoJNI.PixelFormat_PIX_FMT_YUVJ420P_get()),
        PIX_FMT_YUVJ422P(VideoJNI.PixelFormat_PIX_FMT_YUVJ422P_get()),
        PIX_FMT_YUVJ444P(VideoJNI.PixelFormat_PIX_FMT_YUVJ444P_get()),
        PIX_FMT_XVMC_MPEG2_MC(VideoJNI.PixelFormat_PIX_FMT_XVMC_MPEG2_MC_get()),
        PIX_FMT_XVMC_MPEG2_IDCT(VideoJNI.PixelFormat_PIX_FMT_XVMC_MPEG2_IDCT_get()),
        PIX_FMT_UYVY422(VideoJNI.PixelFormat_PIX_FMT_UYVY422_get()),
        PIX_FMT_UYYVYY411(VideoJNI.PixelFormat_PIX_FMT_UYYVYY411_get()),
        PIX_FMT_BGR8(VideoJNI.PixelFormat_PIX_FMT_BGR8_get()),
        PIX_FMT_BGR4(VideoJNI.PixelFormat_PIX_FMT_BGR4_get()),
        PIX_FMT_BGR4_BYTE(VideoJNI.PixelFormat_PIX_FMT_BGR4_BYTE_get()),
        PIX_FMT_RGB8(VideoJNI.PixelFormat_PIX_FMT_RGB8_get()),
        PIX_FMT_RGB4(VideoJNI.PixelFormat_PIX_FMT_RGB4_get()),
        PIX_FMT_RGB4_BYTE(VideoJNI.PixelFormat_PIX_FMT_RGB4_BYTE_get()),
        PIX_FMT_NV12(VideoJNI.PixelFormat_PIX_FMT_NV12_get()),
        PIX_FMT_NV21(VideoJNI.PixelFormat_PIX_FMT_NV21_get()),
        PIX_FMT_ARGB(VideoJNI.PixelFormat_PIX_FMT_ARGB_get()),
        PIX_FMT_RGBA(VideoJNI.PixelFormat_PIX_FMT_RGBA_get()),
        PIX_FMT_ABGR(VideoJNI.PixelFormat_PIX_FMT_ABGR_get()),
        PIX_FMT_BGRA(VideoJNI.PixelFormat_PIX_FMT_BGRA_get()),
        PIX_FMT_GRAY16BE(VideoJNI.PixelFormat_PIX_FMT_GRAY16BE_get()),
        PIX_FMT_GRAY16LE(VideoJNI.PixelFormat_PIX_FMT_GRAY16LE_get()),
        PIX_FMT_YUV440P(VideoJNI.PixelFormat_PIX_FMT_YUV440P_get()),
        PIX_FMT_YUVJ440P(VideoJNI.PixelFormat_PIX_FMT_YUVJ440P_get()),
        PIX_FMT_YUVA420P(VideoJNI.PixelFormat_PIX_FMT_YUVA420P_get()),
        PIX_FMT_VDPAU_H264(VideoJNI.PixelFormat_PIX_FMT_VDPAU_H264_get()),
        PIX_FMT_VDPAU_MPEG1(VideoJNI.PixelFormat_PIX_FMT_VDPAU_MPEG1_get()),
        PIX_FMT_VDPAU_MPEG2(VideoJNI.PixelFormat_PIX_FMT_VDPAU_MPEG2_get()),
        PIX_FMT_VDPAU_WMV3(VideoJNI.PixelFormat_PIX_FMT_VDPAU_WMV3_get()),
        PIX_FMT_VDPAU_VC1(VideoJNI.PixelFormat_PIX_FMT_VDPAU_VC1_get()),
        PIX_FMT_RGB48BE(VideoJNI.PixelFormat_PIX_FMT_RGB48BE_get()),
        PIX_FMT_RGB48LE(VideoJNI.PixelFormat_PIX_FMT_RGB48LE_get()),
        PIX_FMT_RGB565BE(VideoJNI.PixelFormat_PIX_FMT_RGB565BE_get()),
        PIX_FMT_RGB565LE(VideoJNI.PixelFormat_PIX_FMT_RGB565LE_get()),
        PIX_FMT_RGB555BE(VideoJNI.PixelFormat_PIX_FMT_RGB555BE_get()),
        PIX_FMT_RGB555LE(VideoJNI.PixelFormat_PIX_FMT_RGB555LE_get()),
        PIX_FMT_BGR565BE(VideoJNI.PixelFormat_PIX_FMT_BGR565BE_get()),
        PIX_FMT_BGR565LE(VideoJNI.PixelFormat_PIX_FMT_BGR565LE_get()),
        PIX_FMT_BGR555BE(VideoJNI.PixelFormat_PIX_FMT_BGR555BE_get()),
        PIX_FMT_BGR555LE(VideoJNI.PixelFormat_PIX_FMT_BGR555LE_get()),
        PIX_FMT_VAAPI_MOCO(VideoJNI.PixelFormat_PIX_FMT_VAAPI_MOCO_get()),
        PIX_FMT_VAAPI_IDCT(VideoJNI.PixelFormat_PIX_FMT_VAAPI_IDCT_get()),
        PIX_FMT_VAAPI_VLD(VideoJNI.PixelFormat_PIX_FMT_VAAPI_VLD_get()),
        PIX_FMT_YUV420P16LE(VideoJNI.PixelFormat_PIX_FMT_YUV420P16LE_get()),
        PIX_FMT_YUV420P16BE(VideoJNI.PixelFormat_PIX_FMT_YUV420P16BE_get()),
        PIX_FMT_YUV422P16LE(VideoJNI.PixelFormat_PIX_FMT_YUV422P16LE_get()),
        PIX_FMT_YUV422P16BE(VideoJNI.PixelFormat_PIX_FMT_YUV422P16BE_get()),
        PIX_FMT_YUV444P16LE(VideoJNI.PixelFormat_PIX_FMT_YUV444P16LE_get()),
        PIX_FMT_YUV444P16BE(VideoJNI.PixelFormat_PIX_FMT_YUV444P16BE_get()),
        PIX_FMT_VDPAU_MPEG4(VideoJNI.PixelFormat_PIX_FMT_VDPAU_MPEG4_get()),
        PIX_FMT_DXVA2_VLD(VideoJNI.PixelFormat_PIX_FMT_DXVA2_VLD_get()),
        PIX_FMT_RGB444LE(VideoJNI.PixelFormat_PIX_FMT_RGB444LE_get()),
        PIX_FMT_RGB444BE(VideoJNI.PixelFormat_PIX_FMT_RGB444BE_get()),
        PIX_FMT_BGR444LE(VideoJNI.PixelFormat_PIX_FMT_BGR444LE_get()),
        PIX_FMT_BGR444BE(VideoJNI.PixelFormat_PIX_FMT_BGR444BE_get()),
        PIX_FMT_GRAY8A(VideoJNI.PixelFormat_PIX_FMT_GRAY8A_get()),
        PIX_FMT_BGR48BE(VideoJNI.PixelFormat_PIX_FMT_BGR48BE_get()),
        PIX_FMT_BGR48LE(VideoJNI.PixelFormat_PIX_FMT_BGR48LE_get()),
        PIX_FMT_YUV420P9BE(VideoJNI.PixelFormat_PIX_FMT_YUV420P9BE_get()),
        PIX_FMT_YUV420P9LE(VideoJNI.PixelFormat_PIX_FMT_YUV420P9LE_get()),
        PIX_FMT_YUV420P10BE(VideoJNI.PixelFormat_PIX_FMT_YUV420P10BE_get()),
        PIX_FMT_YUV420P10LE(VideoJNI.PixelFormat_PIX_FMT_YUV420P10LE_get()),
        PIX_FMT_YUV422P10BE(VideoJNI.PixelFormat_PIX_FMT_YUV422P10BE_get()),
        PIX_FMT_YUV422P10LE(VideoJNI.PixelFormat_PIX_FMT_YUV422P10LE_get()),
        PIX_FMT_YUV444P9BE(VideoJNI.PixelFormat_PIX_FMT_YUV444P9BE_get()),
        PIX_FMT_YUV444P9LE(VideoJNI.PixelFormat_PIX_FMT_YUV444P9LE_get()),
        PIX_FMT_YUV444P10BE(VideoJNI.PixelFormat_PIX_FMT_YUV444P10BE_get()),
        PIX_FMT_YUV444P10LE(VideoJNI.PixelFormat_PIX_FMT_YUV444P10LE_get()),
        PIX_FMT_YUV422P9BE(VideoJNI.PixelFormat_PIX_FMT_YUV422P9BE_get()),
        PIX_FMT_YUV422P9LE(VideoJNI.PixelFormat_PIX_FMT_YUV422P9LE_get()),
        PIX_FMT_VDA_VLD(VideoJNI.PixelFormat_PIX_FMT_VDA_VLD_get()),
        PIX_FMT_GBRP(VideoJNI.PixelFormat_PIX_FMT_GBRP_get()),
        PIX_FMT_GBRP9BE(VideoJNI.PixelFormat_PIX_FMT_GBRP9BE_get()),
        PIX_FMT_GBRP9LE(VideoJNI.PixelFormat_PIX_FMT_GBRP9LE_get()),
        PIX_FMT_GBRP10BE(VideoJNI.PixelFormat_PIX_FMT_GBRP10BE_get()),
        PIX_FMT_GBRP10LE(VideoJNI.PixelFormat_PIX_FMT_GBRP10LE_get()),
        PIX_FMT_GBRP16BE(VideoJNI.PixelFormat_PIX_FMT_GBRP16BE_get()),
        PIX_FMT_GBRP16LE(VideoJNI.PixelFormat_PIX_FMT_GBRP16LE_get()),
        PIX_FMT_YUVA422P_LIBAV(VideoJNI.PixelFormat_PIX_FMT_YUVA422P_LIBAV_get()),
        PIX_FMT_YUVA444P_LIBAV(VideoJNI.PixelFormat_PIX_FMT_YUVA444P_LIBAV_get()),
        PIX_FMT_YUVA420P9BE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P9BE_get()),
        PIX_FMT_YUVA420P9LE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P9LE_get()),
        PIX_FMT_YUVA422P9BE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P9BE_get()),
        PIX_FMT_YUVA422P9LE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P9LE_get()),
        PIX_FMT_YUVA444P9BE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P9BE_get()),
        PIX_FMT_YUVA444P9LE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P9LE_get()),
        PIX_FMT_YUVA420P10BE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P10BE_get()),
        PIX_FMT_YUVA420P10LE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P10LE_get()),
        PIX_FMT_YUVA422P10BE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P10BE_get()),
        PIX_FMT_YUVA422P10LE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P10LE_get()),
        PIX_FMT_YUVA444P10BE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P10BE_get()),
        PIX_FMT_YUVA444P10LE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P10LE_get()),
        PIX_FMT_YUVA420P16BE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P16BE_get()),
        PIX_FMT_YUVA420P16LE(VideoJNI.PixelFormat_PIX_FMT_YUVA420P16LE_get()),
        PIX_FMT_YUVA422P16BE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P16BE_get()),
        PIX_FMT_YUVA422P16LE(VideoJNI.PixelFormat_PIX_FMT_YUVA422P16LE_get()),
        PIX_FMT_YUVA444P16BE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P16BE_get()),
        PIX_FMT_YUVA444P16LE(VideoJNI.PixelFormat_PIX_FMT_YUVA444P16LE_get()),
        PIX_FMT_VDPAU(VideoJNI.PixelFormat_PIX_FMT_VDPAU_get()),
        PIX_FMT_XYZ12LE(VideoJNI.PixelFormat_PIX_FMT_XYZ12LE_get()),
        PIX_FMT_XYZ12BE(VideoJNI.PixelFormat_PIX_FMT_XYZ12BE_get()),
        PIX_FMT_RGBA64BE(VideoJNI.PixelFormat_PIX_FMT_RGBA64BE_get()),
        PIX_FMT_RGBA64LE(VideoJNI.PixelFormat_PIX_FMT_RGBA64LE_get()),
        PIX_FMT_BGRA64BE(VideoJNI.PixelFormat_PIX_FMT_BGRA64BE_get()),
        PIX_FMT_BGRA64LE(VideoJNI.PixelFormat_PIX_FMT_BGRA64LE_get()),
        PIX_FMT_0RGB(VideoJNI.PixelFormat_PIX_FMT_0RGB_get()),
        PIX_FMT_RGB0(VideoJNI.PixelFormat_PIX_FMT_RGB0_get()),
        PIX_FMT_0BGR(VideoJNI.PixelFormat_PIX_FMT_0BGR_get()),
        PIX_FMT_BGR0(VideoJNI.PixelFormat_PIX_FMT_BGR0_get()),
        PIX_FMT_YUVA444P(VideoJNI.PixelFormat_PIX_FMT_YUVA444P_get()),
        PIX_FMT_YUVA422P(VideoJNI.PixelFormat_PIX_FMT_YUVA422P_get()),
        PIX_FMT_YUV420P12BE(VideoJNI.PixelFormat_PIX_FMT_YUV420P12BE_get()),
        PIX_FMT_YUV420P12LE(VideoJNI.PixelFormat_PIX_FMT_YUV420P12LE_get()),
        PIX_FMT_YUV420P14BE(VideoJNI.PixelFormat_PIX_FMT_YUV420P14BE_get()),
        PIX_FMT_YUV420P14LE(VideoJNI.PixelFormat_PIX_FMT_YUV420P14LE_get()),
        PIX_FMT_YUV422P12BE(VideoJNI.PixelFormat_PIX_FMT_YUV422P12BE_get()),
        PIX_FMT_YUV422P12LE(VideoJNI.PixelFormat_PIX_FMT_YUV422P12LE_get()),
        PIX_FMT_YUV422P14BE(VideoJNI.PixelFormat_PIX_FMT_YUV422P14BE_get()),
        PIX_FMT_YUV422P14LE(VideoJNI.PixelFormat_PIX_FMT_YUV422P14LE_get()),
        PIX_FMT_YUV444P12BE(VideoJNI.PixelFormat_PIX_FMT_YUV444P12BE_get()),
        PIX_FMT_YUV444P12LE(VideoJNI.PixelFormat_PIX_FMT_YUV444P12LE_get()),
        PIX_FMT_YUV444P14BE(VideoJNI.PixelFormat_PIX_FMT_YUV444P14BE_get()),
        PIX_FMT_YUV444P14LE(VideoJNI.PixelFormat_PIX_FMT_YUV444P14LE_get()),
        PIX_FMT_GBRP12BE(VideoJNI.PixelFormat_PIX_FMT_GBRP12BE_get()),
        PIX_FMT_GBRP12LE(VideoJNI.PixelFormat_PIX_FMT_GBRP12LE_get()),
        PIX_FMT_GBRP14BE(VideoJNI.PixelFormat_PIX_FMT_GBRP14BE_get()),
        PIX_FMT_GBRP14LE(VideoJNI.PixelFormat_PIX_FMT_GBRP14LE_get()),
        PIX_FMT_GBRAP(VideoJNI.PixelFormat_PIX_FMT_GBRAP_get()),
        PIX_FMT_GBRAP16BE(VideoJNI.PixelFormat_PIX_FMT_GBRAP16BE_get()),
        PIX_FMT_GBRAP16LE(VideoJNI.PixelFormat_PIX_FMT_GBRAP16LE_get()),
        PIX_FMT_YUVJ411P(VideoJNI.PixelFormat_PIX_FMT_YUVJ411P_get()),
        PIX_FMT_NB(VideoJNI.PixelFormat_PIX_FMT_NB_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

