/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.PixelComponentDescriptor;
import io.humble.video.PixelFormat;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class PixelFormatDescriptor
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected PixelFormatDescriptor(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.PixelFormatDescriptor_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected PixelFormatDescriptor(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.PixelFormatDescriptor_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(PixelFormatDescriptor obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public PixelFormatDescriptor copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new PixelFormatDescriptor(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof PixelFormatDescriptor) {
            equal = ((PixelFormatDescriptor)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String getName() {
        return VideoJNI.PixelFormatDescriptor_getName(this.swigCPtr, this);
    }

    public short getNumComponents() {
        return VideoJNI.PixelFormatDescriptor_getNumComponents(this.swigCPtr, this);
    }

    public short getLog2ChromaWidth() {
        return VideoJNI.PixelFormatDescriptor_getLog2ChromaWidth(this.swigCPtr, this);
    }

    public short getLog2ChromaHeight() {
        return VideoJNI.PixelFormatDescriptor_getLog2ChromaHeight(this.swigCPtr, this);
    }

    public short getFlags() {
        return VideoJNI.PixelFormatDescriptor_getFlags(this.swigCPtr, this);
    }

    public boolean getFlag(Flag flag) {
        return VideoJNI.PixelFormatDescriptor_getFlag(this.swigCPtr, this, flag.swigValue());
    }

    public int getBitsPerPixel() {
        return VideoJNI.PixelFormatDescriptor_getBitsPerPixel(this.swigCPtr, this);
    }

    public int getPaddedBitsPerPixel() {
        return VideoJNI.PixelFormatDescriptor_getPaddedBitsPerPixel(this.swigCPtr, this);
    }

    public PixelComponentDescriptor getComponentDescriptor(int component) {
        long cPtr = VideoJNI.PixelFormatDescriptor_getComponentDescriptor(this.swigCPtr, this, component);
        return cPtr == 0L ? null : new PixelComponentDescriptor(cPtr, false);
    }

    public PixelFormat.Type getFormat() {
        return PixelFormat.Type.swigToEnum(VideoJNI.PixelFormatDescriptor_getFormat(this.swigCPtr, this));
    }

    public static enum Flag {
        PIX_FMT_FLAG_BE(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_BE_get()),
        PIX_FMT_FLAG_PAL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PAL_get()),
        PIX_FMT_FLAG_BITSTREAM(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_BITSTREAM_get()),
        PIX_FMT_FLAG_HWACCEL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_HWACCEL_get()),
        PIX_FMT_FLAG_PLANAR(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PLANAR_get()),
        PIX_FMT_FLAG_RGB(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_RGB_get()),
        PIX_FMT_FLAG_PSEUDOPAL(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_PSEUDOPAL_get()),
        PIX_FMT_FLAG_ALPHA(VideoJNI.PixelFormatDescriptor_PIX_FMT_FLAG_ALPHA_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Flag swigToEnum(int swigValue) {
            Flag[] swigValues = (Flag[])Flag.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Flag swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Flag.class + " with value " + swigValue);
        }

        private Flag() {
            this.swigValue = SwigNext.next++;
        }

        private Flag(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Flag(Flag swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

