/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video;

import io.humble.ferry.Buffer;
import io.humble.ferry.RefCounted;
import io.humble.video.VideoJNI;
import java.util.concurrent.atomic.AtomicLong;

public class Rational
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        Buffer.make(null, 1);
    }

    protected Rational(long cPtr, boolean cMemoryOwn) {
        super(VideoJNI.Rational_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected Rational(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(VideoJNI.Rational_SWIGUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Rational obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    protected long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public Rational copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new Rational(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Rational) {
            equal = ((Rational)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        return "" + this.getNumerator() + "/" + this.getDenominator();
    }

    public boolean isPositive() {
        if (this.getDenominator() == 0) {
            return false;
        }
        return this.getDouble() > 0.0;
    }

    public static boolean positive(Rational num) {
        if (num == null) {
            return false;
        }
        return num.isPositive();
    }

    public boolean isNegative() {
        if (this.getDenominator() == 0) {
            return false;
        }
        return this.getDouble() < 0.0;
    }

    public static boolean negative(Rational num) {
        if (num == null) {
            return false;
        }
        return num.isNegative();
    }

    public int getNumerator() {
        return VideoJNI.Rational_getNumerator(this.swigCPtr, this);
    }

    public int getDenominator() {
        return VideoJNI.Rational_getDenominator(this.swigCPtr, this);
    }

    public Rational copy() {
        long cPtr = VideoJNI.Rational_copy(this.swigCPtr, this);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public int compareTo(Rational other) {
        return VideoJNI.Rational_compareTo(this.swigCPtr, this, Rational.getCPtr(other), other);
    }

    public static int sCompareTo(Rational a, Rational b) {
        return VideoJNI.Rational_sCompareTo(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
    }

    public double getDouble() {
        return VideoJNI.Rational_getDouble(this.swigCPtr, this);
    }

    public int reduce(long num, long den, long max) {
        return VideoJNI.Rational_reduce(this.swigCPtr, this, num, den, max);
    }

    public static int sReduce(Rational dst, long num, long den, long max) {
        return VideoJNI.Rational_sReduce(Rational.getCPtr(dst), dst, num, den, max);
    }

    public Rational multiply(Rational arg) {
        long cPtr = VideoJNI.Rational_multiply(this.swigCPtr, this, Rational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational sMultiply(Rational a, Rational b) {
        long cPtr = VideoJNI.Rational_sMultiply(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public Rational divide(Rational arg) {
        long cPtr = VideoJNI.Rational_divide(this.swigCPtr, this, Rational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational sDivide(Rational a, Rational b) {
        long cPtr = VideoJNI.Rational_sDivide(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public Rational subtract(Rational arg) {
        long cPtr = VideoJNI.Rational_subtract(this.swigCPtr, this, Rational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational sSubtract(Rational a, Rational b) {
        long cPtr = VideoJNI.Rational_sSubtract(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public Rational add(Rational arg) {
        long cPtr = VideoJNI.Rational_add(this.swigCPtr, this, Rational.getCPtr(arg), arg);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational sAdd(Rational a, Rational b) {
        long cPtr = VideoJNI.Rational_sAdd(Rational.getCPtr(a), a, Rational.getCPtr(b), b);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public long rescale(long origValue, Rational origBase) {
        return VideoJNI.Rational_rescale__SWIG_0(this.swigCPtr, this, origValue, Rational.getCPtr(origBase), origBase);
    }

    public static long sRescale(long origValue, Rational origBase, Rational newBase) {
        return VideoJNI.Rational_sRescale__SWIG_0(origValue, Rational.getCPtr(origBase), origBase, Rational.getCPtr(newBase), newBase);
    }

    public static Rational make() {
        long cPtr = VideoJNI.Rational_make__SWIG_0();
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational make(double d) {
        long cPtr = VideoJNI.Rational_make__SWIG_1(d);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational make(Rational src) {
        long cPtr = VideoJNI.Rational_make__SWIG_2(Rational.getCPtr(src), src);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public static Rational make(int num, int den) {
        long cPtr = VideoJNI.Rational_make__SWIG_3(num, den);
        return cPtr == 0L ? null : new Rational(cPtr, false);
    }

    public long rescale(long origValue, Rational origBase, Rounding rounding) {
        return VideoJNI.Rational_rescale__SWIG_1(this.swigCPtr, this, origValue, Rational.getCPtr(origBase), origBase, rounding.swigValue());
    }

    public static long sRescale(long origValue, Rational origBase, Rational newBase, Rounding rounding) {
        return VideoJNI.Rational_sRescale__SWIG_1(origValue, Rational.getCPtr(origBase), origBase, Rational.getCPtr(newBase), newBase, rounding.swigValue());
    }

    public static long rescale(long srcValue, int dstNumerator, int dstDenominator, int srcNumerator, int srcDenominator, Rounding rounding) {
        return VideoJNI.Rational_rescale__SWIG_2(srcValue, dstNumerator, dstDenominator, srcNumerator, srcDenominator, rounding.swigValue());
    }

    public void setNumerator(int value) {
        VideoJNI.Rational_setNumerator(this.swigCPtr, this, value);
    }

    public void setDenominator(int value) {
        VideoJNI.Rational_setDenominator(this.swigCPtr, this, value);
    }

    public void setValue(double value) {
        VideoJNI.Rational_setValue(this.swigCPtr, this, value);
    }

    public double getValue() {
        return VideoJNI.Rational_getValue(this.swigCPtr, this);
    }

    public boolean isFinalized() {
        return VideoJNI.Rational_isFinalized(this.swigCPtr, this);
    }

    public void init() {
        VideoJNI.Rational_init(this.swigCPtr, this);
    }

    public static enum Rounding {
        ROUND_ZERO(VideoJNI.Rational_ROUND_ZERO_get()),
        ROUND_INF(VideoJNI.Rational_ROUND_INF_get()),
        ROUND_DOWN(VideoJNI.Rational_ROUND_DOWN_get()),
        ROUND_UP(VideoJNI.Rational_ROUND_UP_get()),
        ROUND_NEAR_INF(VideoJNI.Rational_ROUND_NEAR_INF_get()),
        ROUND_PASS_MINMAX(VideoJNI.Rational_ROUND_PASS_MINMAX_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Rounding swigToEnum(int swigValue) {
            Rounding[] swigValues = (Rounding[])Rounding.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Rounding swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Rounding.class + " with value " + swigValue);
        }

        private Rounding() {
            this.swigValue = SwigNext.next++;
        }

        private Rounding(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Rounding(Rounding swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

