/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.awt;

import io.humble.ferry.Buffer;
import io.humble.ferry.JNIReference;
import io.humble.video.MediaPicture;
import io.humble.video.PixelFormat;
import io.humble.video.awt.AMediaPictureConverter;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicReference;

class BgrConverter
extends AMediaPictureConverter {
    private static final int[] mBandOffsets = new int[]{2, 1, 0};
    private static final ColorSpace mColorSpace = ColorSpace.getInstance(1000);
    private MediaPicture mResampleMediaPicture;

    public BgrConverter(PixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        super(pictureType, PixelFormat.Type.PIX_FMT_BGR24, 5, pictureWidth, pictureHeight, imageWidth, imageHeight);
        this.mResampleMediaPicture = this.willResample() ? MediaPicture.make(imageWidth, imageHeight, this.getRequiredPictureType()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaPicture toPicture(MediaPicture output, BufferedImage input, long timestamp) {
        this.validateImage(input);
        if (output == null) {
            output = MediaPicture.make(this.mPictureWidth, this.mPictureHeight, this.getPictureType());
        }
        DataBuffer imageBuffer = input.getRaster().getDataBuffer();
        byte[] imageBytes = null;
        int[] imageInts = null;
        if (imageBuffer instanceof DataBufferByte) {
            imageBytes = ((DataBufferByte)imageBuffer).getData();
        } else if (imageBuffer instanceof DataBufferInt) {
            imageInts = ((DataBufferInt)imageBuffer).getData();
        } else {
            throw new IllegalArgumentException("Unsupported BufferedImage data buffer type: " + imageBuffer.getDataType());
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        MediaPicture picture = this.willResample() ? this.mResampleMediaPicture : output;
        try {
            Buffer buffer = picture.getData(0);
            int size = picture.getDataPlaneSize(0);
            ByteBuffer pictureByteBuffer = buffer.getByteBuffer(0, size, ref);
            buffer.delete();
            buffer = null;
            if (imageInts != null) {
                pictureByteBuffer.order(ByteOrder.BIG_ENDIAN);
                IntBuffer pictureIntBuffer = pictureByteBuffer.asIntBuffer();
                pictureIntBuffer.put(imageInts);
            } else {
                pictureByteBuffer.put(imageBytes);
            }
            pictureByteBuffer = null;
            picture.setTimeStamp(timestamp);
            picture.setComplete(true);
            if (this.willResample()) {
                BgrConverter.resample(output, picture, this.mToPictureResampler);
            }
            MediaPicture mediaPicture = output;
            return mediaPicture;
        }
        finally {
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage toImage(BufferedImage output, MediaPicture input) {
        this.validatePicture(input);
        if (output == null) {
            byte[] bytes = new byte[this.willResample() ? this.mResampleMediaPicture.getDataPlaneSize(0) : input.getDataPlaneSize(0)];
            DataBufferByte db = new DataBufferByte(bytes, bytes.length);
            int w = this.mImageWidth;
            int h = this.mImageHeight;
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(db.getDataType(), w, h, 3, 3 * w, mBandOffsets);
            WritableRaster wr = Raster.createWritableRaster(sm, db, null);
            ComponentColorModel colorModel = new ComponentColorModel(mColorSpace, false, false, 1, db.getDataType());
            output = new BufferedImage(colorModel, wr, false, null);
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        try {
            MediaPicture picture = this.willResample() ? BgrConverter.resample(this.mResampleMediaPicture, input, this.mToImageResampler) : input;
            Buffer buffer = picture.getData(0);
            int size = picture.getDataPlaneSize(0);
            ByteBuffer byteBuf = buffer.getByteBuffer(0, size, ref);
            buffer.delete();
            DataBufferByte db = (DataBufferByte)output.getRaster().getDataBuffer();
            byte[] bytes = db.getData();
            byteBuf.get(bytes, 0, size);
            BufferedImage bufferedImage = output;
            return bufferedImage;
        }
        finally {
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
        }
    }

    @Override
    public void delete() {
        if (this.mResampleMediaPicture != null) {
            this.mResampleMediaPicture.delete();
        }
        this.mResampleMediaPicture = null;
        super.delete();
    }
}

