/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.customio;

import io.humble.video.customio.IURLProtocolHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputOutputStreamHandler
implements IURLProtocolHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final boolean CLOSE_STREAM_ON_CLOSE = true;
    private final InputStream mInputStream;
    private final OutputStream mOutputStream;
    private final boolean mCloseStreamOnClose;
    private Closeable mOpenStream = null;

    public InputOutputStreamHandler(InputStream stream) {
        this(stream, null, true);
    }

    public InputOutputStreamHandler(OutputStream stream) {
        this(null, stream, true);
    }

    public InputOutputStreamHandler(InputStream in, OutputStream out, boolean closeStreamOnClose) {
        if (in == null && out == null) {
            throw new IllegalArgumentException("must pass one non null stream");
        }
        this.mInputStream = in;
        this.mOutputStream = out;
        this.mCloseStreamOnClose = closeStreamOnClose;
    }

    @Override
    public int close() {
        int retval = 0;
        try {
            if (this.mOpenStream != null && this.mCloseStreamOnClose) {
                this.mOpenStream.close();
            }
        }
        catch (IOException e) {
            this.log.error("could not close stream {}: {}", (Object)this.mOpenStream, (Object)e);
            retval = -1;
        }
        this.mOpenStream = null;
        return retval;
    }

    @Override
    public int open(String url, int flags) {
        if (this.mOpenStream != null) {
            this.log.debug("attempting to open already open handler: {}", (Object)this.mOpenStream);
            return -1;
        }
        switch (flags) {
            case 2: {
                this.log.debug("do not support read/write mode for Java IO Handlers");
                return -1;
            }
            case 1: {
                this.mOpenStream = this.mOutputStream;
                if (this.mOpenStream != null) break;
                this.log.error("No OutputStream specified for writing: {}", (Object)url);
                return -1;
            }
            case 0: {
                this.mOpenStream = this.mInputStream;
                if (this.mOpenStream != null) break;
                this.log.error("No InputStream specified for reading: {}", (Object)url);
                return -1;
            }
            default: {
                this.log.error("Invalid flag passed to open: {}", (Object)url);
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int read(byte[] buf, int size) {
        int ret = -1;
        if (this.mOpenStream == null || !(this.mOpenStream instanceof InputStream)) {
            return -1;
        }
        try {
            InputStream stream = (InputStream)this.mOpenStream;
            ret = stream.read(buf, 0, size);
            return ret;
        }
        catch (IOException e) {
            this.log.error("Got IO exception reading from stream: {}; {}", (Object)this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public long seek(long offset, int whence) {
        return -1L;
    }

    @Override
    public int write(byte[] buf, int size) {
        if (this.mOpenStream == null || !(this.mOpenStream instanceof OutputStream)) {
            return -1;
        }
        try {
            OutputStream stream = (OutputStream)this.mOpenStream;
            stream.write(buf, 0, size);
            return size;
        }
        catch (IOException e) {
            this.log.error("Got error writing to file: {}; {}", (Object)this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public boolean isStreamed(String url, int flags) {
        return true;
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public Closeable getOpenStream() {
        return this.mOpenStream;
    }

    public boolean isCloseStreamOnClose() {
        return this.mCloseStreamOnClose;
    }
}

