/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.javaxsound;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioFrame {
    private static final Logger log = LoggerFactory.getLogger(AudioFrame.class);
    private SourceDataLine mLine;

    public static AudioFrame make() {
        AudioFormat audioFormat = new AudioFormat(22050.0f, 16, 2, true, false);
        return AudioFrame.make(audioFormat);
    }

    public static AudioFrame make(AudioFormat audioFormat) {
        try {
            return new AudioFrame(audioFormat);
        }
        catch (LineUnavailableException e) {
            log.error("Could not get audio data line: {}", (Object)e.getMessage());
            return null;
        }
    }

    public AudioFormat getFormat() {
        return this.mLine.getFormat();
    }

    private AudioFrame(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this.mLine = (SourceDataLine)AudioSystem.getLine(info);
        this.mLine.open(audioFormat);
        this.mLine.start();
    }

    public void play(ByteBuffer rawAudio) {
        byte[] data = rawAudio.array();
        this.mLine.write(data, rawAudio.position(), rawAudio.limit());
    }

    public void dispose() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }
}

