/*
 * Decompiled with CFR 0.152.
 */
package io.humble.video.javaxsound;

import io.humble.video.AudioChannel;
import io.humble.video.AudioFormat;
import io.humble.video.MediaAudio;
import io.humble.video.javaxsound.MediaAudioConverter;
import io.humble.video.javaxsound.StereoS16AudioConverter;

public class MediaAudioConverterFactory {
    public static final String DEFAULT_JAVA_AUDIO = "HUMBLE-STEREO-S16-22050";

    protected MediaAudioConverterFactory() {
    }

    public static MediaAudioConverter createConverter(String description, MediaAudio protoAudio) {
        return MediaAudioConverterFactory.createConverter(description, protoAudio.getSampleRate(), protoAudio.getChannelLayout(), protoAudio.getFormat());
    }

    public static MediaAudioConverter createConverter(String description, int sampleRate, AudioChannel.Layout layout, AudioFormat.Type format) {
        if (description != DEFAULT_JAVA_AUDIO) {
            throw new RuntimeException("Unsupported converter type");
        }
        return new StereoS16AudioConverter(sampleRate, layout, format);
    }
}

