/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.builders.IntConditionBase;
import io.hyperfoil.core.builders.IntConditionBuilder;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.io.Serializable;
import java.util.function.Supplier;

public class IntCondition
extends IntConditionBase
implements Condition {
    private final ReadAccess fromVar;
    private final boolean isSet;

    public IntCondition(ReadAccess fromVar, boolean isSet, Predicate predicate) {
        super(predicate);
        this.fromVar = fromVar;
        this.isSet = isSet;
    }

    public boolean test(Session session) {
        Session.Var var = this.fromVar.getVar(session);
        if (!var.isSet()) {
            return !this.isSet;
        }
        if (!this.isSet) {
            return false;
        }
        return this.testVar(session, var);
    }

    public static interface Predicate
    extends Serializable {
        public boolean test(Session var1, int var2);
    }

    public static class ProvidedVarBuilder<P>
    extends IntConditionBuilder<ProvidedVarBuilder<P>, P> {
        public ProvidedVarBuilder(P parent) {
            super(parent);
        }

        public IntCondition build(String var) {
            return new IntCondition(SessionFactory.readAccess(var), true, this.buildPredicate());
        }
    }

    public static class Builder<P>
    extends IntConditionBuilder<Builder<P>, P>
    implements Condition.Builder<Builder<P>>,
    InitFromParam<Builder<P>> {
        private Object fromVar;
        private boolean isSet = true;

        public Builder() {
            this(null);
        }

        public Builder(P parent) {
            super(parent);
        }

        public Builder<P> init(String param) {
            if (this.tryOp(param, "==", this::equalTo) || this.tryOp(param, "!=", this::notEqualTo) || this.tryOp(param, "<>", this::notEqualTo) || this.tryOp(param, ">=", this::greaterOrEqualTo) || this.tryOp(param, ">", this::greaterThan) || this.tryOp(param, "<=", this::lessOrEqualTo) || this.tryOp(param, "<", this::lessThan)) {
                return this;
            }
            throw new BenchmarkDefinitionException("Cannot parse intCondition: " + param);
        }

        private boolean tryOp(String param, String operator, Supplier<IntSourceBuilder<Builder<P>>> mutator) {
            String[] parts;
            if (param.contains(operator) && (parts = param.split(operator)).length == 2) {
                try {
                    int value = Integer.parseInt(parts[1].trim());
                    this.fromVar(parts[0].trim());
                    mutator.get().value(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    throw new BenchmarkDefinitionException("Cannot parse intCondition: " + param);
                }
            }
            return false;
        }

        public Builder<P> fromVar(Object var) {
            this.fromVar = var;
            return this;
        }

        public Builder<P> isSet(boolean isSet) {
            this.isSet = isSet;
            return this;
        }

        @Override
        public IntCondition buildCondition() {
            return new IntCondition(SessionFactory.readAccess(this.fromVar), this.isSet, this.buildPredicate());
        }
    }
}

