/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntCondition;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.function.SerializableToIntFunction;

public class IntConditionBuilder<B extends IntConditionBuilder<B, P>, P>
implements BuilderBase<B> {
    protected final P parent;
    protected IntSourceBuilder<B> equalTo;
    protected IntSourceBuilder<B> notEqualTo;
    protected IntSourceBuilder<B> greaterThan;
    protected IntSourceBuilder<B> greaterOrEqualTo;
    protected IntSourceBuilder<B> lessThan;
    protected IntSourceBuilder<B> lessOrEqualTo;

    protected static IntCondition.Predicate and(IntCondition.Predicate p1, IntCondition.Predicate p2) {
        return p1 == null ? p2 : (p2 == null ? null : new And(p1, p2));
    }

    public IntConditionBuilder(P parent) {
        this.parent = parent;
    }

    private B self() {
        return (B)this;
    }

    public IntSourceBuilder<B> equalTo() {
        this.equalTo = new IntSourceBuilder<B>(this.self());
        return this.equalTo;
    }

    public IntSourceBuilder<B> notEqualTo() {
        this.notEqualTo = new IntSourceBuilder<B>(this.self());
        return this.notEqualTo;
    }

    public IntSourceBuilder<B> greaterThan() {
        this.greaterThan = new IntSourceBuilder<B>(this.self());
        return this.greaterThan;
    }

    public IntSourceBuilder<B> greaterOrEqualTo() {
        this.greaterOrEqualTo = new IntSourceBuilder<B>(this.self());
        return this.greaterOrEqualTo;
    }

    public IntSourceBuilder<B> lessThan() {
        this.lessThan = new IntSourceBuilder<B>(this.self());
        return this.lessThan;
    }

    public IntSourceBuilder<B> lessOrEqualTo() {
        this.lessOrEqualTo = new IntSourceBuilder<B>(this.self());
        return this.lessOrEqualTo;
    }

    protected IntCondition.Predicate buildPredicate() {
        IntCondition.Predicate predicate = null;
        if (this.equalTo != null) {
            predicate = new EqualTo(this.equalTo.build());
        }
        if (this.notEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new NotEqualTo(this.notEqualTo.build()));
        }
        if (this.greaterThan != null) {
            predicate = IntConditionBuilder.and(predicate, new GreaterThan(this.greaterThan.build()));
        }
        if (this.greaterOrEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new GreaterOrEqualTo(this.greaterOrEqualTo.build()));
        }
        if (this.lessThan != null) {
            predicate = IntConditionBuilder.and(predicate, new LessThan(this.lessThan.build()));
        }
        if (this.lessOrEqualTo != null) {
            predicate = IntConditionBuilder.and(predicate, new LessOrEqualTo(this.lessOrEqualTo.build()));
        }
        return predicate;
    }

    public P end() {
        return this.parent;
    }

    private static class LessOrEqualTo
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        LessOrEqualTo(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v <= this.supplier.applyAsInt((Object)session);
        }
    }

    private static class LessThan
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        LessThan(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v < this.supplier.applyAsInt((Object)session);
        }
    }

    private static class GreaterOrEqualTo
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        GreaterOrEqualTo(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v >= this.supplier.applyAsInt((Object)session);
        }
    }

    private static class GreaterThan
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        GreaterThan(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v > this.supplier.applyAsInt((Object)session);
        }
    }

    private static class NotEqualTo
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        NotEqualTo(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v != this.supplier.applyAsInt((Object)session);
        }
    }

    private static class EqualTo
    implements IntCondition.Predicate {
        private final SerializableToIntFunction<Session> supplier;

        EqualTo(SerializableToIntFunction<Session> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean test(Session session, int v) {
            return v == this.supplier.applyAsInt((Object)session);
        }
    }

    private static class And
    implements IntCondition.Predicate {
        private final IntCondition.Predicate p1;
        private final IntCondition.Predicate p2;

        And(IntCondition.Predicate p1, IntCondition.Predicate p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public boolean test(Session session, int x) {
            return this.p1.test(session, x) && this.p2.test(session, x);
        }
    }
}

