/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.MappingListBuilder;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class IntSourceBuilder<P>
implements BuilderBase<IntSourceBuilder<P>>,
InitFromParam<IntSourceBuilder<P>> {
    private final P parent;
    private Integer value;
    private String fromVar;

    public IntSourceBuilder(P parent) {
        this.parent = parent;
    }

    public P end() {
        return this.parent;
    }

    public IntSourceBuilder<P> init(String param) {
        try {
            return this.value(Integer.parseInt(param));
        }
        catch (NumberFormatException e) {
            throw new BenchmarkDefinitionException("Cannot parse value '" + param + "' as an integer.");
        }
    }

    public IntSourceBuilder<P> value(int value) {
        this.value = value;
        return this;
    }

    public IntSourceBuilder<P> fromVar(String fromVar) {
        this.fromVar = fromVar;
        return this;
    }

    public SerializableToIntFunction<Session> build() {
        if (Stream.of(this.value, this.fromVar).filter(x$0 -> Objects.nonNull(x$0)).count() != 1L) {
            throw new BenchmarkDefinitionException("Must set either 'value' or 'fromVar'");
        }
        if (this.value != null) {
            return new ProvidedValue(this.value);
        }
        return new ValueFromVar(SessionFactory.readAccess(this.fromVar));
    }

    public static class ValueFromVar
    implements SerializableToIntFunction<Session> {
        private final ReadAccess fromVar;

        public ValueFromVar(ReadAccess fromVar) {
            this.fromVar = fromVar;
        }

        public int applyAsInt(Session session) {
            Session.Var var = this.fromVar.getVar(session);
            if (var.type() == Session.VarType.INTEGER) {
                return this.fromVar.getInt(session);
            }
            Object value = this.fromVar.getObject(session);
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            throw new IllegalStateException("Cannot implicitly convert " + value + " to integer.");
        }
    }

    public static class ProvidedValue
    implements SerializableToIntFunction<Session> {
        private final int value;

        public ProvidedValue(int value) {
            this.value = value;
        }

        public int applyAsInt(Session session) {
            return this.value;
        }
    }

    public static class ListBuilder
    implements MappingListBuilder<IntSourceBuilder<Void>>,
    BuilderBase<IntSourceBuilder<Void>> {
        private final List<IntSourceBuilder<Void>> list = new ArrayList<IntSourceBuilder<Void>>();

        public IntSourceBuilder<Void> addItem() {
            IntSourceBuilder<Object> item = new IntSourceBuilder<Object>(null);
            this.list.add(item);
            return item;
        }

        public SerializableToIntFunction<Session>[] build() {
            return (SerializableToIntFunction[])this.list.stream().map(IntSourceBuilder::build).toArray(SerializableToIntFunction[]::new);
        }
    }
}

