/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.IncludeBuilders;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.core.builders.BuilderInfo;
import io.hyperfoil.core.builders.ServiceLoadedContract;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceLoadedBuilderProvider<B> {
    private static final Logger log = LogManager.getLogger(ServiceLoadedBuilderProvider.class);
    private static final Map<Class<?>, Map<String, BuilderInfo<?>>> BUILDERS = new HashMap();
    private final Class<B> builderClazz;
    private final Consumer<B> consumer;
    private final BaseSequenceBuilder<?> parent;

    public static synchronized Map<String, BuilderInfo<?>> builders(Class<?> clazz) {
        return BUILDERS.computeIfAbsent(clazz, ServiceLoadedBuilderProvider::scanBuilders);
    }

    private static Map<String, BuilderInfo<?>> scanBuilders(Class<?> clazz) {
        HashMap builders = new HashMap();
        HashSet included = new HashSet();
        ArrayDeque<BuilderInfo<Object>> deque = new ArrayDeque<BuilderInfo<Object>>();
        deque.add(new BuilderInfo(clazz, Function.identity()));
        included.add(clazz);
        while (!deque.isEmpty()) {
            BuilderInfo builderInfo = (BuilderInfo)deque.poll();
            ServiceLoader.load(builderInfo.implClazz).stream().forEach(provider -> {
                Name name = provider.type().getAnnotation(Name.class);
                if (name == null || name.value().isEmpty()) {
                    log.error("Service-loaded class {} is missing @Name annotation!", provider.type());
                } else {
                    builders.putIfAbsent(name.value(), new BuilderInfo(provider.type(), builderInfo.adapter));
                }
            });
            IncludeBuilders include = builderInfo.implClazz.getAnnotation(IncludeBuilders.class);
            if (include == null) continue;
            for (IncludeBuilders.Conversion conversion : include.value()) {
                if (included.contains(conversion.from())) continue;
                try {
                    Function adapter = (Function)conversion.adapter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    deque.add(new BuilderInfo<Object>(conversion.from(), builder -> builderInfo.adapter.apply(adapter.apply(builder))));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot instantiate " + conversion.adapter());
                }
            }
        }
        return builders;
    }

    public ServiceLoadedBuilderProvider(Class<B> builderClazz, Consumer<B> consumer) {
        this(builderClazz, consumer, null);
    }

    public ServiceLoadedBuilderProvider(Class<B> builderClazz, Consumer<B> consumer, BaseSequenceBuilder<?> parent) {
        this.builderClazz = builderClazz;
        this.consumer = consumer;
        this.parent = parent;
    }

    public ServiceLoadedContract forName(String name, String param) {
        BuilderInfo<B> builderInfo = ServiceLoadedBuilderProvider.builders(this.builderClazz).get(name);
        if (builderInfo == null) {
            throw new BenchmarkDefinitionException(String.format("No builder implementing %s with @Name %s", this.builderClazz, name));
        }
        try {
            Object instance = this.newInstance(builderInfo);
            if (param != null && !param.isEmpty()) {
                if (instance instanceof InitFromParam) {
                    ((InitFromParam)instance).init(param);
                } else {
                    throw new BenchmarkDefinitionException(name + "(" + builderInfo.implClazz + ") cannot be initialized from an inline parameter");
                }
            }
            return new ServiceLoadedContract(instance, () -> this.consumer.accept(builderInfo.adapter.apply(instance)));
        }
        catch (Exception e) {
            throw new BenchmarkDefinitionException("Failed to instantiate " + builderInfo.implClazz, (Throwable)e);
        }
    }

    private Object newInstance(BuilderInfo<B> builderInfo) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor parentCtor;
        if (this.parent != null && (parentCtor = (Constructor)Stream.of(builderInfo.implClazz.getDeclaredConstructors()).filter(ctor -> ctor.getParameterCount() == 1 && ctor.getParameterTypes()[0] == BaseSequenceBuilder.class).findFirst().orElse(null)) != null) {
            return parentCtor.newInstance(this.parent);
        }
        Constructor noArgCtor = Stream.of(builderInfo.implClazz.getDeclaredConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst().orElse(null);
        if (noArgCtor == null) {
            throw new BenchmarkDefinitionException("Class " + builderInfo.implClazz.getName() + " does not have a parameterless constructor.");
        }
        return noArgCtor.newInstance(new Object[0]);
    }

    public static interface Owner<B> {
        public ServiceLoadedBuilderProvider<B> serviceLoaded();
    }
}

