/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.core.builders.StringConditionBase;
import io.hyperfoil.core.builders.StringConditionBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringCondition
extends StringConditionBase
implements Condition {
    private static final Logger log = LogManager.getLogger(StringCondition.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ReadAccess fromVar;
    private final boolean isSet;

    public StringCondition(ReadAccess fromVar, boolean isSet, SerializableBiPredicate<Session, CharSequence> predicate) {
        super(predicate);
        this.fromVar = fromVar;
        this.isSet = isSet;
    }

    public boolean test(Session session) {
        Session.Var var = this.fromVar.getVar(session);
        if (!var.isSet()) {
            if (trace) {
                log.trace("#{} Variable {} is not set, condition result: {}", (Object)session.uniqueId(), (Object)this.fromVar, (Object)(!this.isSet ? 1 : 0));
            }
            return !this.isSet;
        }
        if (!this.isSet) {
            if (trace) {
                log.trace("#{} Variable {} is set, condition result: false", (Object)session.uniqueId(), (Object)this.fromVar);
            }
            return false;
        }
        return this.testVar(session, var);
    }

    public static class Builder<P>
    extends StringConditionBuilder<Builder<P>, P>
    implements Condition.Builder<Builder<P>> {
        private Object fromVar;
        private boolean isSet = true;

        public Builder(P parent) {
            super(parent);
        }

        public Builder<P> fromVar(Object var) {
            this.fromVar = var;
            return this;
        }

        public Builder<P> isSet(boolean isSet) {
            this.isSet = isSet;
            return this;
        }

        @Override
        public StringCondition buildCondition() {
            return new StringCondition(SessionFactory.readAccess(this.fromVar), this.isSet, this.isSet ? this.buildPredicate() : null);
        }
    }
}

