/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntCondition;
import io.hyperfoil.core.builders.IntConditionBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiPredicate;
import io.hyperfoil.impl.Util;
import java.io.Serializable;

public class StringConditionBuilder<B extends StringConditionBuilder<B, P>, P>
implements InitFromParam<StringConditionBuilder<B, P>>,
BuilderBase<B> {
    private final P parent;
    private CharSequence value;
    private boolean caseSensitive = true;
    private String matchVar;
    private CompareMode compareMode;
    private boolean negate;
    private LengthBuilder<B, P> length;

    public StringConditionBuilder(P parent) {
        this.parent = parent;
    }

    public SerializableBiPredicate<Session, CharSequence> buildPredicate() {
        if (this.value == null && this.matchVar == null && this.length == null) {
            throw new BenchmarkDefinitionException("Must set one of: 'value', 'startsWith', 'endsWith', 'matchVar' or 'length'!");
        }
        SerializableBiPredicate & Serializable predicate = this.contentPredicate();
        if (this.length != null) {
            IntCondition.Predicate lengthPredicate = this.length.buildPredicate();
            SerializableBiPredicate & Serializable strLengthPredicate = (SerializableBiPredicate & Serializable)(session, string) -> lengthPredicate.test((Session)session, string == null ? 0 : string.length());
            if (predicate == null) {
                predicate = strLengthPredicate;
            } else {
                SerializableBiPredicate & Serializable myPredicate = predicate;
                predicate = (SerializableBiPredicate & Serializable)(session, string) -> strLengthPredicate.test(session, string) && myPredicate.test(session, string);
            }
        }
        if (predicate == null) {
            throw new BenchmarkDefinitionException("No condition set in string condition.");
        }
        return this.negate ? predicate.negate() : predicate;
    }

    private SerializableBiPredicate<Session, CharSequence> contentPredicate() {
        CompareMode myCompareMode = this.compareMode;
        boolean myCaseSensitive = this.caseSensitive;
        if (this.value != null) {
            CharSequence myValue = this.value;
            return (SerializableBiPredicate & Serializable)(s, string) -> {
                int offset = 0;
                int valueLength = myValue.length();
                switch (myCompareMode) {
                    case FULL: {
                        valueLength = Math.max(string.length(), valueLength);
                        break;
                    }
                    case PREFIX: {
                        break;
                    }
                    case SUFFIX: {
                        offset = string.length() - valueLength;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + myCompareMode);
                    }
                }
                return myCaseSensitive ? Util.regionMatches((CharSequence)myValue, (int)0, (CharSequence)string, (int)offset, (int)valueLength) : Util.regionMatchesIgnoreCase((CharSequence)myValue, (int)0, (CharSequence)string, (int)offset, (int)valueLength);
            };
        }
        if (this.matchVar != null) {
            ReadAccess access = SessionFactory.readAccess(this.matchVar);
            return (SerializableBiPredicate & Serializable)(s, string) -> {
                Object value = access.getObject(s);
                if (value instanceof CharSequence) {
                    CharSequence v = (CharSequence)value;
                    return myCaseSensitive ? Util.regionMatches((CharSequence)v, (int)0, (CharSequence)string, (int)0, (int)Math.max(v.length(), string.length())) : Util.regionMatchesIgnoreCase((CharSequence)v, (int)0, (CharSequence)string, (int)0, (int)Math.max(v.length(), string.length()));
                }
                return false;
            };
        }
        return null;
    }

    public StringConditionBuilder<B, P> init(String param) {
        return this.value(param);
    }

    public B self() {
        return (B)this;
    }

    public B caseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this.self();
    }

    private void ensureNotSet() {
        if (this.value != null || this.matchVar != null) {
            throw new BenchmarkDefinitionException("Must set only one of: 'value'/'equalTo', 'notEqualTo', 'startsWith', 'endsWith' or 'matchVar'!");
        }
    }

    public B value(CharSequence value) {
        this.ensureNotSet();
        this.value = value;
        this.compareMode = CompareMode.FULL;
        return this.self();
    }

    public B equalTo(CharSequence value) {
        return this.value(value);
    }

    public B notEqualTo(CharSequence value) {
        this.negate = true;
        return this.value(value);
    }

    public B startsWith(CharSequence value) {
        this.ensureNotSet();
        this.value = value;
        this.compareMode = CompareMode.PREFIX;
        return this.self();
    }

    public B endsWith(CharSequence value) {
        this.ensureNotSet();
        this.value = value;
        this.compareMode = CompareMode.SUFFIX;
        return this.self();
    }

    public B matchVar(String var) {
        this.ensureNotSet();
        this.matchVar = var;
        return this.self();
    }

    public B negate(boolean negate) {
        this.negate = negate;
        return this.self();
    }

    public B length(int exactLength) {
        if (this.length == null) {
            this.length = new LengthBuilder(this);
        }
        this.length.equalTo().value(exactLength);
        return this.self();
    }

    public LengthBuilder<B, P> length() {
        if (this.length == null) {
            this.length = new LengthBuilder(this);
        }
        return this.length;
    }

    public P end() {
        return this.parent;
    }

    public static enum CompareMode {
        FULL,
        PREFIX,
        SUFFIX;

    }

    public static class LengthBuilder<B extends StringConditionBuilder<B, P>, P>
    extends IntConditionBuilder<LengthBuilder<B, P>, StringConditionBuilder<B, P>> {
        public LengthBuilder(StringConditionBuilder<B, P> parent) {
            super(parent);
        }
    }
}

