/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.ObjectVar;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Queue
implements Session.Resource {
    private static final Logger log = LogManager.getLogger(Queue.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ObjectAccess var;
    private final Object[] data;
    private final int concurrency;
    private final String sequence;
    private final Action onCompletion;
    private int head;
    private int tail;
    private int active;
    private int size;
    private boolean producerComplete;

    public Queue(ObjectAccess var, int size, int concurrency, String sequence, Action onCompletion) {
        if (var.isSequenceScoped()) {
            throw new BenchmarkDefinitionException("Queue variable should not be sequence-scoped for queue; use sequence-scoped access only for reading.");
        }
        this.var = var;
        this.data = new Object[size];
        this.concurrency = concurrency;
        this.sequence = sequence;
        this.onCompletion = onCompletion;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public void onSessionReset(Session session) {
        this.reset(session);
    }

    public void reset(Session session) {
        this.active = 0;
        this.head = 0;
        this.tail = 0;
        this.size = 0;
        this.producerComplete = false;
        Arrays.fill(this.data, null);
        this.var.activate(session);
    }

    public void push(Session session, Object value) {
        log.trace("#{} adding {} to queue -> {}", (Object)session.uniqueId(), value, (Object)this.var);
        Objects.requireNonNull(value);
        if (this.size < this.data.length) {
            this.data[this.tail++] = value;
            if (this.tail >= this.data.length) {
                this.tail = 0;
            }
            ++this.size;
        } else {
            log.error("#{} Exceeded maximum size of queue {} ({}), dropping value {}", (Object)session.uniqueId(), (Object)this.var, (Object)this.data.length, value);
        }
        if (this.active < this.concurrency && this.size > 0) {
            ++this.active;
            --this.size;
            Object queuedValue = this.data[this.head];
            this.data[this.head++] = null;
            if (this.head >= this.data.length) {
                this.head = 0;
            }
            SequenceInstance instance = session.startSequence(this.sequence, false, Session.ConcurrencyPolicy.FAIL);
            if (trace) {
                log.trace("#{} starting {} with queued value {} in {}[{}]", (Object)session.uniqueId(), (Object)this.sequence, queuedValue, (Object)this.var, (Object)instance.index());
            }
            ObjectVar[] output = (ObjectVar[])this.var.getObject(session);
            output[instance.index()].set(queuedValue);
        }
    }

    public void producerComplete(Session session) {
        log.trace("#{} producer of {} is complete", (Object)session.uniqueId(), (Object)this.var);
        this.producerComplete = true;
        if (this.active == 0) {
            this.complete(session);
        }
    }

    public void consumed(Session session) {
        SequenceInstance instance = session.currentSequence();
        if (trace) {
            log.trace("#{} consumed {}[{}], head={}, tail={}", (Object)session.uniqueId(), (Object)this.var, (Object)instance.index(), (Object)this.head, (Object)this.tail);
        }
        if (this.head < this.tail) {
            Object queuedValue = this.data[this.head];
            this.data[this.head++] = null;
            assert (instance.definition().name().equals(this.sequence));
            ObjectVar[] output = (ObjectVar[])this.var.getObject(session);
            output[instance.index()].set(queuedValue);
            if (trace) {
                log.trace("#{} restarting sequence {}[{}] with {} -> {}", (Object)this.sequence, (Object)instance.index(), queuedValue, (Object)this.var);
            }
            instance.restart(session);
        } else {
            --this.active;
            if (this.producerComplete && this.active == 0) {
                this.complete(session);
            }
        }
    }

    private void complete(Session session) {
        assert (this.head == this.tail);
        log.trace("#{} queue {} completed", (Object)session.uniqueId(), (Object)this.var);
        this.reset(session);
        if (this.onCompletion != null) {
            this.onCompletion.run(session);
        }
    }

    public static class Key
    implements Session.ResourceKey<Queue> {
    }
}

