/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;

public class Pattern
implements SerializableFunction<Session, String>,
SerializableBiConsumer<Session, ByteBuf>,
Transformer {
    private static final int VAR_LENGTH_ESTIMATE = 32;
    private static final String REPLACE = "replace";
    private final Component[] components;
    @Visitor.Ignore
    private int lengthEstimate;
    private final boolean urlEncode;

    public Pattern(String str, boolean urlEncode) {
        this(str, urlEncode, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern(String str, boolean urlEncode, boolean allowUnset) {
        this.urlEncode = urlEncode;
        ArrayList<Component> components = new ArrayList<Component>();
        int last = 0;
        int lastSearch = 0;
        while (true) {
            String substring;
            int openPar;
            if ((openPar = str.indexOf("${", lastSearch)) < 0) {
                substring = str.substring(last);
                if (str.isEmpty()) break;
                components.add(new StringComponent(substring.replaceAll("\\$\\$\\{", "\\${")));
                this.lengthEstimate += substring.length();
                break;
            }
            if (openPar > 0 && str.charAt(openPar - 1) == '$') {
                lastSearch = openPar + 1;
                continue;
            }
            substring = str.substring(last, openPar);
            components.add(new StringComponent(substring.replaceAll("\\$\\$\\{", "\\${")));
            this.lengthEstimate += substring.length() + 32;
            int closePar = str.indexOf("}", openPar);
            int colon = str.indexOf(":", openPar);
            if (colon >= 0 && colon < closePar) {
                String format = str.substring(openPar + 2, colon).trim();
                ReadAccess key = SessionFactory.readAccess(str.substring(colon + 1, closePar).trim());
                if (format.equalsIgnoreCase("urlencode")) {
                    if (urlEncode) {
                        throw new BenchmarkDefinitionException("It seems you're trying to URL-encode value twice.");
                    }
                    components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)((SerializableFunction & Serializable)Pattern::urlEncode)));
                } else if (format.equalsIgnoreCase("base64encode")) {
                    components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)(SerializableFunction & Serializable)s -> Base64.getEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8))));
                } else if (format.equalsIgnoreCase("base64decode")) {
                    components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)(SerializableFunction & Serializable)s -> new String(Base64.getDecoder().decode((String)s), StandardCharsets.UTF_8)));
                } else if (format.startsWith(REPLACE)) {
                    if (format.length() == REPLACE.length()) {
                        throw new BenchmarkDefinitionException(this.wrongReplaceSyntax(str, format));
                    }
                    char separator = format.charAt(REPLACE.length());
                    int regexpEnd = format.indexOf(separator, REPLACE.length() + 1);
                    int replacementEnd = format.indexOf(separator, regexpEnd + 1);
                    if (regexpEnd < 0 || replacementEnd < 0) {
                        throw new BenchmarkDefinitionException(this.wrongReplaceSyntax(str, format));
                    }
                    java.util.regex.Pattern regex = java.util.regex.Pattern.compile(format.substring(REPLACE.length() + 1, regexpEnd));
                    String replacement = format.substring(regexpEnd + 1, replacementEnd);
                    boolean all = false;
                    if (format.length() > replacementEnd + 1) {
                        String flags = format.substring(replacementEnd + 1);
                        if (!"g".equals(flags)) throw new BenchmarkDefinitionException("Unknown flags '" + flags + "' in replace expression in '" + str + "'");
                        all = true;
                    }
                    if (all) {
                        components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)(SerializableFunction & Serializable)value -> regex.matcher((CharSequence)value).replaceAll(replacement)));
                    } else {
                        components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)(SerializableFunction & Serializable)value -> regex.matcher((CharSequence)value).replaceFirst(replacement)));
                    }
                } else {
                    if (!format.endsWith("d") && !format.endsWith("o") && !format.endsWith("x") && !format.endsWith("X")) throw new IllegalArgumentException("Cannot use format string '" + format + "', only integers are supported");
                    components.add(new FormatIntComponent(format, key));
                }
            } else {
                if (closePar < 0) {
                    throw new BenchmarkDefinitionException("Missing closing parentheses (}) in '" + str + "'");
                }
                ReadAccess key = SessionFactory.readAccess(str.substring(openPar + 2, closePar).trim());
                components.add(new VarComponent(key, allowUnset, (SerializableFunction<String, String>)(urlEncode ? Pattern::urlEncode : null)));
            }
            lastSearch = last = closePar + 1;
        }
        this.components = components.toArray(new Component[0]);
    }

    private String wrongReplaceSyntax(String pattern, String expression) {
        return "Wrong replace syntax: use ${replace/regexp/replacement/flags:my-variable} where '/' can be any character. The offending replace expression was '" + expression + "' in '" + pattern + "'.";
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String apply(Session session) {
        if (this.components.length == 1 && this.components[0] instanceof StringComponent) {
            return ((StringComponent)this.components[0]).substring;
        }
        StringBuilder sb = new StringBuilder(this.lengthEstimate);
        for (Component c : this.components) {
            c.accept(session, sb);
        }
        return sb.toString();
    }

    public void accept(Session session, ByteBuf byteBuf) {
        for (Component c : this.components) {
            c.accept(session, byteBuf);
        }
    }

    public void transform(Session session, ByteBuf in, int offset, int length, boolean lastFragment, ByteBuf out) {
        if (lastFragment) {
            this.accept(session, out);
        }
    }

    public Generator generator() {
        return new Generator(this);
    }

    @Name(value="pattern")
    public static class TransformerBuilder
    implements Transformer.Builder,
    InitFromParam<TransformerBuilder> {
        public String pattern;

        public TransformerBuilder init(String param) {
            return this.pattern(param);
        }

        public TransformerBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Pattern build(boolean fragmented) {
            return new Pattern(this.pattern, false);
        }
    }

    private static class VarComponent
    implements Component {
        private final ReadAccess key;
        private final boolean allowUnset;
        private final SerializableFunction<String, String> transform;

        VarComponent(ReadAccess key, boolean allowUnset, SerializableFunction<String, String> transform) {
            this.key = key;
            this.allowUnset = allowUnset;
            this.transform = transform;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void accept(Session session, StringBuilder sb) {
            Session.Var var = this.key.getVar(session);
            if (!var.isSet()) {
                if (!this.allowUnset) throw new IllegalArgumentException("Variable " + this.key + " is not set!");
                sb.append("<not set>");
                return;
            } else {
                switch (var.type()) {
                    case OBJECT: {
                        String str = Util.prettyPrintObject((Object)var.objectValue(session));
                        if (this.transform != null) {
                            str = (String)this.transform.apply((Object)str);
                        }
                        sb.append(str);
                        return;
                    }
                    case INTEGER: {
                        sb.append(var.intValue(session));
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown var type: " + var);
                    }
                }
            }
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            Session.Var var = this.key.getVar(session);
            if (!var.isSet()) {
                throw new IllegalArgumentException("Variable " + this.key + " is not set!");
            }
            switch (var.type()) {
                case OBJECT: {
                    Object o = var.objectValue(session);
                    if (o != null) {
                        CharSequence str;
                        CharSequence charSequence = str = o instanceof CharSequence ? (CharSequence)o : Util.prettyPrintObject((Object)o);
                        if (this.transform != null) {
                            str = (CharSequence)this.transform.apply((Object)str.toString());
                        }
                        Util.string2byteBuf((CharSequence)str, (ByteBuf)buf);
                        break;
                    }
                    Util.string2byteBuf((CharSequence)"null", (ByteBuf)buf);
                    break;
                }
                case INTEGER: {
                    Util.intAsText2byteBuf((int)var.intValue(session), (ByteBuf)buf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown var type: " + var);
                }
            }
        }
    }

    private class FormatIntComponent
    implements Component {
        private final String format;
        private final ReadAccess key;

        FormatIntComponent(String format, ReadAccess key) {
            this.format = format;
            this.key = key;
        }

        private String string(Session session) {
            return String.format(this.format, this.key.getInt(session));
        }

        @Override
        public void accept(Session s, StringBuilder sb) {
            String str = this.string(s);
            sb.append(Pattern.this.urlEncode ? Pattern.urlEncode(str) : str);
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            String str = this.string(session);
            if (Pattern.this.urlEncode) {
                Util.urlEncode((String)str, (ByteBuf)buf);
            } else {
                Util.string2byteBuf((CharSequence)str, (ByteBuf)buf);
            }
        }
    }

    private class StringComponent
    implements Component {
        private final String substring;
        @Visitor.Ignore
        private final byte[] bytes;

        StringComponent(String substring) {
            if (Pattern.this.urlEncode) {
                substring = Pattern.urlEncode(substring);
            }
            this.substring = substring;
            this.bytes = substring.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void accept(Session s, StringBuilder sb) {
            sb.append(this.substring);
        }

        @Override
        public void accept(Session session, ByteBuf buf) {
            buf.writeBytes(this.bytes);
        }
    }

    private static class Generator
    implements SerializableBiFunction<Session, Connection, ByteBuf> {
        private final Pattern pattern;

        private Generator(Pattern pattern) {
            this.pattern = pattern;
        }

        public ByteBuf apply(Session session, Connection connection) {
            ByteBuf buffer = connection.context().alloc().buffer(this.pattern.lengthEstimate);
            this.pattern.accept(session, buffer);
            return buffer;
        }
    }

    static interface Component
    extends Serializable {
        public void accept(Session var1, StringBuilder var2);

        public void accept(Session var1, ByteBuf var2);
    }
}

