/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.IntValueProviderBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RandomIntStep
implements Step {
    private final IntAccess toVar;
    private final SerializableToIntFunction<Session> minInclusive;
    private final SerializableToIntFunction<Session> maxInclusive;

    public RandomIntStep(IntAccess toVar, SerializableToIntFunction<Session> minInclusive, SerializableToIntFunction<Session> maxInclusive) {
        this.toVar = toVar;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public boolean invoke(Session session) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int minInclusive = this.minInclusive.applyAsInt((Object)session);
        int maxInclusive = this.maxInclusive.applyAsInt((Object)session);
        int r = maxInclusive == Integer.MAX_VALUE ? (minInclusive == Integer.MIN_VALUE ? random.nextInt() : random.nextInt(minInclusive - 1, maxInclusive) + 1) : random.nextInt(minInclusive, maxInclusive + 1);
        this.toVar.setInt(session, r);
        return true;
    }

    @Name(value="randomInt")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private String toVar;
        private IntValueProviderBuilder<Builder> min = new IntValueProviderBuilder<Builder>(this, 0);
        private IntValueProviderBuilder<Builder> max = new IntValueProviderBuilder<Builder>(this, Integer.MAX_VALUE);

        public Builder init(String rangeToVar) {
            if (rangeToVar == null) {
                return this;
            }
            int arrowIndex = rangeToVar.indexOf("<-");
            int dotdotIndex = rangeToVar.indexOf("..");
            if (arrowIndex < 0 || dotdotIndex < arrowIndex) {
                throw new BenchmarkDefinitionException("Expecting format var <- min .. max");
            }
            this.toVar = rangeToVar.substring(0, arrowIndex).trim();
            this.min.value(Integer.parseInt(rangeToVar.substring(arrowIndex + 2, dotdotIndex).trim()));
            this.max.value(Integer.parseInt(rangeToVar.substring(dotdotIndex + 2).trim()));
            return this;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public IntValueProviderBuilder<Builder> min() {
            return this.min;
        }

        public IntValueProviderBuilder<Builder> max() {
            return this.max;
        }

        public List<Step> build() {
            if (this.toVar == null || this.toVar.isEmpty()) {
                throw new BenchmarkDefinitionException("Missing target var.");
            }
            if (this.min.compareTo(this.max) > 0) {
                throw new BenchmarkDefinitionException("min must be less than max");
            }
            return Collections.singletonList(new RandomIntStep(SessionFactory.intAccess(this.toVar), this.min.build(), this.max.build()));
        }
    }
}

