/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.WeightedGenerator;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

public class RandomItemStep
implements Step {
    private final ReadAccess fromVar;
    private final WeightedGenerator generator;
    private final ObjectAccess toVar;

    public RandomItemStep(ReadAccess fromVar, WeightedGenerator generator, ObjectAccess toVar) {
        this.fromVar = fromVar;
        this.generator = generator;
        this.toVar = toVar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke(Session session) {
        Object item;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (this.generator != null) {
            assert (this.fromVar == null);
            item = this.generator.randomItem();
        } else {
            Object data = this.fromVar.getObject(session);
            if (data instanceof ObjectVar[]) {
                ObjectVar[] array = (ObjectVar[])data;
                int length = array.length;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i].isSet()) continue;
                    length = i;
                    break;
                }
                if (length <= 0) throw new IllegalStateException("Collection " + this.fromVar + " is empty, can not select a random item");
                item = array[random.nextInt(length)].objectValue(session);
            } else if (data != null && data.getClass().isArray()) {
                int length = Array.getLength(data);
                item = Array.get(data, random.nextInt(length));
            } else if (data instanceof List) {
                List dataList = (List)data;
                item = dataList.get(random.nextInt(dataList.size()));
            } else {
                if (!(data instanceof Collection)) throw new IllegalStateException("Cannot fetch random item from collection stored under " + this.fromVar + ": " + data);
                Collection dataCollection = (Collection)data;
                Iterator iterator = dataCollection.iterator();
                for (int i = random.nextInt(dataCollection.size()) - 1; i > 0; --i) {
                    iterator.next();
                }
                item = iterator.next();
            }
        }
        this.toVar.setObject(session, item);
        return true;
    }

    @Name(value="randomItem")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private String fromVar;
        private WeightedGenerator.Builder<Builder> weighted;
        private String file;
        private String toVar;

        public Builder init(String toFrom) {
            if (toFrom == null) {
                return this;
            }
            String[] parts = toFrom.split("<-");
            if (parts.length != 2) {
                throw new BenchmarkDefinitionException("Expecting format toVar <- fromVar");
            }
            this.toVar = parts[0].trim();
            this.fromVar = parts[1].trim();
            return this;
        }

        public List<Step> build() {
            WeightedGenerator generator;
            if (this.toVar == null || this.toVar.isEmpty()) {
                throw new BenchmarkDefinitionException("toVar is empty");
            }
            long usedProperties = Stream.of(new Object[]{this.file, this.weighted, this.fromVar}).filter(Objects::nonNull).count();
            if (usedProperties > 1L) {
                throw new BenchmarkDefinitionException("randomItem cannot combine `fromVar` and `list` or `file`");
            }
            if (usedProperties == 0L) {
                throw new BenchmarkDefinitionException("randomItem must define one of: `fromVar`, `list` or `file`");
            }
            if (this.weighted != null) {
                generator = this.weighted.build();
            } else if (this.file != null) {
                ArrayList<String> list = new ArrayList<String>();
                try (InputStream inputStream = Locator.current().benchmark().data().readFile(this.file);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        list.add(line);
                    }
                }
                catch (IOException e) {
                    throw new BenchmarkDefinitionException("Cannot load file `" + this.file + "` for randomItem.", (Throwable)e);
                }
                generator = new WeightedGenerator(null, list.toArray(new String[0]));
            } else {
                if (this.fromVar.isEmpty()) {
                    throw new BenchmarkDefinitionException("fromVar is empty");
                }
                generator = null;
            }
            return Collections.singletonList(new RandomItemStep(SessionFactory.readAccess(this.fromVar), generator, SessionFactory.objectAccess(this.toVar)));
        }

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public WeightedGenerator.Builder<Builder> list() {
            if (this.weighted == null) {
                this.weighted = new WeightedGenerator.Builder<Builder>(this);
            }
            return this.weighted;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }
    }
}

