/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.PairBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class WeightedGenerator
implements Serializable {
    private final double[] cummulativeProbs;
    private final String[] items;

    public WeightedGenerator(double[] cummulativeProbs, String[] items) {
        this.cummulativeProbs = cummulativeProbs;
        this.items = items;
    }

    public int randomIndex() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (this.cummulativeProbs != null) {
            assert (this.cummulativeProbs.length == this.items.length - 1);
            int index = Arrays.binarySearch(this.cummulativeProbs, random.nextDouble());
            if (index < 0) {
                return -index - 1;
            }
            return index;
        }
        return random.nextInt(this.items.length);
    }

    public String randomItem() {
        return this.items[this.randomIndex()];
    }

    public String[] items() {
        return this.items;
    }

    public static class Builder<P>
    extends PairBuilder.OfDouble
    implements ListBuilder {
        private final P parent;
        private final Map<String, Double> items = new HashMap<String, Double>();

        public Builder(P parent) {
            this.parent = parent;
        }

        public P end() {
            return this.parent;
        }

        public void nextItem(String item) {
            this.items.compute(item, (k, value) -> value != null ? value + 1.0 : 1.0);
        }

        public void accept(String item, Double weight) {
            if (this.items.putIfAbsent(item, weight) != null) {
                throw new BenchmarkDefinitionException("Duplicate item '" + item + "' in randomItem step!");
            }
        }

        public Builder<P> add(String item, double weight) {
            this.accept(item, weight);
            return this;
        }

        public WeightedGenerator build() {
            ArrayList<String> list = new ArrayList<String>();
            double[] cummulativeProbs = null;
            if (this.items.isEmpty()) {
                throw new BenchmarkDefinitionException("No items to pick from!");
            }
            if (this.items.values().stream().allMatch(v -> v == 1.0)) {
                return new WeightedGenerator(null, this.items.keySet().toArray(new String[0]));
            }
            cummulativeProbs = new double[this.items.size() - 1];
            double normalizer = this.items.values().stream().mapToDouble(Double::doubleValue).sum();
            double acc = 0.0;
            int i = 0;
            for (Map.Entry<String, Double> entry : this.items.entrySet()) {
                acc += entry.getValue() / normalizer;
                if (i < this.items.size() - 1) {
                    cummulativeProbs[i++] = acc;
                } else assert (acc > 0.999 && acc <= 1.001);
                list.add(entry.getKey());
            }
            return new WeightedGenerator(cummulativeProbs, list.toArray(new String[0]));
        }
    }
}

