/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;

class BaseSearchContext
implements Session.Resource {
    private static final int MAX_PARTS = 16;
    ByteBuf[] parts = new ByteBuf[16];
    int[] startIndices = new int[16];
    int[] endIndices = new int[16];
    int currentPart = -1;
    int hashedBytes;
    int currentHash;

    BaseSearchContext() {
    }

    static int computeHash(byte[] bytes) {
        int hash = 0;
        for (byte b : bytes) {
            hash = 31 * hash + b;
        }
        return hash;
    }

    static int computeCoef(int length) {
        int value = 1;
        for (int i = length; i > 0; --i) {
            value *= 31;
        }
        return value;
    }

    void add(ByteBuf data, int offset, int length) {
        ++this.currentPart;
        if (this.currentPart >= this.parts.length) {
            this.shiftParts();
        }
        this.parts[this.currentPart] = data.retain();
        this.startIndices[this.currentPart] = offset;
        this.endIndices[this.currentPart] = offset + length;
    }

    int initHash(int index, int lookupLength) {
        ByteBuf data = this.parts[this.currentPart];
        while (index < this.endIndices[this.currentPart] && this.hashedBytes < lookupLength) {
            this.currentHash = 31 * this.currentHash + data.getByte(index++);
            ++this.hashedBytes;
        }
        return index;
    }

    void shiftParts() {
        this.parts[0].release();
        System.arraycopy(this.parts, 1, this.parts, 0, this.parts.length - 1);
        System.arraycopy(this.startIndices, 1, this.startIndices, 0, this.startIndices.length - 1);
        System.arraycopy(this.endIndices, 1, this.endIndices, 0, this.endIndices.length - 1);
        --this.currentPart;
    }

    int byteRelative(int currentIndex, int numBytesBack) {
        int part = this.currentPart;
        int currentBytesRead = currentIndex - this.startIndices[part];
        if (numBytesBack <= currentBytesRead) {
            return this.parts[part].getByte(currentIndex - numBytesBack);
        }
        numBytesBack -= currentBytesRead;
        --part;
        while (numBytesBack > this.endIndices[part] - this.startIndices[part]) {
            numBytesBack -= this.endIndices[part] - this.startIndices[part];
            --part;
        }
        return this.parts[part].getByte(this.endIndices[part] - numBytesBack);
    }

    void reset() {
        this.hashedBytes = 0;
        this.currentHash = 0;
        this.currentPart = -1;
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            this.parts[i].release();
            this.parts[i] = null;
        }
    }

    void advance(byte c, int coef, int currentIndex, int numBytesBack) {
        this.currentHash = 31 * this.currentHash + c - coef * this.byteRelative(currentIndex, numBytesBack);
    }
}

