/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefragProcessor
extends Processor.BaseDelegating
implements ResourceUtilizer,
Session.ResourceKey<Context> {
    private static final Logger log = LogManager.getLogger(DefragProcessor.class);

    public static Processor of(Processor delegate, boolean fragmented) {
        return fragmented ? new DefragProcessor(delegate) : delegate;
    }

    public DefragProcessor(Processor delegate) {
        super(delegate);
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        if (isLastPart && !ctx.isBuffering()) {
            this.delegate.process(session, data, offset, length, true);
            return;
        }
        if (data.isReadable()) {
            ctx.buffer(data, offset, length);
        }
        if (isLastPart) {
            ctx.flush(session, this.delegate);
        }
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, Context::new);
    }

    static class Context
    implements Session.Resource {
        CompositeByteBuf composite = null;

        Context() {
        }

        boolean isBuffering() {
            return this.composite != null && this.composite.isReadable();
        }

        public void buffer(ByteBuf data, int offset, int length) {
            log.debug("Buffering {} bytes", (Object)length);
            if (this.composite == null) {
                this.composite = new CompositeByteBuf(data.alloc(), data.isDirect(), 16);
            }
            this.composite.addComponent(true, data.retainedSlice(offset, length));
        }

        void flush(Session session, Processor processor) {
            log.debug("Flushing {} bytes", (Object)this.composite.writerIndex());
            processor.process(session, (ByteBuf)this.composite, 0, this.composite.writerIndex(), true);
            this.composite.readerIndex(this.composite.writerIndex());
            this.composite.discardReadComponents();
        }

        public void destroy() {
            if (this.composite != null) {
                this.composite.release();
            }
        }
    }
}

