/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefragTransformer
extends Transformer.BaseDelegating
implements ResourceUtilizer,
Session.ResourceKey<Context> {
    private static final Logger log = LogManager.getLogger(DefragTransformer.class);

    public DefragTransformer(Transformer delegate) {
        super(delegate);
    }

    public void transform(Session session, ByteBuf in, int offset, int length, boolean lastFragment, ByteBuf out) {
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        if (lastFragment && !ctx.isBuffering()) {
            this.delegate.transform(session, in, offset, length, true, out);
            return;
        }
        if (in.isReadable()) {
            ctx.buffer(in, offset, length);
        }
        if (lastFragment) {
            ctx.flush(session, this.delegate, out);
        }
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, Context::new);
    }

    static class Context
    implements Session.Resource {
        CompositeByteBuf composite = null;

        Context() {
        }

        boolean isBuffering() {
            return this.composite != null && this.composite.isReadable();
        }

        public void buffer(ByteBuf data, int offset, int length) {
            log.debug("Buffering {} bytes", (Object)length);
            if (this.composite == null) {
                this.composite = new CompositeByteBuf(data.alloc(), data.isDirect(), 16);
            }
            this.composite.addComponent(true, data.retainedSlice(offset, length));
        }

        void flush(Session session, Transformer transformer, ByteBuf out) {
            log.debug("Flushing {} bytes", (Object)this.composite.writerIndex());
            transformer.transform(session, (ByteBuf)this.composite, 0, this.composite.writerIndex(), true, out);
            this.composite.readerIndex(this.composite.writerIndex());
            this.composite.discardReadComponents();
        }

        public void destroy() {
            if (this.composite != null) {
                this.composite.release();
            }
        }
    }
}

