/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSequenceAction
implements Action {
    private static final Logger log = LogManager.getLogger(NewSequenceAction.class);
    private final String sequence;
    private final boolean forceSameIndex;
    private final Session.ConcurrencyPolicy policy;

    public NewSequenceAction(String sequence, boolean forceSameIndex, Session.ConcurrencyPolicy policy) {
        this.sequence = sequence;
        this.forceSameIndex = forceSameIndex;
        this.policy = policy;
    }

    public void run(Session session) {
        session.startSequence(this.sequence, this.forceSameIndex, this.policy);
    }

    @Name(value="newSequence")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String sequence;
        private boolean forceSameIndex;
        private Session.ConcurrencyPolicy policy = Session.ConcurrencyPolicy.FAIL;

        public Builder init(String param) {
            return this.sequence(param);
        }

        @Deprecated
        public Builder maxSequences(int maxSequences) {
            log.warn("Property newSequence.maxSequences is deprecated. Use concurrency setting in target sequence instead.");
            return this;
        }

        @Deprecated
        public Builder counterVar(String counterVar) {
            log.warn("Property nextSequence.maxSequences is deprecated. Counters are held internally.");
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder forceSameIndex(boolean force) {
            this.forceSameIndex = force;
            return this;
        }

        public Builder concurrencyPolicy(Session.ConcurrencyPolicy policy) {
            this.policy = policy;
            return this;
        }

        public NewSequenceAction build() {
            if (this.sequence == null) {
                throw new BenchmarkDefinitionException("Undefined sequence template");
            }
            return new NewSequenceAction(this.sequence, this.forceSameIndex, this.policy);
        }
    }
}

